/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sysml.runtime.util.SortUtils;

public class SparseRow
implements Serializable {
    private static final long serialVersionUID = 5806895317005796456L;
    public static final int initialCapacity = 4;
    private int estimatedNzs = 4;
    private int maxNzs = Integer.MAX_VALUE;
    private int size = 0;
    private double[] values = null;
    private int[] indexes = null;

    public SparseRow() {
        this(4);
    }

    public SparseRow(int capacity) {
        this.estimatedNzs = capacity;
        this.values = new double[capacity];
        this.indexes = new int[capacity];
    }

    public SparseRow(int estnnz, int maxnnz) {
        if (estnnz > 4) {
            this.estimatedNzs = estnnz;
        }
        this.maxNzs = maxnnz;
        int capacity = estnnz < 4 && estnnz > 0 ? estnnz : 4;
        this.values = new double[capacity];
        this.indexes = new int[capacity];
    }

    public SparseRow(SparseRow that) {
        this.size = that.size;
        int cap = Math.max(4, that.size);
        this.values = Arrays.copyOf(that.values, cap);
        this.indexes = Arrays.copyOf(that.indexes, cap);
    }

    public int size() {
        return this.size;
    }

    public void setSize(int newsize) {
        this.size = newsize;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public double[] values() {
        return this.values;
    }

    public int[] indexes() {
        return this.indexes;
    }

    public void setValues(double[] d) {
        this.values = d;
    }

    public void setIndexes(int[] i) {
        this.indexes = i;
    }

    public int capacity() {
        return this.values.length;
    }

    public void copy(SparseRow that) {
        if (this.values.length < that.size) {
            this.values = Arrays.copyOf(that.values, that.size);
            this.indexes = Arrays.copyOf(that.indexes, that.size);
        } else {
            System.arraycopy(that.values, 0, this.values, 0, that.size);
            System.arraycopy(that.indexes, 0, this.indexes, 0, that.size);
        }
        this.size = that.size;
    }

    public void reset(int estnns, int maxnns) {
        this.estimatedNzs = estnns;
        this.maxNzs = maxnns;
        this.size = 0;
    }

    public void recap(int newCap) {
        if (newCap <= this.values.length) {
            return;
        }
        this.values = Arrays.copyOf(this.values, newCap);
        this.indexes = Arrays.copyOf(this.indexes, newCap);
    }

    private int newCapacity() {
        if (this.values.length < this.estimatedNzs) {
            return Math.min(this.estimatedNzs, this.values.length * 2);
        }
        return (int)Math.min((double)this.maxNzs, Math.ceil((double)this.values.length * 1.1));
    }

    public void compact() {
        int nnz = 0;
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] == 0.0) continue;
            this.values[nnz] = this.values[i];
            this.indexes[nnz] = this.indexes[i];
            ++nnz;
        }
        this.size = nnz;
    }

    public boolean set(int col, double v) {
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            if (v == 0.0) {
                this.shiftLeftAndDelete(index);
                return true;
            }
            this.values[index] = v;
            return false;
        }
        if (v == 0.0) {
            return false;
        }
        index = Math.abs(index + 1);
        if (this.size == this.values.length) {
            this.resizeAndInsert(index, col, v);
        } else {
            this.shiftRightAndInsert(index, col, v);
        }
        return true;
    }

    public void append(int col, double v) {
        if (v == 0.0) {
            return;
        }
        if (this.size == this.values.length) {
            this.recap(this.newCapacity());
        }
        this.values[this.size] = v;
        this.indexes[this.size] = col;
        ++this.size;
    }

    public double get(int col) {
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            return this.values[index];
        }
        return 0.0;
    }

    public int searchIndexesFirstLTE(int col) {
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            if (index < this.size) {
                return index;
            }
            return -1;
        }
        if ((index = Math.abs(index + 1)) - 1 < this.size) {
            return index - 1;
        }
        return -1;
    }

    public int searchIndexesFirstGTE(int col) {
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            if (index < this.size) {
                return index;
            }
            return -1;
        }
        if ((index = Math.abs(index + 1)) < this.size) {
            return index;
        }
        return -1;
    }

    public int searchIndexesFirstGT(int col) {
        int index = Arrays.binarySearch(this.indexes, 0, this.size, col);
        if (index >= 0) {
            if (index + 1 < this.size) {
                return index + 1;
            }
            return -1;
        }
        if ((index = Math.abs(index + 1)) < this.size) {
            return index;
        }
        return -1;
    }

    public void deleteIndexRange(int lowerCol, int upperCol) {
        int start = this.searchIndexesFirstGTE(lowerCol);
        if (start < 0) {
            return;
        }
        int end = this.searchIndexesFirstGT(upperCol);
        if (end < 0) {
            end = this.size;
        }
        System.arraycopy(this.values, end, this.values, start, this.size - end);
        System.arraycopy(this.indexes, end, this.indexes, start, this.size - end);
        this.size -= end - start;
    }

    public void setIndexRange(int lowerCol, int upperCol, double[] v, int vix, int len) {
        int start = this.searchIndexesFirstGTE(lowerCol);
        if (start < 0) {
            for (int i = vix; i < vix + len; ++i) {
                this.append(lowerCol + i - vix, v[i]);
            }
            return;
        }
        int end = this.searchIndexesFirstGT(upperCol);
        if (end < 0) {
            this.size = start;
            for (int i = vix; i < vix + len; ++i) {
                this.append(lowerCol + i - vix, v[i]);
            }
            return;
        }
        int lnnz = 0;
        for (int i = vix; i < vix + len; ++i) {
            lnnz += v[i] != 0.0 ? 1 : 0;
        }
        int lsize = this.size + lnnz - (end - start);
        if (this.values.length < lsize) {
            this.recap(lsize);
        }
        this.shiftRightByN(end, lnnz - (end - start));
        int pos = start;
        for (int i = vix; i < vix + len; ++i) {
            if (v[i] == 0.0) continue;
            this.values[pos] = v[i];
            this.indexes[pos] = lowerCol + i - vix;
            ++pos;
        }
    }

    private void resizeAndInsert(int index, int col, double v) {
        int newCap = this.newCapacity();
        double[] oldvalues = this.values;
        int[] oldindexes = this.indexes;
        this.values = new double[newCap];
        this.indexes = new int[newCap];
        System.arraycopy(oldvalues, 0, this.values, 0, index);
        System.arraycopy(oldindexes, 0, this.indexes, 0, index);
        this.indexes[index] = col;
        this.values[index] = v;
        System.arraycopy(oldvalues, index, this.values, index + 1, this.size - index);
        System.arraycopy(oldindexes, index, this.indexes, index + 1, this.size - index);
        ++this.size;
    }

    private void shiftRightAndInsert(int index, int col, double v) {
        System.arraycopy(this.values, index, this.values, index + 1, this.size - index);
        System.arraycopy(this.indexes, index, this.indexes, index + 1, this.size - index);
        this.values[index] = v;
        this.indexes[index] = col;
        ++this.size;
    }

    private void shiftRightByN(int index, int n) {
        System.arraycopy(this.values, index, this.values, index + n, this.size - index);
        System.arraycopy(this.indexes, index, this.indexes, index + n, this.size - index);
        this.size += n;
    }

    private void shiftLeftAndDelete(int index) {
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        System.arraycopy(this.indexes, index + 1, this.indexes, index, this.size - index - 1);
        --this.size;
    }

    public void sort() {
        if (this.size <= 100 || !SortUtils.isSorted(0, this.size, this.indexes)) {
            SortUtils.sortByIndex(0, this.size, this.indexes, this.values);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.indexes[i]);
            sb.append(": ");
            sb.append(this.values[i]);
            sb.append("\t");
        }
        return sb.toString();
    }
}

