/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlockCOO;
import org.apache.sysml.runtime.matrix.data.SparseBlockCSR;
import org.apache.sysml.runtime.matrix.data.SparseBlockMCSR;

public abstract class SparseBlockFactory {
    public static SparseBlock createSparseBlock(int rlen) {
        return SparseBlockFactory.createSparseBlock(MatrixBlock.DEFAULT_SPARSEBLOCK, rlen);
    }

    public static SparseBlock createSparseBlock(SparseBlock.Type type, int rlen) {
        switch (type) {
            case MCSR: {
                return new SparseBlockMCSR(rlen, -1);
            }
            case CSR: {
                return new SparseBlockCSR(rlen);
            }
            case COO: {
                return new SparseBlockCOO(rlen);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }

    public static SparseBlock copySparseBlock(SparseBlock.Type type, SparseBlock sblock, boolean forceCopy) {
        if (sblock == null) {
            return null;
        }
        if (!forceCopy && (sblock instanceof SparseBlockMCSR && type == SparseBlock.Type.MCSR || sblock instanceof SparseBlockCSR && type == SparseBlock.Type.CSR || sblock instanceof SparseBlockCOO && type == SparseBlock.Type.COO)) {
            return sblock;
        }
        switch (type) {
            case MCSR: {
                return new SparseBlockMCSR(sblock);
            }
            case CSR: {
                return new SparseBlockCSR(sblock);
            }
            case COO: {
                return new SparseBlockCOO(sblock);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }

    public static long estimateSizeSparseInMemory(SparseBlock.Type type, long nrows, long ncols, double sparsity) {
        switch (type) {
            case MCSR: {
                return SparseBlockMCSR.estimateMemory(nrows, ncols, sparsity);
            }
            case CSR: {
                return SparseBlockCSR.estimateMemory(nrows, ncols, sparsity);
            }
            case COO: {
                return SparseBlockCOO.estimateMemory(nrows, ncols, sparsity);
            }
        }
        throw new RuntimeException("Unexpected sparse block type: " + type.toString());
    }
}

