/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.sysml.lops.runtime.RunMRJobs;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.SPInstructionParser;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.utils.Statistics;

public abstract class SPInstruction
extends Instruction {
    protected SPINSTRUCTION_TYPE _sptype;
    protected Operator _optr;
    protected boolean _requiresLabelUpdate = false;

    public SPInstruction(String opcode, String istr) {
        this.type = Instruction.INSTRUCTION_TYPE.SPARK;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    public SPInstruction(Operator op, String opcode, String istr) {
        this(opcode, istr);
        this._optr = op;
    }

    public SPINSTRUCTION_TYPE getSPInstructionType() {
        return this._sptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = RunMRJobs.updateLabels(tmp.toString(), ec.getVariables());
            tmp = SPInstructionParser.parseSingleInstruction(updInst);
        }
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1) throws DMLRuntimeException;

    @Override
    public void postprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Statistics.incrementNoOfExecutedSPInst();
        super.postprocessInstruction(ec);
    }

    public static enum SPINSTRUCTION_TYPE {
        MAPMM,
        MAPMMCHAIN,
        CPMM,
        RMM,
        TSMM,
        TSMM2,
        PMM,
        ZIPMM,
        PMAPMM,
        MatrixIndexing,
        Reorg,
        ArithmeticBinary,
        RelationalBinary,
        AggregateUnary,
        AggregateTernary,
        Reblock,
        CSVReblock,
        Builtin,
        BuiltinUnary,
        BuiltinBinary,
        MultiReturnBuiltin,
        Checkpoint,
        Compression,
        Cast,
        CentralMoment,
        Covariance,
        QSort,
        QPick,
        ParameterizedBuiltin,
        MAppend,
        RAppend,
        GAppend,
        GAlignedAppend,
        Rand,
        MatrixReshape,
        Ternary,
        Quaternary,
        CumsumAggregate,
        CumsumOffset,
        BinUaggChain,
        UaggOuterChain,
        Write,
        SpoofFused,
        INVALID,
        Convolution;

    }
}

