/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class MatrixReshapeSPInstruction
extends UnarySPInstruction {
    private CPOperand _opRows = null;
    private CPOperand _opCols = null;
    private CPOperand _opByRow = null;

    public MatrixReshapeSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String istr) {
        super(op, in1, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.MatrixReshape;
        this._opRows = in2;
        this._opCols = in3;
        this._opByRow = in4;
    }

    public static MatrixReshapeSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand in4 = new CPOperand(parts[4]);
        CPOperand out = new CPOperand(parts[5]);
        if (!opcode.equalsIgnoreCase("rshape")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MatrixReshapeInstruction: " + str);
        }
        return new MatrixReshapeSPInstruction(new Operator(true), in1, in2, in3, in4, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        int rows = (int)ec.getScalarInput(this._opRows.getName(), this._opRows.getValueType(), this._opRows.isLiteral()).getLongValue();
        int cols = (int)ec.getScalarInput(this._opCols.getName(), this._opCols.getValueType(), this._opCols.isLiteral()).getLongValue();
        boolean byRow = ec.getScalarInput(this._opByRow.getName(), Expression.ValueType.BOOLEAN, this._opByRow.isLiteral()).getBooleanValue();
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        mcOut.set(rows, cols, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock());
        if (mcIn.getRows() * mcIn.getCols() != mcOut.getRows() * mcOut.getCols()) {
            throw new DMLRuntimeException("Incompatible matrix characteristics for reshape: " + mcIn.getRows() + "x" + mcIn.getCols() + " vs " + mcOut.getRows() + "x" + mcOut.getCols());
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.flatMapToPair((PairFlatMapFunction)new RDDReshapeFunction(mcIn, mcOut, byRow));
        out = RDDAggregateUtils.mergeByKey(out);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    private static class RDDReshapeFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 2819309412002224478L;
        private MatrixCharacteristics _mcIn = null;
        private MatrixCharacteristics _mcOut = null;
        private boolean _byrow = true;

        public RDDReshapeFunction(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut, boolean byrow) {
            this._mcIn = mcIn;
            this._mcOut = mcOut;
            this._byrow = byrow;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            IndexedMatrixValue in = SparkUtils.toIndexedMatrixBlock(arg0);
            ArrayList<IndexedMatrixValue> out = new ArrayList<IndexedMatrixValue>();
            out = LibMatrixReorg.reshape(in, this._mcIn.getRows(), this._mcIn.getCols(), this._mcIn.getRowsPerBlock(), this._mcIn.getRowsPerBlock(), out, this._mcOut.getRows(), this._mcOut.getCols(), this._mcOut.getRowsPerBlock(), this._mcOut.getColsPerBlock(), this._byrow);
            return SparkUtils.fromIndexedMatrixBlock(out).iterator();
        }
    }
}

