/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.functions.AggregateDropCorrectionFunction;
import org.apache.sysml.runtime.instructions.spark.functions.FilterDiagBlocksFunction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import scala.Tuple2;

public class AggregateUnarySPInstruction
extends UnarySPInstruction {
    private AggBinaryOp.SparkAggType _aggtype = null;
    private AggregateOperator _aop = null;

    public AggregateUnarySPInstruction(AggregateUnaryOperator auop, AggregateOperator aop, CPOperand in, CPOperand out, AggBinaryOp.SparkAggType aggtype, String opcode, String istr) {
        super(auop, in, out, opcode, istr);
        this._aggtype = aggtype;
        this._aop = aop;
    }

    public static AggregateUnarySPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        AggBinaryOp.SparkAggType aggtype = AggBinaryOp.SparkAggType.valueOf(parts[3]);
        String aopcode = InstructionUtils.deriveAggregateOperatorOpcode(opcode);
        PartialAggregate.CorrectionLocationType corrLoc = InstructionUtils.deriveAggregateOperatorCorrectionLocation(opcode);
        String corrExists = corrLoc != PartialAggregate.CorrectionLocationType.NONE ? "true" : "false";
        AggregateUnaryOperator aggun = InstructionUtils.parseBasicAggregateUnaryOperator(opcode);
        AggregateOperator aop = InstructionUtils.parseAggregateOperator(aopcode, corrExists, corrLoc.toString());
        return new AggregateUnarySPInstruction(aggun, aop, in1, out, aggtype, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        JavaPairRDD in;
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input1.getName());
        JavaPairRDD out = in = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        if (this.getOpcode().equalsIgnoreCase("uaktrace")) {
            out = out.filter((Function)new FilterDiagBlocksFunction());
        }
        AggregateUnaryOperator auop = (AggregateUnaryOperator)this._optr;
        AggregateOperator aggop = this._aop;
        if (this._aggtype == AggBinaryOp.SparkAggType.SINGLE_BLOCK) {
            JavaRDD out2 = out.map((Function)new RDDUAggFunction2(auop, mc.getRowsPerBlock(), mc.getColsPerBlock()));
            MatrixBlock out3 = RDDAggregateUtils.aggStable((JavaRDD<MatrixBlock>)out2, aggop);
            out3.dropLastRowsOrColums(aggop.correctionLocation);
            sec.setMatrixOutput(this.output.getName(), out3);
        } else {
            if (this._aggtype == AggBinaryOp.SparkAggType.NONE) {
                out = out.mapValues((Function)new RDDUAggValueFunction(auop, mc.getRowsPerBlock(), mc.getColsPerBlock()));
            } else if (this._aggtype == AggBinaryOp.SparkAggType.MULTI_BLOCK) {
                out = out.mapToPair((PairFunction)new RDDUAggFunction(auop, mc.getRowsPerBlock(), mc.getColsPerBlock()));
                out = RDDAggregateUtils.aggByKeyStable((JavaPairRDD<MatrixIndexes, MatrixBlock>)out, aggop, false);
                if (auop.aggOp.correctionExists) {
                    out = out.mapValues((Function)new AggregateDropCorrectionFunction(aggop));
                }
            }
            this.updateUnaryAggOutputMatrixCharacteristics(sec, auop.indexFn);
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        }
    }

    private static class RDDUAggValueFunction
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = 5352374590399929673L;
        private AggregateUnaryOperator _op = null;
        private int _brlen = -1;
        private int _bclen = -1;
        private MatrixIndexes _ix = null;

        public RDDUAggValueFunction(AggregateUnaryOperator op, int brlen, int bclen) {
            this._op = op;
            this._brlen = brlen;
            this._bclen = bclen;
            this._ix = new MatrixIndexes(1L, 1L);
        }

        public MatrixBlock call(MatrixBlock arg0) throws Exception {
            MatrixBlock blkOut = new MatrixBlock();
            arg0.aggregateUnaryOperations(this._op, blkOut, this._brlen, this._bclen, this._ix);
            blkOut.dropLastRowsOrColums(this._op.aggOp.correctionLocation);
            return blkOut;
        }
    }

    private static class RDDUAggFunction2
    implements Function<Tuple2<MatrixIndexes, MatrixBlock>, MatrixBlock> {
        private static final long serialVersionUID = 2672082409287856038L;
        private AggregateUnaryOperator _op = null;
        private int _brlen = -1;
        private int _bclen = -1;

        public RDDUAggFunction2(AggregateUnaryOperator op, int brlen, int bclen) {
            this._op = op;
            this._brlen = brlen;
            this._bclen = bclen;
        }

        public MatrixBlock call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            return (MatrixBlock)((MatrixBlock)arg0._2).aggregateUnaryOperations(this._op, new MatrixBlock(), this._brlen, this._bclen, (MatrixIndexes)arg0._1());
        }
    }

    private static class RDDUAggFunction
    implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 2672082409287856038L;
        private AggregateUnaryOperator _op = null;
        private int _brlen = -1;
        private int _bclen = -1;

        public RDDUAggFunction(AggregateUnaryOperator op, int brlen, int bclen) {
            this._op = op;
            this._brlen = brlen;
            this._bclen = bclen;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            MatrixIndexes ixOut = new MatrixIndexes();
            MatrixBlock blkOut = new MatrixBlock();
            OperationsOnMatrixValues.performAggregateUnary(ixIn, blkIn, ixOut, blkOut, this._op, this._brlen, this._bclen);
            return new Tuple2((Object)ixOut, (Object)blkOut);
        }
    }
}

