/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class MatrixReshapeMRInstruction
extends UnaryInstruction {
    private long _rows = -1L;
    private long _cols = -1L;
    private boolean _byrow = false;
    private MatrixCharacteristics _mcIn = null;
    private ArrayList<IndexedMatrixValue> _cache = null;

    public MatrixReshapeMRInstruction(Operator op, byte in, long rows, long cols, boolean byrow, byte out, String istr) {
        super(op, in, out, istr);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.MMTSJ;
        this.instString = istr;
        this._rows = rows;
        this._cols = cols;
        this._byrow = byrow;
    }

    public void setMatrixCharacteristics(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut) {
        this._mcIn = mcIn;
    }

    public static MatrixReshapeMRInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 5);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        long rows = UtilFunctions.toLong(Double.parseDouble(parts[2]));
        long cols = UtilFunctions.toLong(Double.parseDouble(parts[3]));
        boolean byrow = Boolean.parseBoolean(parts[4]);
        byte out = Byte.parseByte(parts[5]);
        if (!opcode.equalsIgnoreCase("rshape")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MatrixReshapeMRInstruction: " + str);
        }
        return new MatrixReshapeMRInstruction(new Operator(true), in, rows, cols, byrow, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int brlen, int bclen) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue imv : blkList) {
                if (imv == null) continue;
                ArrayList<IndexedMatrixValue> out = this._cache;
                out = LibMatrixReorg.reshape(imv, this._mcIn.getRows(), this._mcIn.getCols(), brlen, bclen, out, this._rows, this._cols, brlen, bclen, this._byrow);
                for (IndexedMatrixValue outBlk : out) {
                    cachedValues.add(this.output, outBlk);
                }
            }
        }
    }

    public long getNumRows() {
        return this._rows;
    }

    public long getNumColunms() {
        return this._cols;
    }
}

