/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.lops.MMTSJ;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MMTSJMRInstruction
extends UnaryInstruction {
    private MMTSJ.MMTSJType _type = null;

    public MMTSJMRInstruction(Operator op, byte in, MMTSJ.MMTSJType type, byte out, String istr) {
        super(op, in, out, istr);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.MMTSJ;
        this.instString = istr;
        this._type = type;
    }

    public MMTSJ.MMTSJType getMMTSJType() {
        return this._type;
    }

    public static MMTSJMRInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in = Byte.parseByte(parts[1]);
        byte out = Byte.parseByte(parts[2]);
        MMTSJ.MMTSJType titype = MMTSJ.MMTSJType.valueOf(parts[3]);
        if (!opcode.equalsIgnoreCase("tsmm")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MMTIJMRInstruction: " + str);
        }
        return new MMTSJMRInstruction(new Operator(true), in, titype, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue imv : blkList) {
                if (imv == null) continue;
                MatrixValue in = imv.getValue();
                IndexedMatrixValue iout = null;
                iout = this.output == this.input ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                iout.getIndexes().setIndexes(1L, 1L);
                MatrixValue out = iout.getValue();
                if (!(in instanceof MatrixBlock) || !(out instanceof MatrixBlock)) {
                    throw new DMLRuntimeException("Types " + in.getClass() + " and " + out.getClass() + " incompatible with " + MatrixBlock.class);
                }
                ((MatrixBlock)in).transposeSelfMatrixMultOperations((MatrixBlock)out, this._type);
                if (iout != tempValue) continue;
                cachedValues.add(this.output, iout);
            }
        }
    }
}

