/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu.context;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jcuda.Pointer;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.instructions.gpu.context.JCudaContext;
import org.apache.sysml.runtime.instructions.gpu.context.JCudaObject;
import org.apache.sysml.utils.GPUStatistics;
import org.apache.sysml.utils.LRUCacheMap;

public abstract class GPUObject {
    public static final EvictionPolicy evictionPolicy = EvictionPolicy.LRU;
    protected boolean isDeviceCopyModified = false;
    protected AtomicInteger numLocks = new AtomicInteger(0);
    AtomicLong timestamp = new AtomicLong(0L);
    protected boolean isInSparseFormat = false;
    protected MatrixObject mat = null;
    static Boolean evictionLock = new Boolean(true);

    protected GPUObject(MatrixObject mat2) {
        this.mat = mat2;
    }

    public boolean isInSparseFormat() {
        return this.isInSparseFormat;
    }

    public abstract boolean isAllocated();

    public abstract boolean acquireDeviceRead() throws DMLRuntimeException;

    public abstract boolean acquireDeviceModifyDense() throws DMLRuntimeException;

    public abstract boolean acquireDeviceModifySparse() throws DMLRuntimeException;

    public abstract void setDeviceModify(long var1);

    public abstract boolean acquireHostRead() throws CacheException;

    public abstract void releaseInput() throws CacheException;

    public abstract void releaseOutput() throws CacheException;

    abstract void allocateDenseMatrixOnDevice() throws DMLRuntimeException;

    abstract void allocateSparseMatrixOnDevice() throws DMLRuntimeException;

    abstract void deallocateMemoryOnDevice(boolean var1) throws DMLRuntimeException;

    abstract long getSizeOnDevice() throws DMLRuntimeException;

    abstract void copyFromHostToDevice() throws DMLRuntimeException;

    abstract void copyFromDeviceToHost() throws DMLRuntimeException;

    protected static void evict(long GPUSize) throws DMLRuntimeException {
        GPUObject.evict(null, GPUSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void evict(String instructionName, final long GPUSize) throws DMLRuntimeException {
        Object object = JCudaContext.syncObj;
        synchronized (object) {
            GPUStatistics.cudaEvictionCount.addAndGet(1L);
            LRUCacheMap<Long, LinkedList<Pointer>> lruCacheMap = JCudaObject.freeCUDASpaceMap;
            while (lruCacheMap.size() > 0 && GPUSize > GPUObject.getAvailableMemory()) {
                Map.Entry<Long, LinkedList<Pointer>> toFreeListPair = lruCacheMap.removeAndGetLRUEntry();
                LinkedList<Pointer> toFreeList = toFreeListPair.getValue();
                Long size = toFreeListPair.getKey();
                Pointer toFree = toFreeList.pop();
                if (toFreeList.isEmpty()) {
                    lruCacheMap.remove(size);
                }
                JCudaObject.cudaFreeHelper(instructionName, toFree, true);
            }
            if (GPUSize <= GPUObject.getAvailableMemory()) {
                return;
            }
            if (JCudaContext.allocatedPointers.size() == 0) {
                throw new DMLRuntimeException("There is not enough memory on device for this matrix!");
            }
            Boolean bl = evictionLock;
            synchronized (bl) {
                Collections.sort(JCudaContext.allocatedPointers, new Comparator<GPUObject>(){

                    @Override
                    public int compare(GPUObject p1, GPUObject p2) {
                        long p1Val = p1.numLocks.get();
                        long p2Val = p2.numLocks.get();
                        if (p1Val > 0L && p2Val > 0L) {
                            return 0;
                        }
                        if (p1Val > 0L || p2Val > 0L) {
                            return Long.compare(p2Val, p1Val);
                        }
                        if (evictionPolicy == EvictionPolicy.MIN_EVICT) {
                            long p1Size = 0L;
                            long p2Size = 0L;
                            try {
                                p1Size = p1.getSizeOnDevice() - GPUSize;
                                p2Size = p2.getSizeOnDevice() - GPUSize;
                            }
                            catch (DMLRuntimeException e) {
                                throw new RuntimeException(e);
                            }
                            if (p1Size >= 0L && p2Size >= 0L) {
                                return Long.compare(p2Size, p1Size);
                            }
                            return Long.compare(p1Size, p2Size);
                        }
                        if (evictionPolicy == EvictionPolicy.LRU || evictionPolicy == EvictionPolicy.LFU) {
                            return Long.compare(p2.timestamp.get(), p1.timestamp.get());
                        }
                        throw new RuntimeException("Unsupported eviction policy:" + evictionPolicy.name());
                    }
                });
                while (GPUSize > GPUObject.getAvailableMemory() && JCudaContext.allocatedPointers.size() > 0) {
                    GPUObject toBeRemoved = JCudaContext.allocatedPointers.get(JCudaContext.allocatedPointers.size() - 1);
                    if (toBeRemoved.numLocks.get() > 0) {
                        throw new DMLRuntimeException("There is not enough memory on device for this matrix!");
                    }
                    if (toBeRemoved.isDeviceCopyModified) {
                        toBeRemoved.copyFromDeviceToHost();
                    }
                    toBeRemoved.clearData(true);
                }
            }
        }
    }

    public void clearData() throws CacheException {
        this.clearData(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(boolean eager) throws CacheException {
        Boolean bl = evictionLock;
        synchronized (bl) {
            JCudaContext.allocatedPointers.remove(this);
        }
        try {
            this.deallocateMemoryOnDevice(eager);
        }
        catch (DMLRuntimeException e) {
            throw new CacheException(e);
        }
    }

    protected static long getAvailableMemory() {
        return GPUContext.currContext.getAvailableMemory();
    }

    public static enum EvictionPolicy {
        LRU,
        LFU,
        MIN_EVICT;

    }
}

