/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.instructions.gpu.MatrixBuiltinGPUInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public abstract class BuiltinUnaryGPUInstruction
extends GPUInstruction {
    int _arity;
    CPOperand _input;
    CPOperand _output;

    public BuiltinUnaryGPUInstruction(Operator op, CPOperand in, CPOperand out, int _arity, String opcode, String istr) {
        super(op, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.BuiltinUnary;
        this._arity = _arity;
        this._input = in;
        this._output = out;
    }

    public int getArity() {
        return this._arity;
    }

    public static BuiltinUnaryGPUInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = null;
        Builtin func = null;
        if (parts.length == 4) {
            opcode = parts[0];
            in.split(parts[1]);
            out.split(parts[2]);
            func = Builtin.getBuiltinFnObject(opcode);
            throw new DMLRuntimeException("The instruction is not supported on GPU:" + str);
        }
        InstructionUtils.checkNumFields(str, 2);
        opcode = parts[0];
        in.split(parts[1]);
        out.split(parts[2]);
        func = Builtin.getBuiltinFnObject(opcode);
        if (in.getDataType() == Expression.DataType.SCALAR) {
            throw new DMLRuntimeException("The instruction is not supported on GPU:" + str);
        }
        if (in.getDataType() == Expression.DataType.MATRIX) {
            return new MatrixBuiltinGPUInstruction(new UnaryOperator(func), in, out, opcode, str);
        }
        return null;
    }
}

