/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.ArrayList;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.encode.EncoderFactory;

public class MultiReturnParameterizedBuiltinCPInstruction
extends ComputationCPInstruction {
    protected ArrayList<CPOperand> _outputs;

    public MultiReturnParameterizedBuiltinCPInstruction(Operator op, CPOperand input1, CPOperand input2, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(op, input1, input2, outputs.get(0), opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.MultiReturnBuiltin;
        this._outputs = outputs;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public static MultiReturnParameterizedBuiltinCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("transformencode")) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Expression.ValueType.STRING, Expression.DataType.FRAME));
            return new MultiReturnParameterizedBuiltinCPInstruction(null, in1, in2, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        FrameBlock fin = ec.getFrameInput(this.input1.getName());
        String spec = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral()).getStringValue();
        String[] colnames = fin.getColumnNames();
        Encoder encoder = EncoderFactory.createEncoder(spec, colnames, fin.getNumColumns(), null);
        MatrixBlock data = encoder.encode(fin, new MatrixBlock(fin.getNumRows(), fin.getNumColumns(), false));
        FrameBlock meta = encoder.getMetaData(new FrameBlock(fin.getNumColumns(), Expression.ValueType.STRING));
        meta.setColumnNames(colnames);
        ec.releaseFrameInput(this.input1.getName());
        ec.setMatrixOutput(this.getOutput(0).getName(), data);
        ec.setFrameOutput(this.getOutput(1).getName(), meta);
    }
}

