/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.io.MatrixWriterFactory;
import org.apache.sysml.runtime.io.WriterBinaryBlock;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class DataPartitionCPInstruction
extends UnaryCPInstruction {
    private ParForProgramBlock.PDataPartitionFormat _pformat = null;

    public DataPartitionCPInstruction(Operator op, CPOperand in1, ParForProgramBlock.PDataPartitionFormat pformat, CPOperand out, String opcode, String istr) {
        super(op, in1, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.MMTSJ;
        this._pformat = pformat;
    }

    public static DataPartitionCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        ParForProgramBlock.PDataPartitionFormat pformat = ParForProgramBlock.PDataPartitionFormat.valueOf(parts[3]);
        if (!opcode.equalsIgnoreCase("partition")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an DataPartitionCPInstruction: " + str);
        }
        return new DataPartitionCPInstruction(new Operator(true), in1, pformat, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixObject moIn = ec.getMatrixObject(this.input1.getName());
        MatrixBlock mb = (MatrixBlock)moIn.acquireRead();
        MatrixObject moOut = (MatrixObject)ec.getVariable(this.output.getName());
        String fname = moOut.getFileName();
        moOut.setPartitioned(this._pformat, -1);
        try {
            WriterBinaryBlock writer = (WriterBinaryBlock)MatrixWriterFactory.createMatrixWriter(OutputInfo.BinaryBlockOutputInfo);
            writer.writePartitionedBinaryBlockMatrixToHDFS(new Path(fname), new JobConf((Configuration)ConfigurationManager.getCachedJobConf()), mb, moIn.getNumRows(), moIn.getNumColumns(), (int)moIn.getNumRowsPerBlock(), (int)moIn.getNumColumnsPerBlock(), this._pformat);
            MatrixCharacteristics mc = new MatrixCharacteristics(moIn.getNumRows(), moIn.getNumColumns(), (int)moIn.getNumRowsPerBlock(), (int)moIn.getNumColumnsPerBlock(), moIn.getNnz());
            MatrixFormatMetaData meta = new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
            moOut.setMetaData(meta);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Failed to execute data partitioning instruction.", ex);
        }
        ec.releaseMatrixInput(this.input1.getName());
    }
}

