/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.COV;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.COVOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CovarianceCPInstruction
extends BinaryCPInstruction {
    public CovarianceCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.AggregateBinary;
    }

    public CovarianceCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, in3, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.AggregateBinary;
    }

    public static CovarianceCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in3 = null;
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cov")) {
            throw new DMLRuntimeException("CovarianceCPInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        COVOperator cov = new COVOperator(COV.getCOMFnObject());
        if (parts.length == 4) {
            CovarianceCPInstruction.parseBinaryInstruction(str, in1, in2, out);
            return new CovarianceCPInstruction(cov, in1, in2, out, opcode, str);
        }
        if (parts.length == 5) {
            in3 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
            CovarianceCPInstruction.parseBinaryInstruction(str, in1, in2, in3, out);
            return new CovarianceCPInstruction(cov, in1, in2, in3, out, opcode, str);
        }
        throw new DMLRuntimeException("Invalid number of arguments in Instruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName());
        String output_name = this.output.getName();
        COVOperator cov_op = (COVOperator)this._optr;
        CM_COV_Object covobj = new CM_COV_Object();
        if (this.input3 == null) {
            covobj = matBlock1.covOperations(cov_op, matBlock2);
            ec.releaseMatrixInput(this.input1.getName());
            ec.releaseMatrixInput(this.input2.getName());
        } else {
            MatrixBlock wtBlock = ec.getMatrixInput(this.input3.getName());
            covobj = matBlock1.covOperations(cov_op, matBlock2, wtBlock);
            ec.releaseMatrixInput(this.input1.getName());
            ec.releaseMatrixInput(this.input2.getName());
            ec.releaseMatrixInput(this.input3.getName());
        }
        double val = covobj.getRequiredResult(this._optr);
        DoubleObject ret = new DoubleObject(output_name, val);
        ec.setScalarOutput(output_name, ret);
    }
}

