/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.CMOperator;

public class CentralMomentCPInstruction
extends AggregateUnaryCPInstruction {
    public CentralMomentCPInstruction(CMOperator cm, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String str) {
        super(cm, in1, in2, in3, out, opcode, str);
    }

    public static CentralMomentCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        int cmOrder;
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand in3 = null;
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cm")) {
            throw new DMLRuntimeException("Unsupported opcode " + opcode);
        }
        if (parts.length == 4) {
            in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
            CentralMomentCPInstruction.parseUnaryInstruction(str, in1, in2, out);
        } else if (parts.length == 5) {
            in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
            in3 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
            CentralMomentCPInstruction.parseUnaryInstruction(str, in1, in2, in3, out);
        }
        try {
            cmOrder = in3 == null ? Integer.parseInt(in2.getName()) : Integer.parseInt(in3.getName());
        }
        catch (NumberFormatException e) {
            cmOrder = -1;
        }
        CMOperator.AggregateOperationTypes opType = CMOperator.getCMAggOpType(cmOrder);
        CMOperator cm = new CMOperator(CM.getCMFnObject(opType), opType);
        return new CentralMomentCPInstruction(cm, in1, in2, in3, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String output_name = this.output.getName();
        MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
        CPOperand scalarInput = this.input3 == null ? this.input2 : this.input3;
        ScalarObject order = ec.getScalarInput(scalarInput.getName(), scalarInput.getValueType(), scalarInput.isLiteral());
        CMOperator cm_op = (CMOperator)this._optr;
        if (cm_op.getAggOpType() == CMOperator.AggregateOperationTypes.INVALID) {
            ((CMOperator)this._optr).setCMAggOp((int)order.getLongValue());
        }
        CM_COV_Object cmobj = null;
        if (this.input3 == null) {
            cmobj = matBlock.cmOperations(cm_op);
        } else {
            MatrixBlock wtBlock = ec.getMatrixInput(this.input2.getName());
            cmobj = matBlock.cmOperations(cm_op, wtBlock);
            ec.releaseMatrixInput(this.input2.getName());
        }
        ec.releaseMatrixInput(this.input1.getName());
        double val = cmobj.getRequiredResult(this._optr);
        DoubleObject ret = new DoubleObject(output_name, val);
        ec.setScalarOutput(output_name, ret);
    }
}

