/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.lops.runtime.RunMRJobs;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class CPInstruction
extends Instruction {
    protected CPINSTRUCTION_TYPE _cptype;
    protected Operator _optr;
    protected boolean _requiresLabelUpdate = false;

    public CPInstruction(String opcode, String istr) {
        this.type = Instruction.INSTRUCTION_TYPE.CONTROL_PROGRAM;
        this.instString = istr;
        this.instOpcode = opcode;
        this._requiresLabelUpdate = super.requiresLabelUpdate();
    }

    public CPInstruction(Operator op, String opcode, String istr) {
        this(opcode, istr);
        this._optr = op;
    }

    public CPINSTRUCTION_TYPE getCPInstructionType() {
        return this._cptype;
    }

    @Override
    public boolean requiresLabelUpdate() {
        return this._requiresLabelUpdate;
    }

    @Override
    public String getGraphString() {
        return this.getOpcode();
    }

    @Override
    public Instruction preprocessInstruction(ExecutionContext ec) throws DMLRuntimeException {
        Instruction tmp = super.preprocessInstruction(ec);
        if (tmp.requiresLabelUpdate()) {
            String updInst = RunMRJobs.updateLabels(tmp.toString(), ec.getVariables());
            tmp = CPInstructionParser.parseSingleInstruction(updInst);
        }
        return tmp;
    }

    @Override
    public abstract void processInstruction(ExecutionContext var1) throws DMLRuntimeException;

    public static enum CPINSTRUCTION_TYPE {
        INVALID,
        AggregateUnary,
        AggregateBinary,
        AggregateTernary,
        ArithmeticBinary,
        Ternary,
        Quaternary,
        BooleanBinary,
        BooleanUnary,
        BuiltinBinary,
        BuiltinUnary,
        BuiltinMultiple,
        MultiReturnParameterizedBuiltin,
        ParameterizedBuiltin,
        MultiReturnBuiltin,
        Builtin,
        Reorg,
        RelationalBinary,
        File,
        Variable,
        External,
        Append,
        Rand,
        QSort,
        QPick,
        MatrixIndexing,
        MMTSJ,
        PMMJ,
        MMChain,
        MatrixReshape,
        Partition,
        Compression,
        SpoofFused,
        StringInit,
        CentralMoment,
        Covariance,
        UaggOuterChain,
        Convolution;

    }
}

