/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions;

import java.util.HashMap;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.AggregateTernaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ArithmeticBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BooleanBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BooleanUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BuiltinBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BuiltinMultipleCPInstruction;
import org.apache.sysml.runtime.instructions.cp.BuiltinUnaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CentralMomentCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CompressionCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ConvolutionCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CovarianceCPInstruction;
import org.apache.sysml.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysml.runtime.instructions.cp.DataPartitionCPInstruction;
import org.apache.sysml.runtime.instructions.cp.FileCPInstruction;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MMChainCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MMTSJCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MatrixReshapeCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.PMMJCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysml.runtime.instructions.cp.PlusMultCPInstruction;
import org.apache.sysml.runtime.instructions.cp.QuantilePickCPInstruction;
import org.apache.sysml.runtime.instructions.cp.QuantileSortCPInstruction;
import org.apache.sysml.runtime.instructions.cp.QuaternaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.RelationalBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysml.runtime.instructions.cp.SpoofCPInstruction;
import org.apache.sysml.runtime.instructions.cp.StringInitCPInstruction;
import org.apache.sysml.runtime.instructions.cp.TernaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.UaggOuterChainCPInstruction;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.runtime.instructions.cpfile.MatrixIndexingCPFileInstruction;
import org.apache.sysml.runtime.instructions.cpfile.ParameterizedBuiltinCPFileInstruction;

public class CPInstructionParser
extends InstructionParser {
    public static final HashMap<String, CPInstruction.CPINSTRUCTION_TYPE> String2CPInstructionType = new HashMap();
    public static final HashMap<String, CPInstruction.CPINSTRUCTION_TYPE> String2CPFileInstructionType;

    public static CPInstruction parseSingleInstruction(String str) throws DMLRuntimeException {
        if (str == null || str.isEmpty()) {
            return null;
        }
        CPInstruction.CPINSTRUCTION_TYPE cptype = InstructionUtils.getCPType(str);
        if (cptype == null) {
            throw new DMLRuntimeException("Unable derive cptype for instruction: " + str);
        }
        CPInstruction cpinst = CPInstructionParser.parseSingleInstruction(cptype, str);
        if (cpinst == null) {
            throw new DMLRuntimeException("Unable to parse instruction: " + str);
        }
        return cpinst;
    }

    public static CPInstruction parseSingleInstruction(CPInstruction.CPINSTRUCTION_TYPE cptype, String str) throws DMLRuntimeException {
        LopProperties.ExecType execType = null;
        if (str == null || str.isEmpty()) {
            return null;
        }
        switch (cptype) {
            case AggregateUnary: {
                return AggregateUnaryCPInstruction.parseInstruction(str);
            }
            case AggregateBinary: {
                return AggregateBinaryCPInstruction.parseInstruction(str);
            }
            case AggregateTernary: {
                return AggregateTernaryCPInstruction.parseInstruction(str);
            }
            case ArithmeticBinary: {
                String opcode = InstructionUtils.getOpCode(str);
                if (opcode.equals("+*") || opcode.equals("-*")) {
                    return PlusMultCPInstruction.parseInstruction(str);
                }
                return ArithmeticBinaryCPInstruction.parseInstruction(str);
            }
            case Ternary: {
                return TernaryCPInstruction.parseInstruction(str);
            }
            case Quaternary: {
                return QuaternaryCPInstruction.parseInstruction(str);
            }
            case BooleanBinary: {
                return BooleanBinaryCPInstruction.parseInstruction(str);
            }
            case BooleanUnary: {
                return BooleanUnaryCPInstruction.parseInstruction(str);
            }
            case BuiltinBinary: {
                return BuiltinBinaryCPInstruction.parseInstruction(str);
            }
            case BuiltinUnary: {
                return BuiltinUnaryCPInstruction.parseInstruction(str);
            }
            case BuiltinMultiple: {
                return BuiltinMultipleCPInstruction.parseInstruction(str);
            }
            case Reorg: {
                return ReorgCPInstruction.parseInstruction(str);
            }
            case Convolution: {
                return ConvolutionCPInstruction.parseInstruction(str);
            }
            case UaggOuterChain: {
                return UaggOuterChainCPInstruction.parseInstruction(str);
            }
            case MatrixReshape: {
                return MatrixReshapeCPInstruction.parseInstruction(str);
            }
            case Append: {
                return AppendCPInstruction.parseInstruction(str);
            }
            case RelationalBinary: {
                return RelationalBinaryCPInstruction.parseInstruction(str);
            }
            case File: {
                return FileCPInstruction.parseInstruction(str);
            }
            case Variable: {
                return VariableCPInstruction.parseInstruction(str);
            }
            case Rand: {
                return DataGenCPInstruction.parseInstruction(str);
            }
            case StringInit: {
                return StringInitCPInstruction.parseInstruction(str);
            }
            case External: {
                return FunctionCallCPInstruction.parseInstruction(str);
            }
            case ParameterizedBuiltin: {
                execType = LopProperties.ExecType.valueOf(str.split("\u00b0")[0]);
                if (execType == LopProperties.ExecType.CP) {
                    return ParameterizedBuiltinCPInstruction.parseInstruction(str);
                }
                return ParameterizedBuiltinCPFileInstruction.parseInstruction(str);
            }
            case MultiReturnParameterizedBuiltin: {
                return MultiReturnParameterizedBuiltinCPInstruction.parseInstruction(str);
            }
            case MultiReturnBuiltin: {
                return MultiReturnBuiltinCPInstruction.parseInstruction(str);
            }
            case QSort: {
                return QuantileSortCPInstruction.parseInstruction(str);
            }
            case QPick: {
                return QuantilePickCPInstruction.parseInstruction(str);
            }
            case MatrixIndexing: {
                execType = LopProperties.ExecType.valueOf(str.split("\u00b0")[0]);
                if (execType == LopProperties.ExecType.CP) {
                    return IndexingCPInstruction.parseInstruction(str);
                }
                return MatrixIndexingCPFileInstruction.parseInstruction(str);
            }
            case Builtin: {
                String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
                if (parts[0].equals("log") || parts[0].equals("log_nz")) {
                    if (parts.length == 3) {
                        return BuiltinUnaryCPInstruction.parseInstruction(str);
                    }
                    if (parts.length == 4) {
                        return BuiltinBinaryCPInstruction.parseInstruction(str);
                    }
                } else {
                    throw new DMLRuntimeException("Invalid Builtin Instruction: " + str);
                }
            }
            case MMTSJ: {
                return MMTSJCPInstruction.parseInstruction(str);
            }
            case PMMJ: {
                return PMMJCPInstruction.parseInstruction(str);
            }
            case MMChain: {
                return MMChainCPInstruction.parseInstruction(str);
            }
            case Partition: {
                return DataPartitionCPInstruction.parseInstruction(str);
            }
            case CentralMoment: {
                return CentralMomentCPInstruction.parseInstruction(str);
            }
            case Covariance: {
                return CovarianceCPInstruction.parseInstruction(str);
            }
            case Compression: {
                return (CPInstruction)CompressionCPInstruction.parseInstruction(str);
            }
            case SpoofFused: {
                return SpoofCPInstruction.parseInstruction(str);
            }
        }
        throw new DMLRuntimeException("Invalid CP Instruction Type: " + (Object)((Object)cptype));
    }

    static {
        String2CPInstructionType.put("ba+*", CPInstruction.CPINSTRUCTION_TYPE.AggregateBinary);
        String2CPInstructionType.put("tak+*", CPInstruction.CPINSTRUCTION_TYPE.AggregateTernary);
        String2CPInstructionType.put("tack+*", CPInstruction.CPINSTRUCTION_TYPE.AggregateTernary);
        String2CPInstructionType.put("uak+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uark+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uack+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uasqk+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uarsqk+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uacsqk+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uamean", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uarmean", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uacmean", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uavar", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uarvar", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uacvar", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uamax", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uarmax", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uarimax", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uacmax", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uamin", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uarmin", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uarimin", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uacmin", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("ua+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uar+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uac+", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("ua*", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uatrace", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uaktrace", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("nrow", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("ncol", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("length", CPInstruction.CPINSTRUCTION_TYPE.AggregateUnary);
        String2CPInstructionType.put("uaggouterchain", CPInstruction.CPINSTRUCTION_TYPE.UaggOuterChain);
        String2CPInstructionType.put("+", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("-", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("*", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("/", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("%%", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("%/%", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("^", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("1-*", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("^2", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("*2", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("-nz", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("+*", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("-*", CPInstruction.CPINSTRUCTION_TYPE.ArithmeticBinary);
        String2CPInstructionType.put("&&", CPInstruction.CPINSTRUCTION_TYPE.BooleanBinary);
        String2CPInstructionType.put("||", CPInstruction.CPINSTRUCTION_TYPE.BooleanBinary);
        String2CPInstructionType.put("!", CPInstruction.CPINSTRUCTION_TYPE.BooleanUnary);
        String2CPInstructionType.put("==", CPInstruction.CPINSTRUCTION_TYPE.RelationalBinary);
        String2CPInstructionType.put("!=", CPInstruction.CPINSTRUCTION_TYPE.RelationalBinary);
        String2CPInstructionType.put("<", CPInstruction.CPINSTRUCTION_TYPE.RelationalBinary);
        String2CPInstructionType.put(">", CPInstruction.CPINSTRUCTION_TYPE.RelationalBinary);
        String2CPInstructionType.put("<=", CPInstruction.CPINSTRUCTION_TYPE.RelationalBinary);
        String2CPInstructionType.put(">=", CPInstruction.CPINSTRUCTION_TYPE.RelationalBinary);
        String2CPInstructionType.put("rm", CPInstruction.CPINSTRUCTION_TYPE.File);
        String2CPInstructionType.put("mv", CPInstruction.CPINSTRUCTION_TYPE.File);
        String2CPInstructionType.put("log", CPInstruction.CPINSTRUCTION_TYPE.Builtin);
        String2CPInstructionType.put("log_nz", CPInstruction.CPINSTRUCTION_TYPE.Builtin);
        String2CPInstructionType.put("max", CPInstruction.CPINSTRUCTION_TYPE.BuiltinBinary);
        String2CPInstructionType.put("min", CPInstruction.CPINSTRUCTION_TYPE.BuiltinBinary);
        String2CPInstructionType.put("solve", CPInstruction.CPINSTRUCTION_TYPE.BuiltinBinary);
        String2CPInstructionType.put("exp", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("abs", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("sin", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("cos", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("tan", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("asin", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("acos", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("atan", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("sign", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("sqrt", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("plogp", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("print", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("round", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("ceil", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("floor", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("ucumk+", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("ucum*", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("ucummin", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("ucummax", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("stop", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("inverse", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("cholesky", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("sprop", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("sigmoid", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("sel+", CPInstruction.CPINSTRUCTION_TYPE.BuiltinUnary);
        String2CPInstructionType.put("printf", CPInstruction.CPINSTRUCTION_TYPE.BuiltinMultiple);
        String2CPInstructionType.put("cdf", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("invcdf", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("groupedagg", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("rmempty", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("replace", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("rexpand", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("transform", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("transformapply", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("transformdecode", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("transformencode", CPInstruction.CPINSTRUCTION_TYPE.MultiReturnParameterizedBuiltin);
        String2CPInstructionType.put("transformmeta", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("toString", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
        String2CPInstructionType.put("assignvar", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("cpvar", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("mvvar", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("rmvar", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("rmfilevar", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("castdts", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("castdtm", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("castdtf", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("castvtd", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("castvti", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("castvtb", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("attachfiletovar", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("read", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("write", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("createvar", CPInstruction.CPINSTRUCTION_TYPE.Variable);
        String2CPInstructionType.put("r'", CPInstruction.CPINSTRUCTION_TYPE.Reorg);
        String2CPInstructionType.put("rev", CPInstruction.CPINSTRUCTION_TYPE.Reorg);
        String2CPInstructionType.put("rdiag", CPInstruction.CPINSTRUCTION_TYPE.Reorg);
        String2CPInstructionType.put("rshape", CPInstruction.CPINSTRUCTION_TYPE.MatrixReshape);
        String2CPInstructionType.put("rsort", CPInstruction.CPINSTRUCTION_TYPE.Reorg);
        String2CPInstructionType.put("relu_backward", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("relu_maxpooling", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("maxpooling", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("maxpooling_backward", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("conv2d", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("conv2d_bias_add", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("conv2d_backward_filter", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("conv2d_backward_data", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("bias_add", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("bias_multiply", CPInstruction.CPINSTRUCTION_TYPE.Convolution);
        String2CPInstructionType.put("wsloss", CPInstruction.CPINSTRUCTION_TYPE.Quaternary);
        String2CPInstructionType.put("wsigmoid", CPInstruction.CPINSTRUCTION_TYPE.Quaternary);
        String2CPInstructionType.put("wdivmm", CPInstruction.CPINSTRUCTION_TYPE.Quaternary);
        String2CPInstructionType.put("wcemm", CPInstruction.CPINSTRUCTION_TYPE.Quaternary);
        String2CPInstructionType.put("wumm", CPInstruction.CPINSTRUCTION_TYPE.Quaternary);
        String2CPInstructionType.put("extfunct", CPInstruction.CPINSTRUCTION_TYPE.External);
        String2CPInstructionType.put("append", CPInstruction.CPINSTRUCTION_TYPE.Append);
        String2CPInstructionType.put("rand", CPInstruction.CPINSTRUCTION_TYPE.Rand);
        String2CPInstructionType.put("seq", CPInstruction.CPINSTRUCTION_TYPE.Rand);
        String2CPInstructionType.put("sinit", CPInstruction.CPINSTRUCTION_TYPE.StringInit);
        String2CPInstructionType.put("sample", CPInstruction.CPINSTRUCTION_TYPE.Rand);
        String2CPInstructionType.put("ctable", CPInstruction.CPINSTRUCTION_TYPE.Ternary);
        String2CPInstructionType.put("ctableexpand", CPInstruction.CPINSTRUCTION_TYPE.Ternary);
        String2CPInstructionType.put("cm", CPInstruction.CPINSTRUCTION_TYPE.CentralMoment);
        String2CPInstructionType.put("cov", CPInstruction.CPINSTRUCTION_TYPE.Covariance);
        String2CPInstructionType.put("qsort", CPInstruction.CPINSTRUCTION_TYPE.QSort);
        String2CPInstructionType.put("qpick", CPInstruction.CPINSTRUCTION_TYPE.QPick);
        String2CPInstructionType.put("rangeReIndex", CPInstruction.CPINSTRUCTION_TYPE.MatrixIndexing);
        String2CPInstructionType.put("leftIndex", CPInstruction.CPINSTRUCTION_TYPE.MatrixIndexing);
        String2CPInstructionType.put("tsmm", CPInstruction.CPINSTRUCTION_TYPE.MMTSJ);
        String2CPInstructionType.put("pmm", CPInstruction.CPINSTRUCTION_TYPE.PMMJ);
        String2CPInstructionType.put("mmchain", CPInstruction.CPINSTRUCTION_TYPE.MMChain);
        String2CPInstructionType.put("qr", CPInstruction.CPINSTRUCTION_TYPE.MultiReturnBuiltin);
        String2CPInstructionType.put("lu", CPInstruction.CPINSTRUCTION_TYPE.MultiReturnBuiltin);
        String2CPInstructionType.put("eigen", CPInstruction.CPINSTRUCTION_TYPE.MultiReturnBuiltin);
        String2CPInstructionType.put("partition", CPInstruction.CPINSTRUCTION_TYPE.Partition);
        String2CPInstructionType.put("compress", CPInstruction.CPINSTRUCTION_TYPE.Compression);
        String2CPInstructionType.put("spoof", CPInstruction.CPINSTRUCTION_TYPE.SpoofFused);
        String2CPFileInstructionType = new HashMap();
        String2CPFileInstructionType.put("rmempty", CPInstruction.CPINSTRUCTION_TYPE.ParameterizedBuiltin);
    }
}

