/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.context;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;

public class ExecutionContextFactory {
    public static ExecutionContext createContext() {
        return ExecutionContextFactory.createContext(null);
    }

    public static ExecutionContext createContext(Program prog) {
        return ExecutionContextFactory.createContext(true, prog);
    }

    public static ExecutionContext createContext(boolean allocateVars, Program prog) {
        ExecutionContext ec = null;
        switch (DMLScript.rtplatform) {
            case SINGLE_NODE: {
                if (OptimizerUtils.getDefaultExecutionMode() == DMLScript.RUNTIME_PLATFORM.HYBRID) {
                    ec = new ExecutionContext(allocateVars, prog);
                    break;
                }
                ec = new SparkExecutionContext(allocateVars, prog);
                break;
            }
            case HADOOP: 
            case HYBRID: {
                ec = new ExecutionContext(allocateVars, prog);
                break;
            }
            case SPARK: 
            case HYBRID_SPARK: {
                ec = new SparkExecutionContext(allocateVars, prog);
            }
        }
        return ec;
    }
}

