/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.context;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLFrame;
import org.apache.sysml.debug.DMLProgramCounter;
import org.apache.sysml.debug.DebugState;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixDimensionsMetaData;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.MetaData;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;

public class ExecutionContext {
    protected Program _prog = null;
    protected LocalVariableMap _variables;
    protected DebugState _dbState = null;

    protected ExecutionContext() {
        this(true, null);
    }

    protected ExecutionContext(boolean allocateVariableMap, Program prog) {
        this._variables = allocateVariableMap ? new LocalVariableMap() : null;
        this._prog = prog;
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState = DebugState.getInstance();
        }
    }

    public Program getProgram() {
        return this._prog;
    }

    public LocalVariableMap getVariables() {
        return this._variables;
    }

    public void setVariables(LocalVariableMap vars) {
        this._variables = vars;
    }

    public void destroyGPUContext() throws DMLRuntimeException {
        if (GPUContext.isGPUContextCreated.booleanValue()) {
            GPUContext.getGPUContext().destroy();
        }
    }

    public Data getVariable(String name) {
        return this._variables.get(name);
    }

    public void setVariable(String name, Data val) {
        this._variables.put(name, val);
    }

    public boolean containsVariable(String name) {
        return this._variables.keySet().contains(name);
    }

    public Data removeVariable(String name) {
        return this._variables.remove(name);
    }

    public void setMetaData(String fname, MetaData md) throws DMLRuntimeException {
        this._variables.get(fname).setMetaData(md);
    }

    public MetaData getMetaData(String varname) throws DMLRuntimeException {
        return this._variables.get(varname).getMetaData();
    }

    public MatrixObject getMatrixObject(String varname) throws DMLRuntimeException {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException("Variable '" + varname + "' does not exist in the symbol table.");
        }
        if (!(dat instanceof MatrixObject)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a matrix.");
        }
        return (MatrixObject)dat;
    }

    public FrameObject getFrameObject(String varname) throws DMLRuntimeException {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException("Variable '" + varname + "' does not exist in the symbol table.");
        }
        if (!(dat instanceof FrameObject)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a frame.");
        }
        return (FrameObject)dat;
    }

    public CacheableData<?> getCacheableData(String varname) throws DMLRuntimeException {
        Data dat = this.getVariable(varname);
        if (dat == null) {
            throw new DMLRuntimeException("Variable '" + varname + "' does not exist in the symbol table.");
        }
        if (!(dat instanceof CacheableData)) {
            throw new DMLRuntimeException("Variable '" + varname + "' is not a matrix or frame.");
        }
        return (CacheableData)dat;
    }

    public void releaseCacheableData(String varname) throws DMLRuntimeException {
        CacheableData<?> dat = this.getCacheableData(varname);
        dat.release();
    }

    public MatrixCharacteristics getMatrixCharacteristics(String varname) throws DMLRuntimeException {
        MatrixDimensionsMetaData dims = (MatrixDimensionsMetaData)this.getMetaData(varname);
        return dims.getMatrixCharacteristics();
    }

    public MatrixBlock getMatrixInput(String varName) throws DMLRuntimeException {
        MatrixObject mo = this.getMatrixObject(varName);
        return (MatrixBlock)mo.acquireRead();
    }

    public void setMetaData(String varName, long nrows, long ncols) throws DMLRuntimeException {
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo.getNumRows() == nrows && mo.getNumColumns() == ncols) {
            return;
        }
        MetaData oldMetaData = mo.getMetaData();
        if (oldMetaData == null || !(oldMetaData instanceof MatrixFormatMetaData)) {
            throw new DMLRuntimeException("Metadata not available");
        }
        MatrixCharacteristics mc = new MatrixCharacteristics(nrows, ncols, (int)mo.getNumRowsPerBlock(), (int)mo.getNumColumnsPerBlock());
        mo.setMetaData(new MatrixFormatMetaData(mc, ((MatrixFormatMetaData)oldMetaData).getOutputInfo(), ((MatrixFormatMetaData)oldMetaData).getInputInfo()));
    }

    public Pair<MatrixObject, Boolean> getDenseMatrixOutputForGPUInstruction(String varName) throws DMLRuntimeException {
        MatrixObject mo = this.allocateGPUMatrixObject(varName);
        boolean allocated = mo.getGPUObject().acquireDeviceModifyDense();
        mo.getMatrixCharacteristics().setNonZeros(-1L);
        return new Pair<MatrixObject, Boolean>(mo, allocated);
    }

    public Pair<MatrixObject, Boolean> getSparseMatrixOutputForGPUInstruction(String varName, long nnz) throws DMLRuntimeException {
        MatrixObject mo = this.allocateGPUMatrixObject(varName);
        mo.getMatrixCharacteristics().setNonZeros(nnz);
        boolean allocated = mo.getGPUObject().acquireDeviceModifySparse();
        return new Pair<MatrixObject, Boolean>(mo, allocated);
    }

    public MatrixObject allocateGPUMatrixObject(String varName) throws DMLRuntimeException {
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo.getGPUObject() == null) {
            mo.setGPUObject(GPUContext.createGPUObject(mo));
        }
        return mo;
    }

    public Pair<MatrixObject, Boolean> getMatrixInputForGPUInstruction(String varName) throws DMLRuntimeException {
        boolean copied = false;
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo == null) {
            throw new DMLRuntimeException("No matrix object available for variable:" + varName);
        }
        if (mo.getGPUObject() == null) {
            mo.setGPUObject(GPUContext.createGPUObject(mo));
        }
        boolean acquired = false;
        if (!mo.getGPUObject().isAllocated()) {
            mo.acquireRead();
            acquired = true;
        }
        copied = mo.getGPUObject().acquireDeviceRead();
        if (acquired) {
            mo.release();
        }
        return new Pair<MatrixObject, Boolean>(mo, copied);
    }

    public void releaseMatrixInput(String varName) throws DMLRuntimeException {
        MatrixObject mo = this.getMatrixObject(varName);
        mo.release();
    }

    public void releaseMatrixInputForGPUInstruction(String varName) throws DMLRuntimeException {
        MatrixObject mo = this.getMatrixObject(varName);
        mo.getGPUObject().releaseInput();
    }

    public FrameBlock getFrameInput(String varName) throws DMLRuntimeException {
        FrameObject fo = this.getFrameObject(varName);
        return (FrameBlock)fo.acquireRead();
    }

    public void releaseFrameInput(String varName) throws DMLRuntimeException {
        FrameObject fo = this.getFrameObject(varName);
        fo.release();
    }

    public ScalarObject getScalarInput(String name, Expression.ValueType vt, boolean isLiteral) throws DMLRuntimeException {
        if (isLiteral) {
            switch (vt) {
                case INT: {
                    long intVal = UtilFunctions.parseToLong(name);
                    IntObject intObj = new IntObject(intVal);
                    return intObj;
                }
                case DOUBLE: {
                    double doubleVal = Double.parseDouble(name);
                    DoubleObject doubleObj = new DoubleObject(doubleVal);
                    return doubleObj;
                }
                case BOOLEAN: {
                    Boolean boolVal = Boolean.parseBoolean(name);
                    BooleanObject boolObj = new BooleanObject(boolVal);
                    return boolObj;
                }
                case STRING: {
                    StringObject stringObj = new StringObject(name);
                    return stringObj;
                }
            }
            throw new DMLRuntimeException("Unknown value type: " + (Object)((Object)vt) + " for variable: " + name);
        }
        Data obj = this.getVariable(name);
        if (obj == null) {
            throw new DMLRuntimeException("Unknown variable: " + name);
        }
        return (ScalarObject)obj;
    }

    public void setScalarOutput(String varName, ScalarObject so) throws DMLRuntimeException {
        this.setVariable(varName, so);
    }

    public void releaseMatrixOutputForGPUInstruction(String varName) throws DMLRuntimeException {
        MatrixObject mo = this.getMatrixObject(varName);
        if (mo.getGPUObject() == null || !mo.getGPUObject().isAllocated()) {
            throw new DMLRuntimeException("No output is allocated on GPU");
        }
        mo.getGPUObject().releaseOutput();
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData) throws DMLRuntimeException {
        MatrixObject mo = this.getMatrixObject(varName);
        mo.acquireModify(outputData);
        mo.release();
        this.setVariable(varName, mo);
    }

    public void setMatrixOutput(String varName, MatrixBlock outputData, MatrixObject.UpdateType flag) throws DMLRuntimeException {
        if (flag.isInPlace()) {
            MatrixObject mo = this.getMatrixObject(varName);
            mo.setUpdateType(flag);
        }
        this.setMatrixOutput(varName, outputData);
    }

    public void setFrameOutput(String varName, FrameBlock outputData) throws DMLRuntimeException {
        FrameObject fo = this.getFrameObject(varName);
        if (outputData.getNumColumns() > 0 && outputData.getSchema() != null) {
            fo.setValueType(outputData.getSchema()[0]);
        }
        fo.acquireModify(outputData);
        fo.release();
        this.setVariable(varName, fo);
    }

    public HashMap<String, Boolean> pinVariables(ArrayList<String> varList) {
        MatrixObject mo;
        Data dat;
        HashMap<String, Boolean> varsState = new HashMap<String, Boolean>();
        for (String var : varList) {
            dat = this._variables.get(var);
            if (!(dat instanceof MatrixObject)) continue;
            mo = (MatrixObject)dat;
            varsState.put(var, mo.isCleanupEnabled());
        }
        for (String var : varList) {
            dat = this._variables.get(var);
            if (!(dat instanceof MatrixObject)) continue;
            mo = (MatrixObject)dat;
            mo.enableCleanup(false);
        }
        return varsState;
    }

    public void unpinVariables(ArrayList<String> varList, HashMap<String, Boolean> varsState) {
        for (String var : varList) {
            Data dat = this._variables.get(var);
            if (!(dat instanceof MatrixObject)) continue;
            ((MatrixObject)dat).enableCleanup(varsState.get(var));
        }
    }

    public ArrayList<String> getVarList() {
        ArrayList<String> varlist = new ArrayList<String>();
        varlist.addAll(this._variables.keySet());
        return varlist;
    }

    public void cleanupMatrixObject(MatrixObject mo) throws DMLRuntimeException {
        try {
            if (mo.isCleanupEnabled() && !this.getVariables().hasReferences(mo)) {
                String fpath;
                mo.clearData();
                if (mo.isHDFSFileExists() && (fpath = mo.getFileName()) != null) {
                    MapReduceTool.deleteFileIfExistOnHDFS(fpath);
                    MapReduceTool.deleteFileIfExistOnHDFS(fpath + ".mtd");
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    public void initDebugProgramCounters() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.pc = new DMLProgramCounter(DMLProgram.DEFAULT_NAMESPACE, "main", 0, 0);
            this._dbState.prevPC = new DMLProgramCounter(DMLProgram.DEFAULT_NAMESPACE, "main", 0, 0);
        }
    }

    public void updateDebugState(int index) throws DMLRuntimeException {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.getPC().setProgramBlockNumber(index);
        }
    }

    public void updateDebugState(Instruction currInst) throws DMLRuntimeException {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.nextCommand = false;
            this._dbState.getPC().setInstID(currInst.getInstID());
            this._dbState.getPC().setLineNumber(currInst.getLineNum());
            this.suspendIfAskedInDebugMode(currInst);
        }
    }

    public void clearDebugProgramCounters() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            this._dbState.pc = null;
        }
    }

    public void handleDebugException(Exception ex) {
        this._dbState.getDMLStackTrace(ex);
        this._dbState.suspend = true;
    }

    public void handleDebugFunctionEntry(FunctionCallCPInstruction funCallInst) throws DMLRuntimeException {
        this._dbState.pushFrame(this.getVariables(), this._dbState.getPC());
        this._dbState.pc = new DMLProgramCounter(funCallInst.getNamespace(), funCallInst.getFunctionName(), 0, 0);
    }

    public void handleDebugFunctionExit(FunctionCallCPInstruction funCallInst) {
        DMLFrame fr = this._dbState.popFrame();
        this._dbState.pc = fr.getPC();
    }

    public DebugState getDebugState() {
        return this._dbState;
    }

    private void suspendIfAskedInDebugMode(Instruction currInst) throws DMLRuntimeException {
        if (!DMLScript.ENABLE_DEBUG_MODE) {
            System.err.println("ERROR: The function suspendIfAskedInDebugMode should not be called in non-debug mode.");
        }
        if (!this._dbState.suspend && this._dbState.dbCommand != null) {
            if (this._dbState.dbCommand.equalsIgnoreCase("step_instruction")) {
                System.out.format("Step instruction reached at %s.\n", this._dbState.getPC().toString());
                this._dbState.suspend = true;
            } else if (this._dbState.dbCommand.equalsIgnoreCase("step_line") && this._dbState.prevPC.getLineNumber() != currInst.getLineNum() && this._dbState.prevPC.getLineNumber() != 0) {
                System.out.format("Step reached at %s.\n", this._dbState.getPC().toStringWithoutInstructionID());
                this._dbState.suspend = true;
            } else if (this._dbState.dbCommand.equalsIgnoreCase("step return") && currInst instanceof FunctionCallCPInstruction) {
                FunctionCallCPInstruction funCallInst = (FunctionCallCPInstruction)currInst;
                if (this._dbState.dbCommandArg == null || funCallInst.getFunctionName().equalsIgnoreCase(this._dbState.dbCommandArg)) {
                    System.out.format("Step return reached at %s.\n", this._dbState.getPC().toStringWithoutInstructionID());
                    this._dbState.suspend = true;
                }
            }
        }
        if (this._dbState.suspend) {
            this._dbState.dbCommand = null;
            this._dbState.dbCommandArg = null;
            if (currInst.getLineNum() != 0) {
                this._dbState.printDMLSourceLine(currInst.getLineNum());
            }
            this._dbState.setVariables(this.getVariables());
            this._dbState.nextCommand = true;
            Thread.currentThread().suspend();
            this._dbState.nextCommand = false;
        }
        this._dbState.suspend = false;
        this._dbState.prevPC.setFunctionName(this._dbState.getPC().getFunctionName());
        this._dbState.prevPC.setProgramBlockNumber(this._dbState.getPC().getProgramBlockNumber());
        this._dbState.prevPC.setLineNumber(currInst.getLineNum());
    }
}

