/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.caching;

import java.io.DataInput;
import java.io.IOException;
import org.apache.sysml.runtime.matrix.data.MatrixBlockDataInput;
import org.apache.sysml.runtime.matrix.data.SparseBlock;

public class CacheDataInput
implements DataInput,
MatrixBlockDataInput {
    protected byte[] _buff;
    protected int _bufflen;
    protected int _count;

    public CacheDataInput(byte[] mem) {
        this._buff = mem;
        this._bufflen = this._buff.length;
        this._count = 0;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public boolean readBoolean() throws IOException {
        return (this._buff[this._count++] & 0xFF) != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)(this._buff[this._count++] & 0xFF);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public short readShort() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public int readUnsignedShort() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public char readChar() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public int readInt() throws IOException {
        int ret = CacheDataInput.baToInt(this._buff, this._count);
        this._count += 4;
        return ret;
    }

    @Override
    public long readLong() throws IOException {
        long ret = CacheDataInput.baToLong(this._buff, this._count);
        this._count += 8;
        return ret;
    }

    @Override
    public float readFloat() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public double readDouble() throws IOException {
        long tmp = CacheDataInput.baToLong(this._buff, this._count);
        double tmp2 = Double.longBitsToDouble(tmp);
        this._count += 8;
        return tmp2;
    }

    @Override
    public String readLine() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public String readUTF() throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public long readDoubleArray(int len, double[] varr) throws IOException {
        long nnz = 0L;
        int off = this._count;
        for (int i = 0; i < len; ++i) {
            long tmp = CacheDataInput.baToLong(this._buff, off + i * 8);
            varr[i] = Double.longBitsToDouble(tmp);
            nnz += varr[i] != 0.0 ? 1L : 0L;
        }
        this._count = off + len * 8;
        return nnz;
    }

    @Override
    public long readSparseRows(int rlen, SparseBlock rows) throws IOException {
        long nnz = 0L;
        for (int i = 0; i < rlen; ++i) {
            int lnnz = this.readInt();
            if (lnnz <= 0) continue;
            rows.allocate(i, lnnz);
            for (int j = 0; j < lnnz; ++j) {
                int aix = CacheDataInput.baToInt(this._buff, this._count);
                long tmp = CacheDataInput.baToLong(this._buff, this._count + 4);
                double aval = Double.longBitsToDouble(tmp);
                rows.append(i, aix, aval);
                this._count += 12;
            }
            nnz += (long)lnnz;
        }
        return nnz;
    }

    private static int baToInt(byte[] ba, int off) {
        return ((ba[off + 0] & 0xFF) << 24) + ((ba[off + 1] & 0xFF) << 16) + ((ba[off + 2] & 0xFF) << 8) + ((ba[off + 3] & 0xFF) << 0);
    }

    private static long baToLong(byte[] ba, int off) {
        return ((long)(ba[off + 0] & 0xFF) << 56) + ((long)(ba[off + 1] & 0xFF) << 48) + ((long)(ba[off + 2] & 0xFF) << 40) + ((long)(ba[off + 3] & 0xFF) << 32) + ((long)(ba[off + 4] & 0xFF) << 24) + ((long)(ba[off + 5] & 0xFF) << 16) + ((long)(ba[off + 6] & 0xFF) << 8) + ((long)(ba[off + 7] & 0xFF) << 0);
    }
}

