/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.utils;

import org.apache.sysml.runtime.matrix.data.LibMatrixMult;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;

public class LinearAlgebraUtils {
    public static double dotProduct(double[] a, double[] b, int len) {
        return LibMatrixMult.dotProduct(a, b, 0, 0, len);
    }

    public static double dotProduct(double[] a, double[] b, int ai, int bi, int len) {
        return LibMatrixMult.dotProduct(a, b, ai, bi, len);
    }

    public static void vectMultiplyAdd(double aval, double[] b, double[] c, int bi, int ci, int len) {
        LibMatrixMult.vectMultiplyAdd(aval, b, c, bi, ci, len);
    }

    public static void vectMultiplyAdd(double aval, double[] b, double[] c, int[] bix, int bi, int ci, int len) {
        LibMatrixMult.vectMultiplyAdd(aval, b, c, bix, bi, ci, len);
    }

    public static void vectAdd(double[] a, double[] c, int ai, int ci, int len) {
        LibMatrixMult.vectAdd(a, c, ai, ci, len);
    }

    public static void vectAdd(double aval, double[] c, char[] bix, int bi, int ci, int len) {
        int j;
        int bn = len % 8;
        for (j = bi; j < bi + bn; ++j) {
            int n = ci + bix[j];
            c[n] = c[n] + aval;
        }
        for (j = bi + bn; j < bi + len; j += 8) {
            int n = ci + bix[j + 0];
            c[n] = c[n] + aval;
            int n2 = ci + bix[j + 1];
            c[n2] = c[n2] + aval;
            int n3 = ci + bix[j + 2];
            c[n3] = c[n3] + aval;
            int n4 = ci + bix[j + 3];
            c[n4] = c[n4] + aval;
            int n5 = ci + bix[j + 4];
            c[n5] = c[n5] + aval;
            int n6 = ci + bix[j + 5];
            c[n6] = c[n6] + aval;
            int n7 = ci + bix[j + 6];
            c[n7] = c[n7] + aval;
            int n8 = ci + bix[j + 7];
            c[n8] = c[n8] + aval;
        }
    }

    public static void vectAdd(double aval, double[] c, int ci, int len) {
        int j;
        int bn = len % 8;
        for (j = 0; j < bn; ++j) {
            int n = ci + j;
            c[n] = c[n] + aval;
        }
        for (j = bn; j < len; j += 8) {
            int n = ci + j + 0;
            c[n] = c[n] + aval;
            int n2 = ci + j + 1;
            c[n2] = c[n2] + aval;
            int n3 = ci + j + 2;
            c[n3] = c[n3] + aval;
            int n4 = ci + j + 3;
            c[n4] = c[n4] + aval;
            int n5 = ci + j + 4;
            c[n5] = c[n5] + aval;
            int n6 = ci + j + 5;
            c[n6] = c[n6] + aval;
            int n7 = ci + j + 6;
            c[n7] = c[n7] + aval;
            int n8 = ci + j + 7;
            c[n8] = c[n8] + aval;
        }
    }

    public static double vectSum(double[] a, char[] bix, int ai, int bi, int len) {
        int j;
        double val = 0.0;
        int bn = len % 8;
        for (j = bi; j < bi + bn; ++j) {
            val += a[ai + bix[j]];
        }
        for (j = bi + bn; j < bi + len; j += 8) {
            val += a[ai + bix[j + 0]] + a[ai + bix[j + 1]] + a[ai + bix[j + 2]] + a[ai + bix[j + 3]] + a[ai + bix[j + 4]] + a[ai + bix[j + 5]] + a[ai + bix[j + 6]] + a[ai + bix[j + 7]];
        }
        return val;
    }

    public static double vectSum(double[] a, int ai, int len) {
        double val = 0.0;
        int bn = len % 8;
        int j = 0;
        while (j < bn) {
            val += a[ai];
            ++j;
            ++ai;
        }
        j = bn;
        while (j < len) {
            val += a[ai + 0] + a[ai + 1] + a[ai + 2] + a[ai + 3] + a[ai + 4] + a[ai + 5] + a[ai + 6] + a[ai + 7];
            j += 8;
            ai += 8;
        }
        return val;
    }

    public static void copyUpperToLowerTriangle(MatrixBlock ret) {
        LibMatrixMult.copyUpperToLowerTriangle(ret);
    }

    public static void copyNonZerosToUpperTriangle(MatrixBlock ret, MatrixBlock tmp, int ix) {
        double[] a = tmp.getDenseBlock();
        for (int i = 0; i < tmp.getNumColumns(); ++i) {
            if (a[i] == 0.0) continue;
            ret.setValueDenseUnsafe(ix < i ? ix : i, ix < i ? i : ix, a[i]);
        }
    }

    public static int getClosestK(int[] a, int x) {
        int low = 0;
        int high = a.length - 1;
        while (low < high) {
            int mid = (low + high) / 2;
            int d1 = Math.abs(a[mid] - x);
            int d2 = Math.abs(a[mid + 1] - x);
            if (d2 <= d1) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return high;
    }
}

