/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.compress.ColGroupOLE;
import org.apache.sysml.runtime.compress.ColGroupRLE;
import org.apache.sysml.runtime.compress.ColGroupUncompressed;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.DataConverter;

public class ConverterUtils {
    public static ColGroup copyColGroup(ColGroup group) {
        ColGroup ret = null;
        int[] colIndices = Arrays.copyOf(group.getColIndices(), group.getNumCols());
        if (group instanceof ColGroupUncompressed) {
            ColGroupUncompressed in = (ColGroupUncompressed)group;
            ret = new ColGroupUncompressed(colIndices, in.getNumRows(), in.getData());
        } else if (group instanceof ColGroupRLE) {
            ColGroupRLE in = (ColGroupRLE)group;
            ret = new ColGroupRLE(colIndices, in.getNumRows(), in.hasZeros(), in.getValues(), in.getBitmaps(), in.getBitmapOffsets());
        } else if (group instanceof ColGroupOLE) {
            ColGroupOLE in = (ColGroupOLE)group;
            ret = new ColGroupOLE(colIndices, in.getNumRows(), in.hasZeros(), in.getValues(), in.getBitmaps(), in.getBitmapOffsets());
        }
        return ret;
    }

    public static double[] getDenseVector(MatrixBlock vector) {
        if (vector.isInSparseFormat()) {
            return DataConverter.convertToDoubleVector(vector);
        }
        return vector.getDenseBlock();
    }

    public static MatrixBlock getUncompressedColBlock(ColGroup group) {
        MatrixBlock ret = null;
        if (group instanceof ColGroupUncompressed) {
            ret = ((ColGroupUncompressed)group).getData();
        } else {
            ArrayList<ColGroup> tmpGroup = new ArrayList<ColGroup>(Arrays.asList(group));
            ColGroupUncompressed decompressedCols = new ColGroupUncompressed(tmpGroup);
            ret = decompressedCols.getData();
        }
        return ret;
    }
}

