/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.util.Arrays;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;

public abstract class ColGroupValue
extends ColGroup {
    private static final long serialVersionUID = 3786247536054353658L;
    public static boolean LOW_LEVEL_OPT = true;
    public static final boolean SORT_VALUES_BY_LENGTH = true;
    private static ThreadLocal<Pair<int[], double[]>> memPool = new ThreadLocal<Pair<int[], double[]>>(){

        @Override
        protected Pair<int[], double[]> initialValue() {
            return new Pair<int[], double[]>();
        }
    };
    protected double[] _values;

    public ColGroupValue() {
        super((int[])null, -1);
    }

    public ColGroupValue(int[] colIndices, int numRows, UncompressedBitmap ubm) {
        super(colIndices, numRows);
        if (LOW_LEVEL_OPT && numRows > 65536) {
            ubm.sortValuesByFrequency();
        }
        this._values = ubm.getValues();
    }

    protected ColGroupValue(int[] colIndices, int numRows, double[] values) {
        super(colIndices, numRows);
        this._values = values;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += 8L;
        if (this._values != null) {
            size += (long)(32 + this._values.length * 8);
        }
        return size;
    }

    public int getNumValues() {
        return this._values.length / this._colIndexes.length;
    }

    public double[] getValues() {
        return this._values;
    }

    protected int containsAllZeroValue() {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int i = 0;
        int off = 0;
        while (i < numVals) {
            boolean allZeros = true;
            for (int j = 0; j < numCols; ++j) {
                allZeros &= this._values[off + j] == 0.0;
            }
            if (allZeros) {
                return i;
            }
            ++i;
            off += numCols;
        }
        return -1;
    }

    protected final double sumValues(int valIx) {
        int numCols = this.getNumCols();
        int valOff = valIx * numCols;
        double val = 0.0;
        for (int i = 0; i < numCols; ++i) {
            val += this._values[valOff + i];
        }
        return val;
    }

    protected final double sumValues(int valIx, KahanFunction kplus, KahanObject kbuff) {
        int numCols = this.getNumCols();
        int valOff = valIx * numCols;
        kbuff.set(0.0, 0.0);
        for (int i = 0; i < numCols; ++i) {
            kplus.execute2(kbuff, this._values[valOff + i]);
        }
        return kbuff._sum;
    }

    protected final double[] sumAllValues(KahanFunction kplus, KahanObject kbuff) {
        return this.sumAllValues(kplus, kbuff, true);
    }

    protected final double[] sumAllValues(KahanFunction kplus, KahanObject kbuff, boolean allocNew) {
        if (this.getNumCols() == 1 && kplus instanceof KahanPlus) {
            return this._values;
        }
        int numVals = this.getNumValues();
        double[] ret = allocNew ? new double[numVals] : ColGroupValue.allocDVector(numVals, false);
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumValues(k, kplus, kbuff);
        }
        return ret;
    }

    protected final double sumValues(int valIx, double[] b) {
        int numCols = this.getNumCols();
        int valOff = valIx * numCols;
        double val = 0.0;
        for (int i = 0; i < numCols; ++i) {
            val += this._values[valOff + i] * b[i];
        }
        return val;
    }

    protected final double[] preaggValues(int numVals, double[] b) {
        return this.preaggValues(numVals, b, false);
    }

    protected final double[] preaggValues(int numVals, double[] b, boolean allocNew) {
        double[] ret = allocNew ? new double[numVals] : ColGroupValue.allocDVector(numVals, false);
        for (int k = 0; k < numVals; ++k) {
            ret[k] = this.sumValues(k, b);
        }
        return ret;
    }

    protected void computeMxx(MatrixBlock result, Builtin builtin, boolean zeros) {
        double val = Double.MAX_VALUE * (double)(builtin.getBuiltinCode() == Builtin.BuiltinCode.MAX ? -1 : 1);
        if (zeros) {
            val = builtin.execute2(val, 0.0);
        }
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        for (int k = 0; k < numVals; ++k) {
            int valOff = k * numCols;
            for (int j = 0; j < numCols; ++j) {
                val = builtin.execute2(val, this._values[valOff + j]);
            }
        }
        val = builtin.execute2(val, result.quickGetValue(0, 0));
        result.quickSetValue(0, 0, val);
    }

    protected void computeColMxx(MatrixBlock result, Builtin builtin, boolean zeros) {
        int j;
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        double[] vals = new double[numCols];
        Arrays.fill(vals, Double.MAX_VALUE * (double)(builtin.getBuiltinCode() == Builtin.BuiltinCode.MAX ? -1 : 1));
        if (zeros) {
            for (j = 0; j < numCols; ++j) {
                vals[j] = builtin.execute2(vals[j], 0.0);
            }
        }
        for (int k = 0; k < numVals; ++k) {
            int valOff = k * numCols;
            for (int j2 = 0; j2 < numCols; ++j2) {
                vals[j2] = builtin.execute2(vals[j2], this._values[valOff + j2]);
            }
        }
        for (j = 0; j < numCols; ++j) {
            result.quickSetValue(0, this._colIndexes[j], vals[j]);
        }
    }

    protected double[] applyScalarOp(ScalarOperator op) throws DMLRuntimeException {
        double[] ret = new double[this._values.length];
        for (int i = 0; i < this._values.length; ++i) {
            ret[i] = op.executeScalar(this._values[i]);
        }
        return ret;
    }

    protected double[] applyScalarOp(ScalarOperator op, double newVal, int numCols) throws DMLRuntimeException {
        double[] ret = new double[this._values.length + numCols];
        for (int i = 0; i < this._values.length; ++i) {
            ret[i] = op.executeScalar(this._values[i]);
        }
        Arrays.fill(ret, this._values.length, this._values.length + numCols, newVal);
        return ret;
    }

    @Override
    public void unaryAggregateOperations(AggregateUnaryOperator op, MatrixBlock result) throws DMLRuntimeException {
        this.unaryAggregateOperations(op, result, 0, this.getNumRows());
    }

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, MatrixBlock var2, int var3, int var4) throws DMLRuntimeException;

    public static void setupThreadLocalMemory(int len) {
        Pair<int[], double[]> p = new Pair<int[], double[]>();
        p.setKey(new int[len]);
        p.setValue(new double[len]);
        memPool.set(p);
    }

    public static void cleanupThreadLocalMemory() {
        memPool.remove();
    }

    protected static double[] allocDVector(int len, boolean reset) {
        Pair<int[], double[]> p = memPool.get();
        if (p.getValue() == null) {
            return new double[len];
        }
        double[] tmp = p.getValue();
        if (reset) {
            Arrays.fill(tmp, 0, len, 0.0);
        }
        return tmp;
    }

    protected static int[] allocIVector(int len, boolean reset) {
        Pair<int[], double[]> p = memPool.get();
        if (p.getKey() == null) {
            return new int[len];
        }
        int[] tmp = p.getKey();
        if (reset) {
            Arrays.fill(tmp, 0, len, 0);
        }
        return tmp;
    }
}

