/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.util.ArrayList;
import org.apache.sysml.runtime.compress.ReaderColumnSelection;
import org.apache.sysml.runtime.compress.ReaderColumnSelectionDense;
import org.apache.sysml.runtime.compress.ReaderColumnSelectionDenseSample;
import org.apache.sysml.runtime.compress.ReaderColumnSelectionSparse;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.compress.utils.DblArray;
import org.apache.sysml.runtime.compress.utils.DblArrayIntListHashMap;
import org.apache.sysml.runtime.compress.utils.DoubleIntListHashMap;
import org.apache.sysml.runtime.compress.utils.IntArrayList;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;

public class BitmapEncoder {
    public static final int BITMAP_BLOCK_SZ = 65536;

    public static UncompressedBitmap extractBitmap(int[] colIndices, MatrixBlock rawblock) {
        if (colIndices.length == 1) {
            return BitmapEncoder.extractBitmap(colIndices[0], rawblock, true);
        }
        ReaderColumnSelection reader = null;
        reader = rawblock.isInSparseFormat() ? new ReaderColumnSelectionSparse(rawblock, colIndices, true) : new ReaderColumnSelectionDense(rawblock, colIndices, true);
        return BitmapEncoder.extractBitmap(colIndices, rawblock, reader);
    }

    public static UncompressedBitmap extractBitmapFromSample(int[] colIndices, MatrixBlock rawblock, int[] sampleIndexes) {
        if (colIndices.length == 1) {
            return BitmapEncoder.extractBitmap(colIndices[0], rawblock, sampleIndexes, true);
        }
        return BitmapEncoder.extractBitmap(colIndices, rawblock, new ReaderColumnSelectionDenseSample(rawblock, colIndices, sampleIndexes, true));
    }

    public static char[] genRLEBitmap(int[] offsets, int len) {
        if (len == 0) {
            return new char[0];
        }
        ArrayList<Character> buf = new ArrayList<Character>();
        int lastRunEnd = 0;
        int curRunLen = 0;
        int firstOff = offsets[0];
        while (firstOff > 65535) {
            buf.add(Character.valueOf('\uffff'));
            buf.add(Character.valueOf('\u0000'));
            firstOff -= 65535;
            lastRunEnd += 65535;
        }
        int curRunOff = firstOff;
        curRunLen = 1;
        for (int i = 1; i < len; ++i) {
            int absOffset = offsets[i];
            int curRunEnd = lastRunEnd + curRunOff + curRunLen;
            if (absOffset > curRunEnd || curRunLen >= 65535) {
                buf.add(Character.valueOf((char)curRunOff));
                buf.add(Character.valueOf((char)curRunLen));
                lastRunEnd = curRunEnd;
                for (curRunOff = absOffset - lastRunEnd; curRunOff > 65535; curRunOff -= 65535) {
                    buf.add(Character.valueOf('\uffff'));
                    buf.add(Character.valueOf('\u0000'));
                    lastRunEnd += 65535;
                }
                curRunLen = 1;
                continue;
            }
            ++curRunLen;
        }
        if (curRunLen >= 1) {
            buf.add(Character.valueOf((char)curRunOff));
            buf.add(Character.valueOf((char)curRunLen));
        }
        char[] ret = new char[buf.size()];
        for (int i = 0; i < buf.size(); ++i) {
            ret[i] = ((Character)buf.get(i)).charValue();
        }
        return ret;
    }

    public static char[] genOffsetBitmap(int[] offsets, int len) {
        int lastOffset = offsets[len - 1];
        int numBlocks = lastOffset / 65536 + 1;
        int[] blockLengths = new int[numBlocks];
        for (int ix = 0; ix < len; ++ix) {
            int blockForVal;
            int val = offsets[ix];
            int n = blockForVal = val / 65536;
            blockLengths[n] = blockLengths[n] + 1;
        }
        int totalSize = numBlocks;
        for (int block = 0; block < numBlocks; ++block) {
            totalSize += blockLengths[block];
        }
        char[] encodedBlocks = new char[totalSize];
        int inputIx = 0;
        int blockStartIx = 0;
        for (int block = 0; block < numBlocks; ++block) {
            int blockSz = blockLengths[block];
            encodedBlocks[blockStartIx] = (char)blockSz;
            for (int i = 0; i < blockSz; ++i) {
                encodedBlocks[blockStartIx + i + 1] = (char)(offsets[inputIx + i] % 65536);
            }
            inputIx += blockSz;
            blockStartIx += blockSz + 1;
        }
        return encodedBlocks;
    }

    private static UncompressedBitmap extractBitmap(int colIndex, MatrixBlock rawblock, boolean skipZeros) {
        DoubleIntListHashMap distinctVals;
        block10: {
            int m;
            block8: {
                block9: {
                    distinctVals = new DoubleIntListHashMap();
                    m = rawblock.getNumColumns();
                    if (!rawblock.isInSparseFormat()) break block8;
                    SparseBlock a = rawblock.getSparseBlock();
                    if (a == null || a.isEmpty(colIndex)) break block9;
                    int apos = a.pos(colIndex);
                    int alen = a.size(colIndex);
                    int[] aix = a.indexes(colIndex);
                    double[] avals = a.values(colIndex);
                    IntArrayList lstPtr0 = new IntArrayList();
                    int last = -1;
                    for (int j = apos; j < apos + alen; ++j) {
                        IntArrayList lstPtr;
                        if (!skipZeros) {
                            for (int k = last + 1; k < aix[j]; ++k) {
                                lstPtr0.appendValue(k);
                            }
                        }
                        if ((lstPtr = distinctVals.get(avals[j])) == null) {
                            lstPtr = new IntArrayList();
                            distinctVals.appendValue(avals[j], lstPtr);
                        }
                        lstPtr.appendValue(aix[j]);
                        last = aix[j];
                    }
                    if (skipZeros) break block10;
                    for (int k = last + 1; k < m; ++k) {
                        lstPtr0.appendValue(k);
                    }
                    if (lstPtr0.size() <= 0) break block10;
                    distinctVals.appendValue(0.0, lstPtr0);
                    break block10;
                }
                if (skipZeros) break block10;
                IntArrayList lstPtr = new IntArrayList();
                for (int i = 0; i < m; ++i) {
                    lstPtr.appendValue(i);
                }
                distinctVals.appendValue(0.0, lstPtr);
                break block10;
            }
            for (int i = 0; i < m; ++i) {
                double val = rawblock.quickGetValue(colIndex, i);
                if (val == 0.0 && skipZeros) continue;
                IntArrayList lstPtr = distinctVals.get(val);
                if (lstPtr == null) {
                    lstPtr = new IntArrayList();
                    distinctVals.appendValue(val, lstPtr);
                }
                lstPtr.appendValue(i);
            }
        }
        return new UncompressedBitmap(distinctVals);
    }

    private static UncompressedBitmap extractBitmap(int colIndex, MatrixBlock rawblock, int[] sampleIndexes, boolean skipZeros) {
        DoubleIntListHashMap distinctVals = new DoubleIntListHashMap();
        int m = sampleIndexes.length;
        for (int i = 0; i < m; ++i) {
            int rowIndex = sampleIndexes[i];
            double val = rawblock.quickGetValue(colIndex, rowIndex);
            if (val == 0.0 && skipZeros) continue;
            IntArrayList lstPtr = distinctVals.get(val);
            if (lstPtr == null) {
                lstPtr = new IntArrayList();
                distinctVals.appendValue(val, lstPtr);
            }
            lstPtr.appendValue(i);
        }
        return new UncompressedBitmap(distinctVals);
    }

    private static UncompressedBitmap extractBitmap(int[] colIndices, MatrixBlock rawblock, ReaderColumnSelection rowReader) {
        DblArrayIntListHashMap distinctVals = new DblArrayIntListHashMap();
        DblArray cellVals = null;
        while ((cellVals = rowReader.nextRow()) != null) {
            IntArrayList lstPtr = distinctVals.get(cellVals);
            if (lstPtr == null) {
                lstPtr = new IntArrayList();
                distinctVals.appendValue(new DblArray(cellVals), lstPtr);
            }
            lstPtr.appendValue(rowReader.getCurrentRowIndex());
        }
        return new UncompressedBitmap(distinctVals, colIndices.length);
    }
}

