/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.DataConverter;

public abstract class SpoofOperator
implements Serializable {
    private static final long serialVersionUID = 3834006998853573319L;
    private static final Log LOG = LogFactory.getLog((String)SpoofOperator.class.getName());

    public abstract void execute(ArrayList<MatrixBlock> var1, ArrayList<ScalarObject> var2, MatrixBlock var3) throws DMLRuntimeException;

    public void execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalars, MatrixBlock out, int k) throws DMLRuntimeException {
        this.execute(inputs, scalars, out);
    }

    public abstract String getSpoofType();

    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalars) throws DMLRuntimeException {
        throw new RuntimeException("Invalid invocation in base class.");
    }

    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalars, int k) throws DMLRuntimeException {
        return this.execute(inputs, scalars);
    }

    protected double[][] prepInputMatrices(ArrayList<MatrixBlock> inputs) {
        return this.prepInputMatrices(inputs, 1, inputs.size() - 1);
    }

    protected double[][] prepInputMatrices(ArrayList<MatrixBlock> inputs, int offset) {
        return this.prepInputMatrices(inputs, offset, inputs.size() - offset);
    }

    protected double[][] prepInputMatrices(ArrayList<MatrixBlock> inputs, int offset, int len) {
        double[][] b = new double[len][];
        for (int i = offset; i < offset + len; ++i) {
            if (inputs.get(i).isInSparseFormat() && inputs.get(i).isAllocated()) {
                MatrixBlock tmp = inputs.get(i);
                b[i - offset] = DataConverter.convertToDoubleVector(tmp);
                LOG.warn((Object)(this.getClass().getName() + ": Converted " + tmp.getNumRows() + "x" + tmp.getNumColumns() + ", nnz=" + tmp.getNonZeros() + " sideways input matrix from sparse to dense."));
                continue;
            }
            b[i - offset] = inputs.get(i).getDenseBlock();
        }
        return b;
    }

    protected double[] prepInputScalars(ArrayList<ScalarObject> scalarObjects) {
        double[] scalars = new double[scalarObjects.size()];
        for (int i = 0; i < scalarObjects.size(); ++i) {
            scalars[i] = scalarObjects.get(i).getDoubleValue();
        }
        return scalars;
    }

    protected static double getValue(double[] data, int index) {
        return data != null ? data[index] : 0.0;
    }
}

