/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.codegen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.SpoofOperator;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.KahanPlusSq;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class SpoofCellwise
extends SpoofOperator
implements Serializable {
    private static final long serialVersionUID = 3442528770573293590L;
    private static final long PAR_NUMCELL_THRESHOLD = 0x100000L;
    private final CellType _type;
    private final AggOp _aggOp;
    private final boolean _sparseSafe;

    public SpoofCellwise(CellType type, AggOp aggOp, boolean sparseSafe) {
        this._type = type;
        this._aggOp = aggOp;
        this._sparseSafe = sparseSafe;
    }

    public CellType getCellType() {
        return this._type;
    }

    public AggOp getAggOp() {
        return this._aggOp;
    }

    public boolean isSparseSafe() {
        return this._sparseSafe;
    }

    @Override
    public String getSpoofType() {
        return "Cell" + this.getClass().getName().split("\\.")[1];
    }

    private ValueFunction getAggFunction() {
        switch (this._aggOp) {
            case SUM: {
                return KahanPlus.getKahanPlusFnObject();
            }
            case SUM_SQ: {
                return KahanPlusSq.getKahanPlusSqFnObject();
            }
            case MIN: {
                return Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MIN);
            }
            case MAX: {
                return Builtin.getBuiltinFnObject(Builtin.BuiltinCode.MAX);
            }
        }
        throw new RuntimeException("Unsupported aggregation type: " + this._aggOp.name());
    }

    @Override
    public ScalarObject execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, int k) throws DMLRuntimeException {
        if (inputs == null || inputs.size() < 1) {
            throw new RuntimeException("Invalid input arguments.");
        }
        if ((long)(inputs.get(0).getNumRows() * inputs.get(0).getNumColumns()) < 0x100000L) {
            k = 1;
        }
        double[][] b = this.prepInputMatrices(inputs);
        double[] scalars = this.prepInputScalars(scalarObjects);
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        boolean sparseSafe = this.isSparseSafe() || b.length == 0 && this.genexec(0.0, b, scalars, m, n, 0, 0) == 0.0;
        double ret = 0.0;
        if (k <= 1) {
            ret = !inputs.get(0).isInSparseFormat() ? this.executeDenseAndAgg(inputs.get(0).getDenseBlock(), b, scalars, m, n, sparseSafe, 0, m) : this.executeSparseAndAgg(inputs.get(0).getSparseBlock(), b, scalars, m, n, sparseSafe, 0, m);
        } else {
            try {
                ExecutorService pool = Executors.newFixedThreadPool(k);
                ArrayList<ParAggTask> tasks = new ArrayList<ParAggTask>();
                int nk = UtilFunctions.roundToNext(Math.min(8 * k, m / 32), k);
                int blklen = (int)Math.ceil((double)m / (double)nk);
                int i = 0;
                while (i < nk & i * blklen < m) {
                    tasks.add(new ParAggTask(inputs.get(0), b, scalars, m, n, sparseSafe, i * blklen, Math.min((i + 1) * blklen, m)));
                    ++i;
                }
                List taskret = pool.invokeAll(tasks);
                pool.shutdown();
                ValueFunction vfun = this.getAggFunction();
                if (vfun instanceof KahanFunction) {
                    KahanObject kbuff = new KahanObject(0.0, 0.0);
                    KahanPlus kplus = KahanPlus.getKahanPlusFnObject();
                    for (Future task : taskret) {
                        kplus.execute2(kbuff, (Double)task.get());
                    }
                    ret = kbuff._sum;
                } else {
                    for (Future task : taskret) {
                        ret = vfun.execute(ret, (double)((Double)task.get()));
                    }
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        }
        if ((this._aggOp == AggOp.MIN || this._aggOp == AggOp.MAX) && sparseSafe && inputs.get(0).getNonZeros() < (long)(inputs.get(0).getNumRows() * inputs.get(0).getNumColumns())) {
            ret = this.getAggFunction().execute(ret, 0.0);
        }
        return new DoubleObject(ret);
    }

    @Override
    public void execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out) throws DMLRuntimeException {
        this.execute(inputs, scalarObjects, out, 1);
    }

    @Override
    public void execute(ArrayList<MatrixBlock> inputs, ArrayList<ScalarObject> scalarObjects, MatrixBlock out, int k) throws DMLRuntimeException {
        if (inputs == null || inputs.size() < 1 || out == null) {
            throw new RuntimeException("Invalid input arguments.");
        }
        if ((long)(inputs.get(0).getNumRows() * inputs.get(0).getNumColumns()) < 0x100000L) {
            k = 1;
        }
        out.reset(inputs.get(0).getNumRows(), this._type == CellType.NO_AGG ? inputs.get(0).getNumColumns() : 1, false);
        out.allocateDenseBlock();
        double[] c = out.getDenseBlock();
        double[][] b = this.prepInputMatrices(inputs);
        double[] scalars = this.prepInputScalars(scalarObjects);
        int m = inputs.get(0).getNumRows();
        int n = inputs.get(0).getNumColumns();
        boolean sparseSafe = this.isSparseSafe() || b.length == 0 && this.genexec(0.0, b, scalars, m, n, 0, 0) == 0.0;
        long lnnz = 0L;
        if (k <= 1) {
            lnnz = !inputs.get(0).isInSparseFormat() ? this.executeDense(inputs.get(0).getDenseBlock(), b, scalars, c, m, n, sparseSafe, 0, m) : this.executeSparse(inputs.get(0).getSparseBlock(), b, scalars, c, m, n, sparseSafe, 0, m);
        } else {
            try {
                ExecutorService pool = Executors.newFixedThreadPool(k);
                ArrayList<ParExecTask> tasks = new ArrayList<ParExecTask>();
                int nk = UtilFunctions.roundToNext(Math.min(8 * k, m / 32), k);
                int blklen = (int)Math.ceil((double)m / (double)nk);
                int i = 0;
                while (i < nk & i * blklen < m) {
                    tasks.add(new ParExecTask(inputs.get(0), b, scalars, c, m, n, sparseSafe, i * blklen, Math.min((i + 1) * blklen, m)));
                    ++i;
                }
                List taskret = pool.invokeAll(tasks);
                pool.shutdown();
                for (Future task : taskret) {
                    lnnz += ((Long)task.get()).longValue();
                }
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        }
        out.setNonZeros(lnnz);
        out.examSparsity();
    }

    private double executeDenseAndAgg(double[] a, double[][] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double ret;
        block14: {
            ValueFunction vfun;
            block15: {
                block13: {
                    vfun = this.getAggFunction();
                    ret = 0.0;
                    if (!(vfun instanceof KahanFunction)) break block13;
                    KahanObject kbuff = new KahanObject(0.0, 0.0);
                    KahanFunction kplus = (KahanFunction)vfun;
                    if (a == null && !sparseSafe) {
                        for (int i = rl; i < ru; ++i) {
                            for (int j = 0; j < n; ++j) {
                                kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
                            }
                        }
                    } else if (a != null) {
                        int ix = rl * n;
                        for (int i = rl; i < ru; ++i) {
                            int j = 0;
                            while (j < n) {
                                if (a[ix] != 0.0 || !sparseSafe) {
                                    kplus.execute2(kbuff, this.genexec(a[ix], b, scalars, m, n, i, j));
                                }
                                ++j;
                                ++ix;
                            }
                        }
                    }
                    ret = kbuff._sum;
                    break block14;
                }
                double d = ret = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
                if (a != null || sparseSafe) break block15;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        ret = vfun.execute(ret, this.genexec(0.0, b, scalars, m, n, i, j));
                    }
                }
                break block14;
            }
            if (a == null) break block14;
            int ix = rl * n;
            for (int i = rl; i < ru; ++i) {
                int j = 0;
                while (j < n) {
                    if (a[ix] != 0.0 || !sparseSafe) {
                        ret = vfun.execute(ret, this.genexec(a[ix], b, scalars, m, n, i, j));
                    }
                    ++j;
                    ++ix;
                }
            }
        }
        return ret;
    }

    private long executeDense(double[] a, double[][] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        long lnnz;
        block21: {
            double initialVal;
            ValueFunction vfun;
            block22: {
                KahanFunction kplus;
                KahanObject kbuff;
                block23: {
                    block19: {
                        block20: {
                            lnnz = 0L;
                            if (this._type != CellType.NO_AGG) break block19;
                            if (a != null || sparseSafe) break block20;
                            int ix = rl * n;
                            for (int i = rl; i < ru; ++i) {
                                int j = 0;
                                while (j < n) {
                                    c[ix] = this.genexec(0.0, b, scalars, m, n, i, j);
                                    lnnz += c[ix] != 0.0 ? 1L : 0L;
                                    ++j;
                                    ++ix;
                                }
                            }
                            break block21;
                        }
                        if (a == null) break block21;
                        int ix = rl * n;
                        for (int i = rl; i < ru; ++i) {
                            int j = 0;
                            while (j < n) {
                                if (a[ix] != 0.0 || !sparseSafe) {
                                    c[ix] = this.genexec(a[ix], b, scalars, m, n, i, j);
                                    lnnz += c[ix] != 0.0 ? 1L : 0L;
                                }
                                ++j;
                                ++ix;
                            }
                        }
                        break block21;
                    }
                    if (this._type != CellType.ROW_AGG) break block21;
                    vfun = this.getAggFunction();
                    if (!(vfun instanceof KahanFunction)) break block22;
                    kbuff = new KahanObject(0.0, 0.0);
                    kplus = (KahanFunction)vfun;
                    if (a != null || sparseSafe) break block23;
                    for (int i = rl; i < ru; ++i) {
                        kbuff.set(0.0, 0.0);
                        for (int j = 0; j < n; ++j) {
                            kplus.execute2(kbuff, this.genexec(0.0, b, scalars, m, n, i, j));
                        }
                        c[i] = kbuff._sum;
                        lnnz += c[i] != 0.0 ? 1L : 0L;
                    }
                    break block21;
                }
                if (a == null) break block21;
                int ix = rl * n;
                for (int i = rl; i < ru; ++i) {
                    kbuff.set(0.0, 0.0);
                    int j = 0;
                    while (j < n) {
                        if (a[ix] != 0.0 || !sparseSafe) {
                            kplus.execute2(kbuff, this.genexec(a[ix], b, scalars, m, n, i, j));
                        }
                        ++j;
                        ++ix;
                    }
                    c[i] = kbuff._sum;
                    lnnz += c[i] != 0.0 ? 1L : 0L;
                }
                break block21;
            }
            double d = initialVal = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
            if (a == null && !sparseSafe) {
                for (int i = rl; i < ru; ++i) {
                    double tmp = initialVal;
                    for (int j = 0; j < n; ++j) {
                        tmp = vfun.execute(tmp, this.genexec(0.0, b, scalars, m, n, i, j));
                    }
                    c[i] = tmp;
                    lnnz += c[i] != 0.0 ? 1L : 0L;
                }
            } else if (a != null) {
                int ix = rl * n;
                for (int i = rl; i < ru; ++i) {
                    double tmp = initialVal;
                    int j = 0;
                    while (j < n) {
                        if (a[ix] != 0.0 || !sparseSafe) {
                            tmp = vfun.execute(tmp, this.genexec(a[ix], b, scalars, m, n, i, j));
                        }
                        ++j;
                        ++ix;
                    }
                    if (sparseSafe && UtilFunctions.containsZero(a, ix - n, n)) {
                        tmp = vfun.execute(tmp, 0.0);
                    }
                    lnnz += (c[i] = tmp) != 0.0 ? 1L : 0L;
                }
            }
        }
        return lnnz;
    }

    private double executeSparseAndAgg(SparseBlock sblock, double[][] b, double[] scalars, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        double ret;
        block12: {
            ValueFunction vfun;
            block13: {
                block11: {
                    vfun = this.getAggFunction();
                    ret = 0.0;
                    if (!(vfun instanceof KahanFunction)) break block11;
                    KahanObject kbuff = new KahanObject(0.0, 0.0);
                    KahanFunction kplus = (KahanFunction)vfun;
                    if (!sparseSafe) {
                        for (int i = rl; i < ru; ++i) {
                            for (int j = 0; j < n; ++j) {
                                double valij = sblock != null ? sblock.get(i, j) : 0.0;
                                kplus.execute2(kbuff, this.genexec(valij, b, scalars, m, n, i, j));
                            }
                        }
                    } else if (sblock != null) {
                        for (int i = rl; i < ru; ++i) {
                            if (sblock.isEmpty(i)) continue;
                            int apos = sblock.pos(i);
                            int alen = sblock.size(i);
                            double[] avals = sblock.values(i);
                            for (int j = apos; j < apos + alen; ++j) {
                                kplus.execute2(kbuff, this.genexec(avals[j], b, scalars, m, n, i, j));
                            }
                        }
                    }
                    ret = kbuff._sum;
                    break block12;
                }
                double d = ret = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
                if (sparseSafe) break block13;
                for (int i = rl; i < ru; ++i) {
                    for (int j = 0; j < n; ++j) {
                        double valij = sblock != null ? sblock.get(i, j) : 0.0;
                        ret = vfun.execute(ret, this.genexec(valij, b, scalars, m, n, i, j));
                    }
                }
                break block12;
            }
            if (sblock == null) break block12;
            for (int i = rl; i < ru; ++i) {
                if (sblock.isEmpty(i)) continue;
                int apos = sblock.pos(i);
                int alen = sblock.size(i);
                double[] avals = sblock.values(i);
                for (int j = apos; j < apos + alen; ++j) {
                    ret = vfun.execute(ret, this.genexec(avals[j], b, scalars, m, n, i, j));
                }
            }
        }
        return ret;
    }

    private long executeSparse(SparseBlock sblock, double[][] b, double[] scalars, double[] c, int m, int n, boolean sparseSafe, int rl, int ru) throws DMLRuntimeException {
        long lnnz;
        block17: {
            double initialVal;
            ValueFunction vfun;
            block18: {
                KahanFunction kplus;
                KahanObject kbuff;
                block19: {
                    block15: {
                        block16: {
                            lnnz = 0L;
                            if (this._type != CellType.NO_AGG) break block15;
                            if (!sparseSafe) break block16;
                            if (sblock == null) break block17;
                            for (int i = rl; i < ru; ++i) {
                                if (sblock.isEmpty(i)) continue;
                                int apos = sblock.pos(i);
                                int alen = sblock.size(i);
                                double[] avals = sblock.values(i);
                                for (int j = apos; j < apos + alen; ++j) {
                                    double val;
                                    c[i * n + sblock.indexes((int)i)[j]] = val = this.genexec(avals[j], b, scalars, m, n, i, j);
                                    lnnz += val != 0.0 ? 1L : 0L;
                                }
                            }
                            break block17;
                        }
                        int i = rl;
                        int cix = rl * n;
                        while (i < ru) {
                            for (int j = 0; j < n; ++j) {
                                double valij = sblock != null ? sblock.get(i, j) : 0.0;
                                c[cix + j] = this.genexec(valij, b, scalars, m, n, i, j);
                                lnnz += c[cix + j] != 0.0 ? 1L : 0L;
                            }
                            ++i;
                            cix += n;
                        }
                        break block17;
                    }
                    if (this._type != CellType.ROW_AGG) break block17;
                    vfun = this.getAggFunction();
                    if (!(vfun instanceof KahanFunction)) break block18;
                    kbuff = new KahanObject(0.0, 0.0);
                    kplus = (KahanFunction)vfun;
                    if (sparseSafe) break block19;
                    for (int i = rl; i < ru; ++i) {
                        kbuff.set(0.0, 0.0);
                        for (int j = 0; j < n; ++j) {
                            kplus.execute2(kbuff, this.genexec(sblock != null ? sblock.get(i, j) : 0.0, b, scalars, m, n, i, j));
                        }
                        c[i] = kbuff._sum;
                        lnnz += c[i] != 0.0 ? 1L : 0L;
                    }
                    break block17;
                }
                if (sblock == null) break block17;
                for (int i = rl; i < ru; ++i) {
                    if (sblock.isEmpty(i)) continue;
                    kbuff.set(0.0, 0.0);
                    int apos = sblock.pos(i);
                    int alen = sblock.size(i);
                    double[] avals = sblock.values(i);
                    for (int j = apos; j < apos + alen; ++j) {
                        kplus.execute2(kbuff, this.genexec(avals[j], b, scalars, m, n, i, j));
                    }
                    c[i] = kbuff._sum;
                    lnnz += c[i] != 0.0 ? 1L : 0L;
                }
                break block17;
            }
            double d = initialVal = this._aggOp == AggOp.MIN ? Double.MAX_VALUE : -1.7976931348623157E308;
            if (!sparseSafe) {
                for (int i = rl; i < ru; ++i) {
                    double tmp = initialVal;
                    for (int j = 0; j < n; ++j) {
                        tmp = vfun.execute(tmp, this.genexec(sblock != null ? sblock.get(i, j) : 0.0, b, scalars, m, n, i, j));
                    }
                    c[i] = tmp;
                    lnnz += c[i] != 0.0 ? 1L : 0L;
                }
            } else if (sblock != null) {
                for (int i = rl; i < ru; ++i) {
                    if (sblock.isEmpty(i)) continue;
                    int apos = sblock.pos(i);
                    int alen = sblock.size(i);
                    double[] avals = sblock.values(i);
                    double tmp = alen < n ? 0.0 : initialVal;
                    for (int j = apos; j < apos + alen; ++j) {
                        tmp = vfun.execute(tmp, this.genexec(avals[j], b, scalars, m, n, i, j));
                    }
                    c[i] = tmp;
                    lnnz += c[i] != 0.0 ? 1L : 0L;
                }
            }
        }
        return lnnz;
    }

    protected abstract double genexec(double var1, double[][] var3, double[] var4, int var5, int var6, int var7, int var8);

    private class ParExecTask
    implements Callable<Long> {
        private final MatrixBlock _a;
        private final double[][] _b;
        private final double[] _scalars;
        private final double[] _c;
        private final int _rlen;
        private final int _clen;
        private final boolean _safe;
        private final int _rl;
        private final int _ru;

        protected ParExecTask(MatrixBlock a, double[][] b, double[] scalars, double[] c, int rlen, int clen, boolean sparseSafe, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._scalars = scalars;
            this._c = c;
            this._rlen = rlen;
            this._clen = clen;
            this._safe = sparseSafe;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Long call() throws DMLRuntimeException {
            return !this._a.isInSparseFormat() ? SpoofCellwise.this.executeDense(this._a.getDenseBlock(), this._b, this._scalars, this._c, this._rlen, this._clen, this._safe, this._rl, this._ru) : SpoofCellwise.this.executeSparse(this._a.getSparseBlock(), this._b, this._scalars, this._c, this._rlen, this._clen, this._safe, this._rl, this._ru);
        }
    }

    private class ParAggTask
    implements Callable<Double> {
        private final MatrixBlock _a;
        private final double[][] _b;
        private final double[] _scalars;
        private final int _rlen;
        private final int _clen;
        private final boolean _safe;
        private final int _rl;
        private final int _ru;

        protected ParAggTask(MatrixBlock a, double[][] b, double[] scalars, int rlen, int clen, boolean sparseSafe, int rl, int ru) {
            this._a = a;
            this._b = b;
            this._scalars = scalars;
            this._rlen = rlen;
            this._clen = clen;
            this._safe = sparseSafe;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Double call() throws DMLRuntimeException {
            return !this._a.isInSparseFormat() ? SpoofCellwise.this.executeDenseAndAgg(this._a.getDenseBlock(), this._b, this._scalars, this._rlen, this._clen, this._safe, this._rl, this._ru) : SpoofCellwise.this.executeSparseAndAgg(this._a.getSparseBlock(), this._b, this._scalars, this._rlen, this._clen, this._safe, this._rl, this._ru);
        }
    }

    public static enum AggOp {
        SUM,
        SUM_SQ,
        MIN,
        MAX;

    }

    public static enum CellType {
        NO_AGG,
        FULL_AGG,
        ROW_AGG;

    }
}

