/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;

public class CustomErrorListener
extends BaseErrorListener {
    private static final Log log = LogFactory.getLog((String)DMLScript.class.getName());
    private boolean atLeastOneError = false;
    private boolean atLeastOneWarning = false;
    private String currentFileName = null;
    private List<ParseIssue> parseIssues = new ArrayList<ParseIssue>();

    public void setCurrentFileName(String currentFilePath) {
        this.currentFileName = currentFilePath;
    }

    public String getCurrentFileName() {
        return this.currentFileName;
    }

    public void unsetCurrentFileName() {
        this.currentFileName = null;
    }

    public void validationError(int line, int charPositionInLine, String msg) {
        this.parseIssues.add(new ParseIssue(line, charPositionInLine, msg, this.currentFileName, ParseIssueType.VALIDATION_ERROR));
        try {
            this.setAtLeastOneError(true);
            if (this.currentFileName == null) {
                log.error((Object)("line " + line + ":" + charPositionInLine + " " + msg));
            } else {
                String fileName = this.currentFileName;
                log.error((Object)(fileName + " line " + line + ":" + charPositionInLine + " " + msg));
            }
        }
        catch (Exception e1) {
            log.error((Object)("ERROR: while customizing error message:" + e1));
        }
    }

    public void validationWarning(int line, int charPositionInLine, String msg) {
        this.parseIssues.add(new ParseIssue(line, charPositionInLine, msg, this.currentFileName, ParseIssueType.VALIDATION_WARNING));
        try {
            this.setAtLeastOneWarning(true);
            if (this.currentFileName == null) {
                log.warn((Object)("line " + line + ":" + charPositionInLine + " " + msg));
            } else {
                String fileName = this.currentFileName;
                log.warn((Object)(fileName + " line " + line + ":" + charPositionInLine + " " + msg));
            }
        }
        catch (Exception e1) {
            log.warn((Object)("ERROR: while customizing error message:" + e1));
        }
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        this.parseIssues.add(new ParseIssue(line, charPositionInLine, msg, this.currentFileName, ParseIssueType.SYNTAX_ERROR));
        try {
            this.setAtLeastOneError(true);
            if (this.currentFileName == null) {
                log.error((Object)("line " + line + ":" + charPositionInLine + " " + msg));
            } else {
                String fileName = this.currentFileName;
                log.error((Object)(fileName + " line " + line + ":" + charPositionInLine + " " + msg));
            }
        }
        catch (Exception e1) {
            log.error((Object)("ERROR: while customizing error message:" + e1));
        }
    }

    public boolean isAtLeastOneError() {
        return this.atLeastOneError;
    }

    public void setAtLeastOneError(boolean atleastOneError) {
        this.atLeastOneError = atleastOneError;
    }

    public boolean isAtLeastOneWarning() {
        return this.atLeastOneWarning;
    }

    public void setAtLeastOneWarning(boolean atLeastOneWarning) {
        this.atLeastOneWarning = atLeastOneWarning;
    }

    public List<ParseIssue> getParseIssues() {
        Collections.sort(this.parseIssues);
        return this.parseIssues;
    }

    public void setParseIssues(List<ParseIssue> parseIssues) {
        this.parseIssues = parseIssues;
    }

    public static String generateParseIssuesMessage(String scriptString, List<ParseIssue> parseIssues) {
        if (scriptString == null) {
            return "No script string available.";
        }
        if (parseIssues == null) {
            return "No parse issues available.";
        }
        String[] scriptLines = scriptString.split("\\n");
        StringBuilder sb = new StringBuilder();
        sb.append("\n--------------------------------------------------------------");
        if (parseIssues.size() == 1) {
            sb.append("\nThe following parse issue was encountered:\n");
        } else {
            sb.append("\nThe following " + parseIssues.size() + " parse issues were encountered:\n");
        }
        int count = 1;
        for (ParseIssue parseIssue : parseIssues) {
            String name;
            if (parseIssues.size() > 1) {
                sb.append("#");
                sb.append(count++);
                sb.append(" ");
            }
            int issueLineNum = parseIssue.getLine();
            boolean displayScriptLine = false;
            String scriptLine = null;
            if (issueLineNum > 0 && issueLineNum <= scriptLines.length) {
                displayScriptLine = true;
                scriptLine = scriptLines[issueLineNum - 1];
            }
            if ((name = parseIssue.getFileName()) != null) {
                sb.append(name);
                sb.append(" ");
            }
            sb.append("[line ");
            sb.append(issueLineNum);
            sb.append(":");
            sb.append(parseIssue.getCharPositionInLine());
            sb.append("] [");
            sb.append(parseIssue.getParseIssueType().getText());
            sb.append("]");
            if (displayScriptLine) {
                sb.append(" -> ");
                sb.append(scriptLine);
            }
            sb.append("\n   ");
            sb.append(parseIssue.getMessage());
            sb.append("\n");
        }
        sb.append("--------------------------------------------------------------");
        return sb.toString();
    }

    public static enum ParseIssueType {
        SYNTAX_ERROR("Syntax error"),
        VALIDATION_ERROR("Validation error"),
        VALIDATION_WARNING("Validation warning");

        private final String text;

        private ParseIssueType(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public class ParseIssue
    implements Comparable<ParseIssue> {
        int line;
        int charPositionInLine;
        String message;
        String fileName;
        ParseIssueType parseIssueType;

        public ParseIssue(int line, int charPositionInLine, String message, String fileName, ParseIssueType parseIssueType) {
            this.line = line;
            this.charPositionInLine = charPositionInLine;
            this.message = message;
            this.fileName = fileName;
            this.parseIssueType = parseIssueType;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getCharPositionInLine() {
            return this.charPositionInLine;
        }

        public void setCharPositionInLine(int charPositionInLine) {
            this.charPositionInLine = charPositionInLine;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public ParseIssueType getParseIssueType() {
            return this.parseIssueType;
        }

        public void setParseIssueType(ParseIssueType parseIssueType) {
            this.parseIssueType = parseIssueType;
        }

        @Override
        public int compareTo(ParseIssue that) {
            if (this.line == that.line) {
                return this.charPositionInLine - that.charPositionInLine;
            }
            return this.line - that.line;
        }
    }
}

