/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.apache.sysml.parser.AssignmentStatement;
import org.apache.sysml.parser.BinaryExpression;
import org.apache.sysml.parser.BooleanExpression;
import org.apache.sysml.parser.BooleanIdentifier;
import org.apache.sysml.parser.BuiltinFunctionExpression;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.MultiAssignmentStatement;
import org.apache.sysml.parser.OutputStatement;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.ParameterizedBuiltinFunctionExpression;
import org.apache.sysml.parser.PrintStatement;
import org.apache.sysml.parser.RelationalExpression;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.common.CustomErrorListener;
import org.apache.sysml.parser.common.ExpressionInfo;
import org.apache.sysml.parser.common.StatementInfo;

public abstract class CommonSyntacticValidator {
    protected final CustomErrorListener errorListener;
    protected final String currentFile;
    protected String _workingDir = ".";
    protected Map<String, String> argVals = null;
    protected String sourceNamespace = null;
    protected static ThreadLocal<HashMap<String, String>> _scripts = new ThreadLocal<HashMap<String, String>>(){

        @Override
        protected HashMap<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    protected HashMap<String, String> sources;
    protected Set<String> functions;

    public static void init() {
        _scripts.get().clear();
    }

    public CommonSyntacticValidator(CustomErrorListener errorListener, Map<String, String> argVals, String sourceNamespace, Set<String> prepFunctions) {
        this.errorListener = errorListener;
        this.currentFile = errorListener.getCurrentFileName();
        this.argVals = argVals;
        this.sourceNamespace = sourceNamespace;
        this.sources = new HashMap();
        this.functions = null != prepFunctions ? prepFunctions : new HashSet();
    }

    protected void notifyErrorListeners(String message, Token op) {
        this.errorListener.validationError(op.getLine(), op.getCharPositionInLine(), message);
    }

    protected void raiseWarning(String message, Token op) {
        this.errorListener.validationWarning(op.getLine(), op.getCharPositionInLine(), message);
    }

    public abstract String namespaceResolutionOp();

    protected String[] getQualifiedNames(String fullyQualifiedFunctionName) {
        String splitStr = Pattern.quote(this.namespaceResolutionOp());
        String[] fnNames = fullyQualifiedFunctionName.split(splitStr);
        String functionName = "";
        String namespace = "";
        if (fnNames.length == 1) {
            namespace = DMLProgram.DEFAULT_NAMESPACE;
            functionName = fnNames[0].trim();
        } else if (fnNames.length == 2) {
            namespace = this.getQualifiedNamespace(fnNames[0].trim());
            functionName = fnNames[1].trim();
        } else {
            return null;
        }
        String[] retVal = new String[]{namespace, functionName};
        return retVal;
    }

    protected String getQualifiedNamespace(String namespace) {
        String path = this.sources.get(namespace);
        return path != null && path.length() > 0 ? path : namespace;
    }

    protected void validateNamespace(String namespace, String filePath, ParserRuleContext ctx) {
        if (!this.sources.containsKey(namespace)) {
            this.sources.put(namespace, filePath);
        } else {
            this.notifyErrorListeners("Namespace Conflict: '" + namespace + "' already defined as " + this.sources.get(namespace), ctx.start);
        }
    }

    protected void setFileLineColumn(Expression expr, ParserRuleContext ctx) {
        String txt = ctx.getText();
        expr.setFilename(this.currentFile);
        expr.setBeginLine(ctx.start.getLine());
        expr.setBeginColumn(ctx.start.getCharPositionInLine());
        expr.setEndLine(ctx.stop.getLine());
        expr.setEndColumn(ctx.stop.getCharPositionInLine());
        if (expr.getBeginColumn() == expr.getEndColumn() && expr.getBeginLine() == expr.getEndLine() && txt.length() > 1) {
            expr.setEndColumn(expr.getBeginColumn() + txt.length() - 1);
        }
    }

    protected void setFileLineColumn(Statement stmt, ParserRuleContext ctx) {
        String txt = ctx.getText();
        stmt.setFilename(this.currentFile);
        stmt.setBeginLine(ctx.start.getLine());
        stmt.setBeginColumn(ctx.start.getCharPositionInLine());
        stmt.setEndLine(ctx.stop.getLine());
        stmt.setEndColumn(ctx.stop.getCharPositionInLine());
        if (stmt.getBeginColumn() == stmt.getEndColumn() && stmt.getBeginLine() == stmt.getEndLine() && txt.length() > 1) {
            stmt.setEndColumn(stmt.getBeginColumn() + txt.length() - 1);
        }
    }

    public abstract String trueStringLiteral();

    public abstract String falseStringLiteral();

    protected void binaryExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo right, ExpressionInfo me, String op) {
        if (left.expr != null && right.expr != null) {
            Expression.BinaryOp bop = Expression.getBinaryOp(op);
            BinaryExpression be = new BinaryExpression(bop);
            be = new BinaryExpression(bop);
            be.setLeft(left.expr);
            be.setRight(right.expr);
            me.expr = be;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void relationalExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo right, ExpressionInfo me, String op) {
        if (left.expr != null && right.expr != null) {
            Expression.RelationalOp rop = Expression.getRelationalOp(op);
            RelationalExpression re = new RelationalExpression(rop);
            re.setLeft(left.expr);
            re.setRight(right.expr);
            me.expr = re;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void booleanExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo right, ExpressionInfo me, String op) {
        if (left.expr != null && right.expr != null) {
            Expression.BooleanOp bop = Expression.getBooleanOp(op);
            BooleanExpression re = new BooleanExpression(bop);
            re.setLeft(left.expr);
            re.setRight(right.expr);
            me.expr = re;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void unaryExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo me, String op) {
        if (left.expr != null) {
            Token start = ctx.start;
            String fileName = this.currentFile;
            int line = start.getLine();
            int col = start.getCharPositionInLine();
            if (left.expr instanceof IntIdentifier) {
                if (op.equals("-")) {
                    ((IntIdentifier)left.expr).multiplyByMinusOne();
                }
                me.expr = left.expr;
            } else if (left.expr instanceof DoubleIdentifier) {
                if (op.equals("-")) {
                    ((DoubleIdentifier)left.expr).multiplyByMinusOne();
                }
                me.expr = left.expr;
            } else {
                IntIdentifier right = new IntIdentifier(1L, fileName, line, col, line, col);
                if (op.equals("-")) {
                    right = new IntIdentifier(-1L, fileName, line, col, line, col);
                }
                Expression.BinaryOp bop = Expression.getBinaryOp("*");
                BinaryExpression be = new BinaryExpression(bop);
                be.setLeft(left.expr);
                be.setRight(right);
                me.expr = be;
            }
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void unaryBooleanExpressionHelper(ParserRuleContext ctx, ExpressionInfo left, ExpressionInfo me, String op) {
        if (left.expr != null) {
            Expression.BooleanOp bop = Expression.getBooleanOp(op);
            BooleanExpression be = new BooleanExpression(bop);
            be.setLeft(left.expr);
            me.expr = be;
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected void constDoubleIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me) {
        try {
            Token start = ctx.start;
            double val = Double.parseDouble(ctx.getText());
            int linePosition = start.getLine();
            int charPosition = start.getCharPositionInLine();
            me.expr = new DoubleIdentifier(val, this.currentFile, linePosition, charPosition, linePosition, charPosition);
            this.setFileLineColumn(me.expr, ctx);
        }
        catch (Exception e) {
            this.notifyErrorListeners("cannot parse the float value: '" + ctx.getText() + "'", ctx.getStart());
            return;
        }
    }

    protected void constIntIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me) {
        try {
            Token start = ctx.start;
            long val = Long.parseLong(ctx.getText());
            int linePosition = start.getLine();
            int charPosition = start.getCharPositionInLine();
            me.expr = new IntIdentifier(val, this.currentFile, linePosition, charPosition, linePosition, charPosition);
            this.setFileLineColumn(me.expr, ctx);
        }
        catch (Exception e) {
            this.notifyErrorListeners("cannot parse the int value: '" + ctx.getText() + "'", ctx.getStart());
            return;
        }
    }

    protected String extractStringInQuotes(String text, boolean inQuotes) {
        String val = null;
        if (inQuotes) {
            if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
                if (text.length() > 2) {
                    val = text.substring(1, text.length() - 1).replaceAll("\\\\b", "\b").replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n").replaceAll("\\\\f", "\f").replaceAll("\\\\r", "\r").replace("\\'", "'").replace("\\\"", "\"");
                } else if (text.equals("\"\"") || text.equals("''")) {
                    val = "";
                }
            }
        } else {
            val = text.replaceAll("\\\\b", "\b").replaceAll("\\\\t", "\t").replaceAll("\\\\n", "\n").replaceAll("\\\\f", "\f").replaceAll("\\\\r", "\r").replace("\\'", "'").replace("\\\"", "\"");
        }
        return val;
    }

    protected void constStringIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me) {
        String val = this.extractStringInQuotes(ctx.getText(), true);
        if (val == null) {
            this.notifyErrorListeners("incorrect string literal ", ctx.start);
            return;
        }
        int linePosition = ctx.start.getLine();
        int charPosition = ctx.start.getCharPositionInLine();
        me.expr = new StringIdentifier(val, this.currentFile, linePosition, charPosition, linePosition, charPosition);
        this.setFileLineColumn(me.expr, ctx);
    }

    protected void booleanIdentifierHelper(ParserRuleContext ctx, boolean val, ExpressionInfo info) {
        int linePosition = ctx.start.getLine();
        int charPosition = ctx.start.getCharPositionInLine();
        info.expr = new BooleanIdentifier(val, this.currentFile, linePosition, charPosition, linePosition, charPosition);
        this.setFileLineColumn(info.expr, ctx);
    }

    protected void exitDataIdExpressionHelper(ParserRuleContext ctx, ExpressionInfo me, ExpressionInfo dataInfo) {
        me.expr = dataInfo.expr;
        if (me.expr != null) {
            int line = ctx.start.getLine();
            int col = ctx.start.getCharPositionInLine();
            me.expr.setAllPositions(this.currentFile, line, col, line, col);
            this.setFileLineColumn(me.expr, ctx);
        }
    }

    protected ConstIdentifier getConstIdFromString(String varValue, Token start) {
        int linePosition = start.getLine();
        int charPosition = start.getCharPositionInLine();
        if (varValue.equals(this.trueStringLiteral())) {
            return new BooleanIdentifier(true, this.currentFile, linePosition, charPosition, linePosition, charPosition);
        }
        if (varValue.equals(this.falseStringLiteral())) {
            return new BooleanIdentifier(false, this.currentFile, linePosition, charPosition, linePosition, charPosition);
        }
        try {
            long lval = Long.parseLong(varValue);
            return new IntIdentifier(lval, this.currentFile, linePosition, charPosition, linePosition, charPosition);
        }
        catch (Exception lval) {
            try {
                double dval = Double.parseDouble(varValue);
                return new DoubleIdentifier(dval, this.currentFile, linePosition, charPosition, linePosition, charPosition);
            }
            catch (Exception dval) {
                String val = "";
                String text = varValue;
                if (text.startsWith("\"") && text.endsWith("\"") || text.startsWith("'") && text.endsWith("'")) {
                    if (text.length() > 2) {
                        val = this.extractStringInQuotes(text, true);
                    }
                } else {
                    val = this.extractStringInQuotes(text, false);
                }
                return new StringIdentifier(val, this.currentFile, linePosition, charPosition, linePosition, charPosition);
            }
        }
    }

    protected void fillExpressionInfoCommandLineParameters(String varName, ExpressionInfo dataInfo, Token start) {
        if (!varName.startsWith("$")) {
            this.notifyErrorListeners("commandline param doesnot start with $", start);
            return;
        }
        String varValue = null;
        for (Map.Entry<String, String> arg : this.argVals.entrySet()) {
            if (!arg.getKey().equals(varName)) continue;
            if (varValue != null) {
                this.notifyErrorListeners("multiple values passed for the parameter " + varName + " via commandline", start);
                return;
            }
            varValue = arg.getValue();
        }
        if (varValue == null) {
            return;
        }
        if (varValue.equals("")) {
            return;
        }
        dataInfo.expr = this.getConstIdFromString(varValue, start);
    }

    protected void exitAssignmentStatementHelper(ParserRuleContext ctx, String lhs, ExpressionInfo dataInfo, Token lhsStart, ExpressionInfo rhs, StatementInfo info) {
        if (lhs.startsWith("$")) {
            this.notifyErrorListeners("assignment of commandline parameters is not allowed. (Quickfix: try using someLocalVariable=ifdef(" + lhs + ", default value))", ctx.start);
            return;
        }
        DataIdentifier target = null;
        if (dataInfo.expr instanceof DataIdentifier) {
            target = (DataIdentifier)dataInfo.expr;
            Expression source = rhs.expr;
            int line = ctx.start.getLine();
            int col = ctx.start.getCharPositionInLine();
            try {
                info.stmt = new AssignmentStatement(target, source, line, col, line, col);
                this.setFileLineColumn(info.stmt, ctx);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("invalid assignment", lhsStart);
                return;
            }
        } else {
            this.notifyErrorListeners("incorrect lvalue in assignment statement", lhsStart);
            return;
        }
    }

    protected void setPrintStatement(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExpression, StatementInfo thisinfo) {
        int numParams = paramExpression.size();
        if (numParams == 0) {
            this.notifyErrorListeners(functionName + "() must have more than 0 parameters", ctx.start);
            return;
        }
        if (numParams == 1) {
            Expression expr = paramExpression.get(0).getExpr();
            if (expr == null) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
            try {
                int line = ctx.start.getLine();
                int col = ctx.start.getCharPositionInLine();
                ArrayList<Expression> expList = new ArrayList<Expression>();
                expList.add(expr);
                thisinfo.stmt = new PrintStatement(functionName, expList, line, col, line, col);
                this.setFileLineColumn(thisinfo.stmt, ctx);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
        }
        if (numParams > 1) {
            if ("stop".equals(functionName)) {
                this.notifyErrorListeners("stop() function cannot have more than 1 parameter", ctx.start);
                return;
            }
            Expression firstExp = paramExpression.get(0).getExpr();
            if (firstExp == null) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
            if (!(firstExp instanceof StringIdentifier)) {
                this.notifyErrorListeners("printf-style functionality requires first print parameter to be a string", ctx.start);
                return;
            }
            try {
                int line = ctx.start.getLine();
                int col = ctx.start.getCharPositionInLine();
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                for (ParameterExpression pe : paramExpression) {
                    Expression expression = pe.getExpr();
                    expressions.add(expression);
                }
                thisinfo.stmt = new PrintStatement(functionName, expressions, line, col, line, col);
                this.setFileLineColumn(thisinfo.stmt, ctx);
            }
            catch (LanguageException e) {
                this.notifyErrorListeners("cannot process " + functionName + "() function", ctx.start);
                return;
            }
        }
    }

    protected void setOutputStatement(ParserRuleContext ctx, ArrayList<ParameterExpression> paramExpression, StatementInfo info) {
        if (paramExpression.size() < 2) {
            this.notifyErrorListeners("incorrect usage of write function (at least 2 arguments required)", ctx.start);
            return;
        }
        if (paramExpression.get(0).getExpr() instanceof DataIdentifier) {
            String fileName = this.currentFile;
            int line = ctx.start.getLine();
            int col = ctx.start.getCharPositionInLine();
            HashMap<String, Expression> varParams = new HashMap<String, Expression>();
            varParams.put("iofilename", paramExpression.get(1).getExpr());
            for (int i = 2; i < paramExpression.size(); ++i) {
                varParams.put(paramExpression.get(i).getName(), paramExpression.get(i).getExpr());
            }
            DataExpression dataExpression = new DataExpression(Expression.DataOp.WRITE, varParams, fileName, line, col, line, col);
            info.stmt = new OutputStatement((DataIdentifier)paramExpression.get(0).getExpr(), Expression.DataOp.WRITE, fileName, line, col, line, col);
            this.setFileLineColumn(info.stmt, ctx);
            ((OutputStatement)info.stmt).setExprParams(dataExpression);
        } else {
            this.notifyErrorListeners("incorrect usage of write function", ctx.start);
        }
    }

    protected void setAssignmentStatement(ParserRuleContext ctx, StatementInfo info, DataIdentifier target, Expression expression) {
        try {
            info.stmt = new AssignmentStatement(target, expression, ctx.start.getLine(), ctx.start.getCharPositionInLine(), ctx.start.getLine(), ctx.start.getCharPositionInLine());
            this.setFileLineColumn(info.stmt, ctx);
        }
        catch (LanguageException e) {
            this.notifyErrorListeners("invalid function call", ctx.start);
            return;
        }
    }

    protected abstract ConvertedDMLSyntax convertToDMLSyntax(ParserRuleContext var1, String var2, String var3, ArrayList<ParameterExpression> var4, Token var5);

    protected abstract Expression handleLanguageSpecificFunction(ParserRuleContext var1, String var2, ArrayList<ParameterExpression> var3);

    protected boolean buildForBuiltInFunction(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExpressions, Action f) {
        String fileName = this.currentFile;
        int line = ctx.start.getLine();
        int col = ctx.start.getCharPositionInLine();
        try {
            if (this.functions.contains(functionName)) {
                return false;
            }
            Expression lsf = this.handleLanguageSpecificFunction(ctx, functionName, paramExpressions);
            if (lsf != null) {
                this.setFileLineColumn(lsf, ctx);
                f.execute(lsf);
                return true;
            }
            BuiltinFunctionExpression bife = BuiltinFunctionExpression.getBuiltinFunctionExpression(functionName, paramExpressions, fileName, line, col, line, col);
            if (bife != null) {
                f.execute(bife);
                return true;
            }
            ParameterizedBuiltinFunctionExpression pbife = ParameterizedBuiltinFunctionExpression.getParamBuiltinFunctionExpression(functionName, paramExpressions, fileName, line, col, line, col);
            if (pbife != null) {
                f.execute(pbife);
                return true;
            }
            DataExpression dbife = DataExpression.getDataExpression(functionName, paramExpressions, fileName, line, col, line, col, this.errorListener);
            if (dbife != null) {
                f.execute(dbife);
                return true;
            }
        }
        catch (Exception e) {
            this.notifyErrorListeners("unable to process builtin function expression " + functionName + ":" + e.getMessage(), ctx.start);
            return true;
        }
        return false;
    }

    protected void functionCallAssignmentStatementHelper(final ParserRuleContext ctx, Set<String> printStatements, Set<String> outputStatements, Expression dataInfo, final StatementInfo info, Token nameToken, Token targetListToken, String namespace, String functionName, ArrayList<ParameterExpression> paramExpression, boolean hasLHS) {
        DataIdentifier ftarget;
        Action f;
        boolean validBIF;
        ConvertedDMLSyntax convertedSyntax = this.convertToDMLSyntax(ctx, namespace, functionName, paramExpression, nameToken);
        if (convertedSyntax == null) {
            return;
        }
        namespace = convertedSyntax.namespace;
        functionName = convertedSyntax.functionName;
        paramExpression = convertedSyntax.paramExpression;
        if (namespace.equals(DMLProgram.DEFAULT_NAMESPACE) && !this.functions.contains(functionName)) {
            if (printStatements.contains(functionName)) {
                this.setPrintStatement(ctx, functionName, paramExpression, info);
                return;
            }
            if (outputStatements.contains(functionName)) {
                this.setOutputStatement(ctx, paramExpression, info);
                return;
            }
        }
        DataIdentifier target = null;
        if (dataInfo instanceof DataIdentifier) {
            target = (DataIdentifier)dataInfo;
        } else if (dataInfo != null) {
            this.notifyErrorListeners("incorrect lvalue for function call ", targetListToken);
            return;
        }
        if (namespace.equals(DMLProgram.DEFAULT_NAMESPACE) && !this.functions.contains(functionName) && (validBIF = this.buildForBuiltInFunction(ctx, functionName, paramExpression, f = new Action(ftarget = target){
            final /* synthetic */ DataIdentifier val$ftarget;
            {
                this.val$ftarget = dataIdentifier;
            }

            @Override
            public void execute(Expression e) {
                CommonSyntacticValidator.this.setAssignmentStatement(ctx, info, this.val$ftarget, e);
            }
        }))) {
            return;
        }
        FunctionCallIdentifier functCall = new FunctionCallIdentifier(paramExpression);
        functCall.setFunctionName(functionName);
        String inferNamespace = this.sourceNamespace != null && this.sourceNamespace.length() > 0 && DMLProgram.DEFAULT_NAMESPACE.equals(namespace) ? this.sourceNamespace : namespace;
        functCall.setFunctionNamespace(inferNamespace);
        functCall.setAllPositions(this.currentFile, ctx.start.getLine(), ctx.start.getCharPositionInLine(), ctx.stop.getLine(), ctx.stop.getCharPositionInLine());
        this.setAssignmentStatement(ctx, info, target, functCall);
    }

    protected void setMultiAssignmentStatement(ArrayList<DataIdentifier> target, Expression expression, ParserRuleContext ctx, StatementInfo info) {
        info.stmt = new MultiAssignmentStatement(target, expression);
        info.stmt.setAllPositions(this.currentFile, ctx.start.getLine(), ctx.start.getCharPositionInLine(), ctx.start.getLine(), ctx.start.getCharPositionInLine());
        this.setFileLineColumn(info.stmt, ctx);
    }

    protected void checkValidDataType(String datatype, Token start) {
        boolean validMatrixType;
        boolean bl = validMatrixType = datatype.equals("matrix") || datatype.equals("Matrix") || datatype.equals("frame") || datatype.equals("Frame") || datatype.equals("scalar") || datatype.equals("Scalar");
        if (!validMatrixType) {
            this.notifyErrorListeners("incorrect datatype (expected matrix, frame or scalar)", start);
        }
    }

    public static interface Action {
        public void execute(Expression var1);
    }

    public static class ConvertedDMLSyntax {
        public final String namespace;
        public final String functionName;
        public final ArrayList<ParameterExpression> paramExpression;

        public ConvertedDMLSyntax(String namespace, String functionName, ArrayList<ParameterExpression> paramExpression) {
            this.namespace = namespace;
            this.functionName = functionName;
            this.paramExpression = paramExpression;
        }
    }
}

