/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import java.util.Set;
import org.apache.sysml.parser.DataIdentifier;

public class VariableSet {
    private HashMap<String, DataIdentifier> _variables = new HashMap();

    public VariableSet() {
    }

    public VariableSet(VariableSet vs) {
        if (vs != null) {
            HashMap<String, DataIdentifier> vars = vs.getVariables();
            this._variables.putAll(vars);
        }
    }

    public void addVariable(String name, DataIdentifier id) {
        this._variables.put(name, id);
    }

    public void addVariables(VariableSet vs) {
        if (vs != null) {
            HashMap<String, DataIdentifier> vars = vs.getVariables();
            this._variables.putAll(vars);
        }
    }

    public void removeVariables(VariableSet vs) {
        if (vs != null) {
            Set<String> vars = vs.getVariables().keySet();
            for (String var : vars) {
                this._variables.remove(var);
            }
        }
    }

    public boolean containsVariable(String name) {
        return this._variables.containsKey(name);
    }

    public DataIdentifier getVariable(String name) {
        return this._variables.get(name);
    }

    public Set<String> getVariableNames() {
        return this._variables.keySet();
    }

    public HashMap<String, DataIdentifier> getVariables() {
        return this._variables;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String var : this._variables.keySet()) {
            sb.append(var + ",");
        }
        return sb.toString();
    }
}

