/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.VariableSet;

public abstract class Statement {
    protected static final Log LOG = LogFactory.getLog((String)Statement.class.getName());
    public static final String OUTPUTSTATEMENT = "WRITE";
    public static final String SEQ_FROM = "from";
    public static final String SEQ_TO = "to";
    public static final String SEQ_INCR = "incr";
    public static final String SOURCE = "source";
    public static final String SETWD = "setwd";
    public static final String MATRIX_DATA_TYPE = "matrix";
    public static final String FRAME_DATA_TYPE = "frame";
    public static final String SCALAR_DATA_TYPE = "scalar";
    public static final String DOUBLE_VALUE_TYPE = "double";
    public static final String BOOLEAN_VALUE_TYPE = "boolean";
    public static final String INT_VALUE_TYPE = "int";
    public static final String STRING_VALUE_TYPE = "string";
    public static final String GAGG_TARGET = "target";
    public static final String GAGG_GROUPS = "groups";
    public static final String GAGG_WEIGHTS = "weights";
    public static final String GAGG_FN = "fn";
    public static final String GAGG_FN_SUM = "sum";
    public static final String GAGG_FN_COUNT = "count";
    public static final String GAGG_FN_MEAN = "mean";
    public static final String GAGG_FN_VARIANCE = "variance";
    public static final String GAGG_FN_CM = "centralmoment";
    public static final String GAGG_FN_CM_ORDER = "order";
    public static final String GAGG_NUM_GROUPS = "ngroups";
    private boolean isEmptyNewLineStatement = false;
    private String _filename;
    private int _beginLine;
    private int _beginColumn;
    private int _endLine;
    private int _endColumn;

    public abstract boolean controlStatement();

    public abstract VariableSet variablesRead();

    public abstract VariableSet variablesUpdated();

    public abstract void initializeforwardLV(VariableSet var1) throws LanguageException;

    public abstract VariableSet initializebackwardLV(VariableSet var1) throws LanguageException;

    public abstract Statement rewriteStatement(String var1) throws LanguageException;

    public boolean isEmptyNewLineStatement() {
        return this.isEmptyNewLineStatement;
    }

    public void setEmptyNewLineStatement(boolean isEmptyNewLineStatement) {
        this.isEmptyNewLineStatement = isEmptyNewLineStatement;
    }

    public void setFilename(String passed) {
        this._filename = passed;
    }

    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    public void setAllPositions(String filename, int blp, int bcp, int elp, int ecp) {
        this._filename = filename;
        this._beginLine = blp;
        this._beginColumn = bcp;
        this._endLine = elp;
        this._endColumn = ecp;
    }

    public int getBeginLine() {
        return this._beginLine;
    }

    public int getBeginColumn() {
        return this._beginColumn;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public String getFilename() {
        return this._filename;
    }

    public String printErrorLocation() {
        return "ERROR: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public String printWarningLocation() {
        return "WARNING: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public void raiseValidateError(String msg, boolean conditional) throws LanguageException {
        this.raiseValidateError(msg, conditional, null);
    }

    public void raiseValidateError(String msg, boolean conditional, String errorCode) throws LanguageException {
        if (!conditional) {
            String fullMsg = this.printErrorLocation() + msg;
            if (errorCode != null) {
                throw new LanguageException(fullMsg, errorCode);
            }
            throw new LanguageException(fullMsg);
        }
        String fullMsg = this.printWarningLocation() + msg;
        LOG.warn((Object)fullMsg);
    }
}

