/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLBreakpointManager;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;

public class AssignmentStatement
extends Statement {
    private ArrayList<DataIdentifier> _targetList = new ArrayList();
    private Expression _source;

    @Override
    public Statement rewriteStatement(String prefix) throws LanguageException {
        DataIdentifier newTarget = (DataIdentifier)this._targetList.get(0).rewriteExpression(prefix);
        Expression newSource = this._source.rewriteExpression(prefix);
        AssignmentStatement retVal = new AssignmentStatement(newTarget, newSource, this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        return retVal;
    }

    public AssignmentStatement(DataIdentifier t, Expression s, int beginLine, int beginCol, int endLine, int endCol) throws LanguageException {
        this._targetList.add(t);
        this._source = s;
        this.setBeginLine(beginLine);
        this.setBeginColumn(beginCol);
        this.setEndLine(endLine);
        this.setEndColumn(endCol);
    }

    public DataIdentifier getTarget() {
        return this._targetList.get(0);
    }

    public ArrayList<DataIdentifier> getTargetList() {
        return this._targetList;
    }

    public Expression getSource() {
        return this._source;
    }

    public void setSource(Expression s) {
        this._source = s;
    }

    @Override
    public boolean controlStatement() {
        if (DMLScript.ENABLE_DEBUG_MODE) {
            DMLBreakpointManager.insertBreakpoint(this._source.getBeginLine());
            return true;
        }
        return this._source instanceof FunctionCallIdentifier;
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        return lo;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._source.variablesRead());
        for (int i = 0; i < this._targetList.size(); ++i) {
            if (!(this._targetList.get(i) instanceof IndexedIdentifier)) continue;
            IndexedIdentifier target = (IndexedIdentifier)this._targetList.get(i);
            result.addVariables(target.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (DataIdentifier target : this._targetList) {
            if (target == null) continue;
            result.addVariable(target.getName(), target);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._targetList.size(); ++i) {
            DataIdentifier di = this._targetList.get(i);
            sb.append(di);
        }
        sb.append(" = ");
        if (this._source instanceof StringIdentifier) {
            sb.append("\"");
            sb.append(this._source.toString());
            sb.append("\"");
        } else {
            sb.append(this._source.toString());
        }
        sb.append(";");
        return sb.toString();
    }
}

