/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class PartialAggregate
extends Lop {
    private Aggregate.OperationTypes operation;
    private DirectionTypes direction;
    private boolean _dropCorr = false;
    private int _numThreads = -1;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public PartialAggregate(Lop input, Aggregate.OperationTypes op, DirectionTypes direct, Expression.DataType dt, Expression.ValueType vt) throws LopsException {
        super(Lop.Type.PartialAggregate, dt, vt);
        this.init(input, op, direct, dt, vt, LopProperties.ExecType.MR);
    }

    public PartialAggregate(Lop input, Aggregate.OperationTypes op, DirectionTypes direct, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) throws LopsException {
        super(Lop.Type.PartialAggregate, dt, vt);
        this.init(input, op, direct, dt, vt, et);
        this._numThreads = k;
    }

    public PartialAggregate(Lop input, Aggregate.OperationTypes op, DirectionTypes direct, Expression.DataType dt, Expression.ValueType vt, AggBinaryOp.SparkAggType aggtype, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.PartialAggregate, dt, vt);
        this.init(input, op, direct, dt, vt, et);
        this._aggtype = aggtype;
    }

    private void init(Lop input, Aggregate.OperationTypes op, DirectionTypes direct, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.direction = direct;
        this.addInput(input);
        input.addOutput(this);
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            this.lps.addCompatibility(JobType.MMCJ);
            this.lps.addCompatibility(JobType.MMRJ);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    public void setDropCorrection() {
        this._dropCorr = true;
    }

    public CorrectionLocationType getCorrectionLocation() throws LopsException {
        return PartialAggregate.getCorrectionLocation(this.operation, this.direction);
    }

    public static CorrectionLocationType getCorrectionLocation(Aggregate.OperationTypes operation, DirectionTypes direction) throws LopsException {
        CorrectionLocationType loc;
        block0 : switch (operation) {
            case KahanSum: 
            case KahanSumSq: 
            case KahanTrace: {
                switch (direction) {
                    case Col: {
                        loc = CorrectionLocationType.LASTROW;
                        break block0;
                    }
                    case Row: 
                    case RowCol: {
                        loc = CorrectionLocationType.LASTCOLUMN;
                        break block0;
                    }
                }
                throw new LopsException("PartialAggregate.getCorrectionLocation() - Unknown aggregate direction: " + (Object)((Object)direction));
            }
            case Mean: {
                switch (direction) {
                    case Col: {
                        loc = CorrectionLocationType.LASTTWOROWS;
                        break block0;
                    }
                    case Row: 
                    case RowCol: {
                        loc = CorrectionLocationType.LASTTWOCOLUMNS;
                        break block0;
                    }
                }
                throw new LopsException("PartialAggregate.getCorrectionLocation() - Unknown aggregate direction: " + (Object)((Object)direction));
            }
            case Var: {
                switch (direction) {
                    case Col: {
                        loc = CorrectionLocationType.LASTFOURROWS;
                        break block0;
                    }
                    case Row: 
                    case RowCol: {
                        loc = CorrectionLocationType.LASTFOURCOLUMNS;
                        break block0;
                    }
                }
                throw new LopsException("PartialAggregate.getCorrectionLocation() - Unknown aggregate direction: " + (Object)((Object)direction));
            }
            case MaxIndex: 
            case MinIndex: {
                loc = CorrectionLocationType.LASTCOLUMN;
                break;
            }
            default: {
                loc = CorrectionLocationType.NONE;
            }
        }
        return loc;
    }

    public void setDimensionsBasedOnDirection(long dim1, long dim2, long rowsPerBlock, long colsPerBlock) throws LopsException {
        PartialAggregate.setDimensionsBasedOnDirection(this, dim1, dim2, rowsPerBlock, colsPerBlock, this.direction);
    }

    public static void setDimensionsBasedOnDirection(Lop lop, long dim1, long dim2, long rowsPerBlock, long colsPerBlock, DirectionTypes dir) throws LopsException {
        block5: {
            try {
                if (dir == DirectionTypes.Row) {
                    lop.outParams.setDimensions(dim1, 1L, rowsPerBlock, colsPerBlock, -1L);
                    break block5;
                }
                if (dir == DirectionTypes.Col) {
                    lop.outParams.setDimensions(1L, dim2, rowsPerBlock, colsPerBlock, -1L);
                    break block5;
                }
                if (dir == DirectionTypes.RowCol) {
                    lop.outParams.setDimensions(1L, 1L, rowsPerBlock, colsPerBlock, -1L);
                    break block5;
                }
                throw new LopsException("In PartialAggregate Lop, Unknown aggregate direction " + (Object)((Object)dir));
            }
            catch (HopsException e) {
                throw new LopsException("In PartialAggregate Lop, error setting dimensions based on direction", e);
            }
        }
    }

    @Override
    public String toString() {
        return "Partial Aggregate " + (Object)((Object)this.operation);
    }

    private String getOpcode() {
        return PartialAggregate.getOpcode(this.operation, this.direction);
    }

    @Override
    public String getInstructions(String input1, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append((Object)this._aggtype);
        } else if (this.getExecType() == LopProperties.ExecType.MR) {
            sb.append(this._dropCorr);
        } else if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index, int output_index) {
        return this.getInstructions(String.valueOf(input_index), String.valueOf(output_index));
    }

    public static String getOpcode(Aggregate.OperationTypes op, DirectionTypes dir) {
        switch (op) {
            case Sum: {
                if (dir == DirectionTypes.RowCol) {
                    return "ua+";
                }
                if (dir == DirectionTypes.Row) {
                    return "uar+";
                }
                if (dir != DirectionTypes.Col) break;
                return "uac+";
            }
            case KahanSum: {
                if (dir == DirectionTypes.RowCol) {
                    return "uak+";
                }
                if (dir == DirectionTypes.Row) {
                    return "uark+";
                }
                if (dir != DirectionTypes.Col) break;
                return "uack+";
            }
            case KahanSumSq: {
                if (dir == DirectionTypes.RowCol) {
                    return "uasqk+";
                }
                if (dir == DirectionTypes.Row) {
                    return "uarsqk+";
                }
                if (dir != DirectionTypes.Col) break;
                return "uacsqk+";
            }
            case Mean: {
                if (dir == DirectionTypes.RowCol) {
                    return "uamean";
                }
                if (dir == DirectionTypes.Row) {
                    return "uarmean";
                }
                if (dir != DirectionTypes.Col) break;
                return "uacmean";
            }
            case Var: {
                if (dir == DirectionTypes.RowCol) {
                    return "uavar";
                }
                if (dir == DirectionTypes.Row) {
                    return "uarvar";
                }
                if (dir != DirectionTypes.Col) break;
                return "uacvar";
            }
            case Product: {
                if (dir != DirectionTypes.RowCol) break;
                return "ua*";
            }
            case Max: {
                if (dir == DirectionTypes.RowCol) {
                    return "uamax";
                }
                if (dir == DirectionTypes.Row) {
                    return "uarmax";
                }
                if (dir != DirectionTypes.Col) break;
                return "uacmax";
            }
            case Min: {
                if (dir == DirectionTypes.RowCol) {
                    return "uamin";
                }
                if (dir == DirectionTypes.Row) {
                    return "uarmin";
                }
                if (dir != DirectionTypes.Col) break;
                return "uacmin";
            }
            case MaxIndex: {
                if (dir != DirectionTypes.Row) break;
                return "uarimax";
            }
            case MinIndex: {
                if (dir != DirectionTypes.Row) break;
                return "uarimin";
            }
            case Trace: {
                if (dir != DirectionTypes.RowCol) break;
                return "uatrace";
            }
            case KahanTrace: {
                if (dir != DirectionTypes.RowCol) break;
                return "uaktrace";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for PartialAggregate operation " + (Object)((Object)op));
    }

    public static enum CorrectionLocationType {
        NONE,
        LASTROW,
        LASTCOLUMN,
        LASTTWOROWS,
        LASTTWOCOLUMNS,
        LASTFOURROWS,
        LASTFOURCOLUMNS,
        INVALID;

    }

    public static enum DirectionTypes {
        RowCol,
        Row,
        Col;

    }
}

