/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class ConvolutionTransform
extends Lop {
    private OperationTypes operation = null;
    private int numThreads = -1;

    public ConvolutionTransform(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(input, op, dt, vt, et);
        this.numThreads = k;
    }

    public ConvolutionTransform(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(input1, op, dt, vt, et);
        this.numThreads = k;
        this.addInput(input2);
        input2.addOutput(this);
        this.setLevel();
    }

    private void init(Lop input, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.addInput(input);
        input.addOutput(this);
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            throw new RuntimeException("The execution type is not supported: " + et.name());
        }
        breaksAlignment = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    private String getOpcode() {
        switch (this.operation) {
            case MAX_POOLING: {
                return "maxpooling";
            }
            case RELU_MAX_POOLING: {
                return "relu_maxpooling";
            }
            case RELU_BACKWARD: {
                return "relu_backward";
            }
            case MAX_POOLING_BACKWARD: {
                return "maxpooling_backward";
            }
            case DIRECT_CONV2D: {
                return "conv2d";
            }
            case DIRECT_CONV2D_BIAS_ADD: {
                return "conv2d_bias_add";
            }
            case BIAS_ADD: {
                return "bias_add";
            }
            case BIAS_MULTIPLY: {
                return "bias_multiply";
            }
            case DIRECT_CONV2D_BACKWARD_FILTER: {
                return "conv2d_backward_filter";
            }
            case DIRECT_CONV2D_BACKWARD_DATA: {
                return "conv2d_backward_data";
            }
        }
        throw new UnsupportedOperationException(this.printErrorLocation() + "Instruction is not defined for Transform operation " + (Object)((Object)this.operation));
    }

    @Override
    public String getInstructions(String input, String bias, String output) throws LopsException {
        if (this.operation == OperationTypes.BIAS_ADD || this.operation == OperationTypes.BIAS_MULTIPLY || this.operation == OperationTypes.RELU_BACKWARD) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.getExecType());
            sb.append("\u00b0");
            sb.append(this.getOpcode());
            sb.append("\u00b0");
            sb.append(this.getInputs().get(0).prepInputOperand(input));
            sb.append("\u00b0");
            sb.append(this.getInputs().get(0).prepInputOperand(bias));
            sb.append("\u00b0");
            sb.append(this.prepOutputOperand(output));
            if (this.getExecType() == LopProperties.ExecType.CP) {
                sb.append("\u00b0");
                sb.append(this.numThreads);
            }
            return sb.toString();
        }
        throw new LopsException("The operation is not supported with two operands:" + this.operation.name());
    }

    @Override
    public String getInstructions(String[] inputs, String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        this.appendOpcode(sb);
        for (int i = 0; i < inputs.length - 12; ++i) {
            if (i > 0) {
                sb.append("\u00b0");
            }
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        this.appendOperands(inputs.length - 12, inputs.length, output, sb);
        return sb.toString();
    }

    public void appendOpcode(StringBuilder sb) {
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
    }

    public void appendOperands(int startInputIndex, int endInputIndex, String output, StringBuilder sb) {
        for (int i = startInputIndex; i < endInputIndex; ++i) {
            Lop ltmp = this.getInputs().get(i);
            sb.append("\u00b0");
            sb.append(ltmp.prepScalarInputOperand(this.getExecType()));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this.numThreads);
        }
    }

    public static enum OperationTypes {
        MAX_POOLING,
        MAX_POOLING_BACKWARD,
        RELU_MAX_POOLING,
        RELU_BACKWARD,
        DIRECT_CONV2D,
        DIRECT_CONV2D_BACKWARD_FILTER,
        DIRECT_CONV2D_BACKWARD_DATA,
        BIAS_ADD,
        DIRECT_CONV2D_BIAS_ADD,
        BIAS_MULTIPLY;

    }
}

