/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashSet;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CombineUnary
extends Lop {
    public CombineUnary(Lop input1, Expression.DataType dt, Expression.ValueType vt) {
        super(Lop.Type.CombineUnary, dt, vt);
        this.addInput(input1);
        input1.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.SORT);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "combineunary";
    }

    @Override
    public String getInstructions(int input_index1, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append("combineunary");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    public static CombineUnary constructCombineLop(Lop input1, Expression.DataType dt, Expression.ValueType vt) {
        HashSet<Lop> set1 = new HashSet<Lop>();
        set1.addAll(input1.getOutputs());
        for (Lop lop : set1) {
            if (lop.type != Lop.Type.CombineUnary) continue;
            return (CombineUnary)lop;
        }
        CombineUnary comn = new CombineUnary(input1, dt, vt);
        comn.setAllPositions(input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndLine());
        return comn;
    }
}

