/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class BinaryScalar
extends Lop {
    OperationTypes operation;

    public BinaryScalar(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt) {
        super(Lop.Type.BinaryCP, dt, vt);
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.CP, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    @Override
    public String getInstructions(String input1, String input2, String output) throws LopsException {
        String opString = BinaryScalar.getOpcode(this.operation);
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(opString);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public Lop.SimpleInstType getSimpleInstructionType() {
        switch (this.operation) {
            default: 
        }
        return Lop.SimpleInstType.Scalar;
    }

    public static String getOpcode(OperationTypes op) {
        switch (op) {
            case ADD: {
                return "+";
            }
            case SUBTRACT: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%%";
            }
            case INTDIV: {
                return "%/%";
            }
            case POW: {
                return "^";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUALS: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUALS: {
                return ">=";
            }
            case EQUALS: {
                return "==";
            }
            case NOT_EQUALS: {
                return "!=";
            }
            case AND: {
                return "&&";
            }
            case OR: {
                return "||";
            }
            case LOG: {
                return "log";
            }
            case MIN: {
                return "min";
            }
            case MAX: {
                return "max";
            }
            case PRINT: {
                return "print";
            }
            case IQSIZE: {
                return "iqsize";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for BinaryScalar operator: " + (Object)((Object)op));
    }

    public static enum OperationTypes {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MODULUS,
        INTDIV,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        EQUALS,
        NOT_EQUALS,
        AND,
        OR,
        LOG,
        POW,
        MAX,
        MIN,
        PRINT,
        IQSIZE;

    }
}

