/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class AppendG
extends Lop {
    public static final String OPCODE = "gappend";
    private boolean _cbind = true;

    public AppendG(Lop input1, Lop input2, Lop input3, Lop input4, Expression.DataType dt, Expression.ValueType vt, boolean cbind, LopProperties.ExecType et) {
        super(Lop.Type.Append, dt, vt);
        this.init(input1, input2, input3, input4, dt, vt, et);
        this._cbind = cbind;
    }

    public void init(Lop input1, Lop input2, Lop input3, Lop input4, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        this.addInput(input3);
        input3.addOutput(this);
        this.addInput(input4);
        input4.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
        } else {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return " AppendG: ";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int output_index) throws LopsException {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(input_index3), String.valueOf(input_index4), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input_index1, String input_index2, String input_index3, String input_index4, String output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input_index2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        sb.append("\u00b0");
        sb.append(this._cbind);
        return sb.toString();
    }
}

