/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.hops.rewrite.StatementBlockRewriteRule;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;

public class RewriteSplitDagUnknownCSVRead
extends StatementBlockRewriteRule {
    @Override
    public ArrayList<StatementBlock> rewriteStatementBlock(StatementBlock sb, ProgramRewriteStatus state) throws HopsException {
        ArrayList<StatementBlock> ret = new ArrayList<StatementBlock>();
        ArrayList<Hop> cand = new ArrayList<Hop>();
        this.collectCSVReadHopsUnknownSize(sb.get_hops(), cand);
        if (!cand.isEmpty()) {
            try {
                StatementBlock sb1 = new StatementBlock();
                sb1.setDMLProg(sb.getDMLProg());
                sb1.setAllPositions(sb.getFilename(), sb.getBeginLine(), sb.getBeginColumn(), sb.getEndLine(), sb.getEndColumn());
                sb1.setLiveIn(new VariableSet());
                sb1.setLiveOut(new VariableSet());
                ArrayList<Hop> sb1hops = new ArrayList<Hop>();
                Iterator<Hop> iterator = cand.iterator();
                while (iterator.hasNext()) {
                    Hop c;
                    Hop reblock = c = iterator.next();
                    long rlen = reblock.getDim1();
                    long clen = reblock.getDim2();
                    long nnz = reblock.getNnz();
                    MatrixObject.UpdateType update = c.getUpdateType();
                    long brlen = reblock.getRowsInBlock();
                    long bclen = reblock.getColsInBlock();
                    DataOp tread = new DataOp(reblock.getName(), reblock.getDataType(), reblock.getValueType(), Hop.DataOpTypes.TRANSIENTREAD, null, rlen, clen, nnz, update, brlen, bclen);
                    HopRewriteUtils.copyLineNumbers(reblock, tread);
                    ArrayList<Hop> parents = new ArrayList<Hop>(reblock.getParent());
                    for (int i = 0; i < parents.size(); ++i) {
                        Hop parent = parents.get(i);
                        HopRewriteUtils.replaceChildReference(parent, reblock, tread);
                    }
                    DataOp twrite = new DataOp(reblock.getName(), reblock.getDataType(), reblock.getValueType(), reblock, Hop.DataOpTypes.TRANSIENTWRITE, null);
                    twrite.setOutputParams(rlen, clen, nnz, update, brlen, bclen);
                    HopRewriteUtils.copyLineNumbers(reblock, twrite);
                    sb1hops.add(twrite);
                    DataIdentifier diVar = sb.variablesRead().getVariable(reblock.getName());
                    if (diVar == null) continue;
                    sb1.liveOut().addVariable(reblock.getName(), new DataIdentifier(diVar));
                    sb.liveIn().addVariable(reblock.getName(), new DataIdentifier(diVar));
                }
                sb1.set_hops(sb1hops);
                sb1.updateRecompilationFlag();
                ret.add(sb1);
                ret.add(sb);
            }
            catch (Exception ex) {
                throw new HopsException("Failed to split hops dag for csv read with unknown size.", ex);
            }
            LOG.debug((Object)"Applied splitDagUnknownCSVRead.");
        } else {
            ret.add(sb);
        }
        return ret;
    }

    private void collectCSVReadHopsUnknownSize(ArrayList<Hop> roots, ArrayList<Hop> cand) {
        if (roots == null) {
            return;
        }
        Hop.resetVisitStatus(roots);
        for (Hop root : roots) {
            this.collectCSVReadHopsUnknownSize(root, cand);
        }
    }

    private void collectCSVReadHopsUnknownSize(Hop hop, ArrayList<Hop> cand) {
        DataOp dop;
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof DataOp && (dop = (DataOp)hop).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD && dop.getInputFormatType() == Hop.FileFormatTypes.CSV && !dop.dimsKnown() && !HopRewriteUtils.hasOnlyWriteParents(dop, true, false) && !HopRewriteUtils.hasTransformParents(hop)) {
            cand.add(dop);
        }
        if (hop.getInput() != null) {
            for (Hop c : hop.getInput()) {
                this.collectCSVReadHopsUnknownSize(c, cand);
            }
        }
        hop.setVisited();
    }
}

