/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LeftIndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.UtilFunctions;

public class HopRewriteUtils {
    public static boolean isValueTypeCast(Hop.OpOp1 op) {
        return op == Hop.OpOp1.CAST_AS_BOOLEAN || op == Hop.OpOp1.CAST_AS_INT || op == Hop.OpOp1.CAST_AS_DOUBLE;
    }

    public static boolean getBooleanValue(LiteralOp op) throws HopsException {
        switch (op.getValueType()) {
            case DOUBLE: {
                return op.getDoubleValue() != 0.0;
            }
            case INT: {
                return op.getLongValue() != 0L;
            }
            case BOOLEAN: {
                return op.getBooleanValue();
            }
        }
        throw new HopsException("Invalid boolean value: " + (Object)((Object)op.getValueType()));
    }

    public static boolean getBooleanValueSafe(LiteralOp op) {
        try {
            switch (op.getValueType()) {
                case DOUBLE: {
                    return op.getDoubleValue() != 0.0;
                }
                case INT: {
                    return op.getLongValue() != 0L;
                }
                case BOOLEAN: {
                    return op.getBooleanValue();
                }
            }
            throw new HopsException("Invalid boolean value: " + (Object)((Object)op.getValueType()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static double getDoubleValue(LiteralOp op) throws HopsException {
        switch (op.getValueType()) {
            case DOUBLE: {
                return op.getDoubleValue();
            }
            case INT: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1.0 : 0.0;
            }
        }
        throw new HopsException("Invalid double value: " + (Object)((Object)op.getValueType()));
    }

    public static double getDoubleValueSafe(LiteralOp op) {
        try {
            switch (op.getValueType()) {
                case DOUBLE: {
                    return op.getDoubleValue();
                }
                case INT: {
                    return op.getLongValue();
                }
                case BOOLEAN: {
                    return op.getBooleanValue() ? 1.0 : 0.0;
                }
            }
            throw new HopsException("Invalid double value: " + (Object)((Object)op.getValueType()));
        }
        catch (Exception exception) {
            return Double.MAX_VALUE;
        }
    }

    public static long getIntValue(LiteralOp op) throws HopsException {
        switch (op.getValueType()) {
            case DOUBLE: {
                return UtilFunctions.toLong(op.getDoubleValue());
            }
            case INT: {
                return op.getLongValue();
            }
            case BOOLEAN: {
                return op.getBooleanValue() ? 1L : 0L;
            }
        }
        throw new HopsException("Invalid int value: " + (Object)((Object)op.getValueType()));
    }

    public static long getIntValueSafe(LiteralOp op) {
        try {
            switch (op.getValueType()) {
                case DOUBLE: {
                    return UtilFunctions.toLong(op.getDoubleValue());
                }
                case INT: {
                    return op.getLongValue();
                }
                case BOOLEAN: {
                    return op.getBooleanValue() ? 1L : 0L;
                }
            }
            throw new RuntimeException("Invalid int value: " + (Object)((Object)op.getValueType()));
        }
        catch (Exception exception) {
            return Long.MAX_VALUE;
        }
    }

    public static boolean isLiteralOfValue(Hop hop, double val) {
        return hop instanceof LiteralOp && (hop.getValueType() == Expression.ValueType.DOUBLE || hop.getValueType() == Expression.ValueType.INT) && HopRewriteUtils.getDoubleValueSafe((LiteralOp)hop) == val;
    }

    public static ScalarObject getScalarObject(LiteralOp op) {
        ScalarObject ret = null;
        try {
            switch (op.getValueType()) {
                case DOUBLE: {
                    ret = new DoubleObject(op.getDoubleValue());
                    break;
                }
                case INT: {
                    ret = new IntObject(op.getLongValue());
                    break;
                }
                case BOOLEAN: {
                    ret = new BooleanObject(op.getBooleanValue());
                    break;
                }
                case STRING: {
                    ret = new StringObject(op.getStringValue());
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Invalid scalar object value type: " + (Object)((Object)op.getValueType()));
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create scalar object for constant. Continue.", ex);
        }
        return ret;
    }

    public static int getChildReferencePos(Hop parent, Hop child) {
        return parent.getInput().indexOf(child);
    }

    public static void removeChildReference(Hop parent, Hop child) {
        parent.getInput().remove(child);
        child.getParent().remove(parent);
    }

    public static void removeChildReferenceByPos(Hop parent, Hop child, int posChild) {
        parent.getInput().remove(posChild);
        child.getParent().remove(parent);
    }

    public static void removeAllChildReferences(Hop parent) {
        for (Hop child : parent.getInput()) {
            child.getParent().remove(parent);
        }
        parent.getInput().clear();
    }

    public static void addChildReference(Hop parent, Hop child) {
        parent.getInput().add(child);
        child.getParent().add(parent);
    }

    public static void addChildReference(Hop parent, Hop child, int pos) {
        parent.getInput().add(pos, child);
        child.getParent().add(parent);
    }

    public static void rewireAllParentChildReferences(Hop hold, Hop hnew) {
        ArrayList<Hop> parents = new ArrayList<Hop>(hold.getParent());
        for (Hop lparent : parents) {
            HopRewriteUtils.replaceChildReference(lparent, hold, hnew);
        }
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew) {
        int pos = HopRewriteUtils.getChildReferencePos(parent, inOld);
        HopRewriteUtils.removeChildReferenceByPos(parent, inOld, pos);
        HopRewriteUtils.addChildReference(parent, inNew, pos);
        parent.refreshSizeInformation();
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew, int pos) {
        HopRewriteUtils.replaceChildReference(parent, inOld, inNew, pos, true);
    }

    public static void replaceChildReference(Hop parent, Hop inOld, Hop inNew, int pos, boolean refresh) {
        HopRewriteUtils.removeChildReferenceByPos(parent, inOld, pos);
        HopRewriteUtils.addChildReference(parent, inNew, pos);
        if (refresh) {
            parent.refreshSizeInformation();
        }
    }

    public static void cleanupUnreferenced(Hop ... inputs) {
        for (Hop input : inputs) {
            if (!input.getParent().isEmpty()) continue;
            HopRewriteUtils.removeAllChildReferences(input);
        }
    }

    public static Hop createDataGenOp(Hop input, double value) throws HopsException {
        Hop rows = input.getDim1() > 0L ? new LiteralOp(input.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, input);
        Hop cols = input.getDim2() > 0L ? new LiteralOp(input.getDim2()) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, input);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static DataGenOp copyDataGenOp(DataGenOp inputGen, double scale, double shift) throws HopsException {
        HashMap<String, Integer> params = inputGen.getParamIndexMap();
        Hop rows = inputGen.getInput().get(params.get("rows"));
        Hop cols = inputGen.getInput().get(params.get("cols"));
        Hop min = inputGen.getInput().get(params.get("min"));
        Hop max = inputGen.getInput().get(params.get("max"));
        Hop pdf = inputGen.getInput().get(params.get("pdf"));
        Hop mean = inputGen.getInput().get(params.get("lambda"));
        Hop sparsity = inputGen.getInput().get(params.get("sparsity"));
        Hop seed = inputGen.getInput().get(params.get("seed"));
        if (!(min instanceof LiteralOp) || !(max instanceof LiteralOp)) {
            return null;
        }
        double smin = HopRewriteUtils.getDoubleValue((LiteralOp)min);
        double smax = HopRewriteUtils.getDoubleValue((LiteralOp)max);
        smin = smin * scale + shift;
        smax = smax * scale + shift;
        LiteralOp sminHop = new LiteralOp(smin);
        LiteralOp smaxHop = new LiteralOp(smax);
        HashMap<String, Hop> params2 = new HashMap<String, Hop>();
        params2.put("rows", rows);
        params2.put("cols", cols);
        params2.put("min", sminHop);
        params2.put("max", smaxHop);
        params2.put("pdf", pdf);
        params2.put("lambda", mean);
        params2.put("sparsity", sparsity);
        params2.put("seed", seed);
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params2);
        datagen.setOutputBlocksizes(inputGen.getRowsInBlock(), inputGen.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(inputGen, datagen);
        if (smin == 0.0 && smax == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOp(Hop rowInput, Hop colInput, double value) throws HopsException {
        Hop rows = rowInput.getDim1() > 0L ? new LiteralOp(rowInput.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, rowInput);
        Hop cols = colInput.getDim2() > 0L ? new LiteralOp(colInput.getDim2()) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, colInput);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(rowInput.getRowsInBlock(), colInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(rowInput, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOp(Hop rowInput, boolean tRowInput, Hop colInput, boolean tColInput, double value) throws HopsException {
        Hop rows;
        long ncol;
        long nrow = tRowInput ? rowInput.getDim2() : rowInput.getDim1();
        long l = ncol = tColInput ? colInput.getDim1() : rowInput.getDim2();
        Hop hop = nrow > 0L ? new LiteralOp(nrow) : (rows = new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, tRowInput ? Hop.OpOp1.NCOL : Hop.OpOp1.NROW, rowInput));
        Hop cols = ncol > 0L ? new LiteralOp(ncol) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, tColInput ? Hop.OpOp1.NROW : Hop.OpOp1.NCOL, colInput);
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rows);
        params.put("cols", cols);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(rowInput.getRowsInBlock(), colInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(rowInput, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static Hop createDataGenOpByVal(Hop rowInput, Hop colInput, double value) throws HopsException {
        LiteralOp val = new LiteralOp(value);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        params.put("rows", rowInput);
        params.put("cols", colInput);
        params.put("min", val);
        params.put("max", val);
        params.put("pdf", new LiteralOp("uniform"));
        params.put("lambda", new LiteralOp(-1.0));
        params.put("sparsity", new LiteralOp(1.0));
        params.put("seed", new LiteralOp(-1L));
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.RAND, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(rowInput.getRowsInBlock(), colInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(rowInput, datagen);
        if (value == 0.0) {
            datagen.setNnz(0L);
        }
        return datagen;
    }

    public static ReorgOp createTranspose(Hop input) {
        return HopRewriteUtils.createReorg(input, Hop.ReOrgOp.TRANSPOSE);
    }

    public static ReorgOp createReorg(Hop input, Hop.ReOrgOp rop) {
        ReorgOp transpose = new ReorgOp(input.getName(), input.getDataType(), input.getValueType(), rop, input);
        transpose.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, transpose);
        transpose.refreshSizeInformation();
        return transpose;
    }

    public static UnaryOp createUnary(Hop input, Hop.OpOp1 type) {
        Expression.DataType dt = type == Hop.OpOp1.CAST_AS_SCALAR ? Expression.DataType.SCALAR : (type == Hop.OpOp1.CAST_AS_MATRIX ? Expression.DataType.MATRIX : input.getDataType());
        Expression.ValueType vt = type == Hop.OpOp1.CAST_AS_MATRIX ? Expression.ValueType.DOUBLE : input.getValueType();
        UnaryOp unary = new UnaryOp(input.getName(), dt, vt, type, input);
        unary.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        if (type == Hop.OpOp1.CAST_AS_SCALAR || type == Hop.OpOp1.CAST_AS_MATRIX) {
            int dim = type == Hop.OpOp1.CAST_AS_SCALAR ? 0 : 1;
            int blksz = type == Hop.OpOp1.CAST_AS_SCALAR ? 0 : ConfigurationManager.getBlocksize();
            HopRewriteUtils.setOutputParameters(unary, dim, dim, blksz, blksz, -1L);
        }
        HopRewriteUtils.copyLineNumbers(input, unary);
        unary.refreshSizeInformation();
        return unary;
    }

    public static BinaryOp createBinaryMinus(Hop input) {
        return HopRewriteUtils.createBinary(new LiteralOp(0L), input, Hop.OpOp2.MINUS);
    }

    public static BinaryOp createBinary(Hop input1, Hop input2, Hop.OpOp2 op) {
        Hop mainInput = input1.getDataType().isMatrix() ? input1 : (input2.getDataType().isMatrix() ? input2 : input1);
        BinaryOp bop = new BinaryOp(mainInput.getName(), mainInput.getDataType(), mainInput.getValueType(), op, input1, input2);
        if (bop.isPPredOperation() && bop.getDataType().isScalar()) {
            bop.setValueType(Expression.ValueType.BOOLEAN);
        }
        bop.setOutputBlocksizes(mainInput.getRowsInBlock(), mainInput.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(mainInput, bop);
        bop.refreshSizeInformation();
        return bop;
    }

    public static AggUnaryOp createSum(Hop input) {
        return HopRewriteUtils.createAggUnaryOp(input, Hop.AggOp.SUM, Hop.Direction.RowCol);
    }

    public static AggUnaryOp createAggUnaryOp(Hop input, Hop.AggOp op, Hop.Direction dir) {
        Expression.DataType dt = dir == Hop.Direction.RowCol ? Expression.DataType.SCALAR : input.getDataType();
        AggUnaryOp auop = new AggUnaryOp(input.getName(), dt, input.getValueType(), op, dir, input);
        auop.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, auop);
        auop.refreshSizeInformation();
        return auop;
    }

    public static AggBinaryOp createMatrixMultiply(Hop left, Hop right) {
        AggBinaryOp mmult = new AggBinaryOp(left.getName(), left.getDataType(), left.getValueType(), Hop.OpOp2.MULT, Hop.AggOp.SUM, left, right);
        mmult.setOutputBlocksizes(left.getRowsInBlock(), right.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(left, mmult);
        mmult.refreshSizeInformation();
        return mmult;
    }

    public static ParameterizedBuiltinOp createParameterizedBuiltinOp(Hop input, HashMap<String, Hop> args, Hop.ParamBuiltinOp op) {
        ParameterizedBuiltinOp pbop = new ParameterizedBuiltinOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, op, args);
        pbop.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, pbop);
        pbop.refreshSizeInformation();
        return pbop;
    }

    public static Hop createScalarIndexing(Hop input, long rix, long cix) {
        LiteralOp row = new LiteralOp(rix);
        LiteralOp col = new LiteralOp(cix);
        IndexingOp ix = new IndexingOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, input, row, row, col, col, true, true);
        ix.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, ix);
        ix.refreshSizeInformation();
        return HopRewriteUtils.createUnary(ix, Hop.OpOp1.CAST_AS_SCALAR);
    }

    public static Hop createValueHop(Hop hop, boolean row) throws HopsException {
        Hop ret = null;
        ret = row ? (hop.getDim1() > 0L ? new LiteralOp(hop.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, hop)) : (hop.getDim2() > 0L ? new LiteralOp(hop.getDim2()) : new UnaryOp("tmpcols", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NCOL, hop));
        return ret;
    }

    public static DataGenOp createSeqDataGenOp(Hop input) throws HopsException {
        return HopRewriteUtils.createSeqDataGenOp(input, true);
    }

    public static DataGenOp createSeqDataGenOp(Hop input, boolean asc) throws HopsException {
        Hop to = input.getDim1() > 0L ? new LiteralOp(input.getDim1()) : new UnaryOp("tmprows", Expression.DataType.SCALAR, Expression.ValueType.INT, Hop.OpOp1.NROW, input);
        HashMap<String, Hop> params = new HashMap<String, Hop>();
        if (asc) {
            params.put("from", new LiteralOp(1L));
            params.put("to", to);
            params.put("incr", new LiteralOp(1L));
        } else {
            params.put("from", to);
            params.put("to", new LiteralOp(1L));
            params.put("incr", new LiteralOp(-1L));
        }
        DataGenOp datagen = new DataGenOp(Hop.DataGenMethod.SEQ, new DataIdentifier("tmp"), params);
        datagen.setOutputBlocksizes(input.getRowsInBlock(), input.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(input, datagen);
        return datagen;
    }

    public static TernaryOp createTernaryOp(Hop mleft, Hop smid, Hop mright, Hop.OpOp3 op) {
        TernaryOp ternOp = new TernaryOp("tmp", Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, op, mleft, smid, mright);
        ternOp.setOutputBlocksizes(mleft.getRowsInBlock(), mleft.getColsInBlock());
        HopRewriteUtils.copyLineNumbers(mleft, ternOp);
        ternOp.refreshSizeInformation();
        return ternOp;
    }

    public static void setOutputParameters(Hop hop, long rlen, long clen, long brlen, long bclen, long nnz) {
        hop.setDim1(rlen);
        hop.setDim2(clen);
        hop.setOutputBlocksizes(brlen, bclen);
        hop.setNnz(nnz);
    }

    public static void setOutputParametersForScalar(Hop hop) {
        hop.setDataType(Expression.DataType.SCALAR);
        hop.setDim1(0L);
        hop.setDim2(0L);
        hop.setOutputBlocksizes(-1L, -1L);
        hop.setNnz(-1L);
    }

    public static void refreshOutputParameters(Hop hnew, Hop hold) {
        hnew.setDim1(hold.getDim1());
        hnew.setDim2(hold.getDim2());
        hnew.setOutputBlocksizes(hold.getRowsInBlock(), hold.getColsInBlock());
        hnew.refreshSizeInformation();
    }

    public static void copyLineNumbers(Hop src, Hop dest) {
        dest.setAllPositions(src.getBeginLine(), src.getBeginColumn(), src.getEndLine(), src.getEndColumn());
    }

    public static void updateHopCharacteristics(Hop hop, long brlen, long bclen, Hop src) {
        HopRewriteUtils.updateHopCharacteristics(hop, brlen, bclen, new MemoTable(), src);
    }

    public static void updateHopCharacteristics(Hop hop, long brlen, long bclen, MemoTable memo, Hop src) {
        hop.setOutputBlocksizes(brlen, bclen);
        hop.refreshSizeInformation();
        hop.computeMemEstimate(memo);
        HopRewriteUtils.copyLineNumbers(src, hop);
    }

    public static boolean isDimsKnown(Hop hop) {
        return hop.getDim1() > 0L && hop.getDim2() > 0L;
    }

    public static boolean isEmpty(Hop hop) {
        return hop.getNnz() == 0L;
    }

    public static boolean isEqualSize(Hop hop1, Hop hop2) {
        return hop1.dimsKnown() && hop2.dimsKnown() && hop1.getDim1() == hop2.getDim1() && hop1.getDim2() == hop2.getDim2();
    }

    public static boolean isEqualSize(Hop hop1, Hop ... hops) {
        boolean ret = hop1.dimsKnown();
        for (int i = 0; i < hops.length && ret; ret &= HopRewriteUtils.isEqualSize(hop1, hops[i]), ++i) {
        }
        return ret;
    }

    public static boolean isSingleBlock(Hop hop) {
        return HopRewriteUtils.isSingleBlock(hop, true) && HopRewriteUtils.isSingleBlock(hop, false);
    }

    public static boolean isSingleBlock(Hop hop, boolean cols) {
        if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SINGLE_NODE) {
            return true;
        }
        return cols ? hop.getDim2() > 0L && hop.getDim2() <= hop.getColsInBlock() : hop.getDim1() > 0L && hop.getDim1() <= hop.getRowsInBlock();
    }

    public static boolean isOuterProductLikeMM(Hop hop) {
        return HopRewriteUtils.isMatrixMultiply(hop) && hop.dimsKnown() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(1).dimsKnown() && hop.getInput().get(0).getDim1() > hop.getInput().get(0).getDim2() && hop.getInput().get(1).getDim1() < hop.getInput().get(1).getDim2();
    }

    public static boolean isSparse(Hop hop) {
        return hop.dimsKnown(true) && MatrixBlock.evalSparseFormatInMemory(hop.getDim1(), hop.getDim2(), hop.getNnz());
    }

    public static boolean isEqualValue(LiteralOp hop1, LiteralOp hop2) throws HopsException {
        double val2;
        if (hop1.getValueType() == Expression.ValueType.STRING || hop2.getValueType() == Expression.ValueType.STRING) {
            return false;
        }
        double val1 = HopRewriteUtils.getDoubleValue(hop1);
        return val1 == (val2 = HopRewriteUtils.getDoubleValue(hop2));
    }

    public static boolean isNotMatrixVectorBinaryOperation(Hop hop) {
        boolean ret = true;
        if (hop instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hop;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            boolean mv = left.getDim1() > 1L && right.getDim1() == 1L || left.getDim2() > 1L && right.getDim2() == 1L;
            ret = HopRewriteUtils.isDimsKnown(bop) && !mv;
        }
        return ret;
    }

    public static boolean isTransposeOperation(Hop hop) {
        return hop instanceof ReorgOp && ((ReorgOp)hop).getOp() == Hop.ReOrgOp.TRANSPOSE;
    }

    public static boolean isTransposeOperation(Hop hop, int maxParents) {
        return HopRewriteUtils.isTransposeOperation(hop) && hop.getParent().size() <= maxParents;
    }

    public static boolean containsTransposeOperation(ArrayList<Hop> hops) {
        boolean ret = false;
        for (Hop hop : hops) {
            ret |= HopRewriteUtils.isTransposeOperation(hop);
        }
        return ret;
    }

    public static boolean isTransposeOfItself(Hop hop1, Hop hop2) {
        return HopRewriteUtils.isTransposeOperation(hop1) && hop1.getInput().get(0) == hop2 || HopRewriteUtils.isTransposeOperation(hop2) && hop2.getInput().get(0) == hop1;
    }

    public static boolean isTsmmInput(Hop input) {
        if (input.getParent().size() == 2) {
            for (int i = 0; i < 2; ++i) {
                if (!HopRewriteUtils.isMatrixMultiply(input.getParent().get(i)) || !HopRewriteUtils.isTransposeOfItself(input.getParent().get(i).getInput().get(0), input.getParent().get(i).getInput().get(1))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(Hop hop, Hop.OpOp2 type) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == type;
    }

    public static boolean isBinary(Hop hop, Hop.OpOp2 ... types) {
        return hop instanceof BinaryOp && ArrayUtils.contains((Object[])types, (Object)((Object)((BinaryOp)hop).getOp()));
    }

    public static boolean isBinary(Hop hop, Hop.OpOp2 type, int maxParents) {
        return HopRewriteUtils.isBinary(hop, type) && hop.getParent().size() <= maxParents;
    }

    public static boolean isBinaryMatrixScalarOperation(Hop hop) {
        return hop instanceof BinaryOp && (hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isScalar() || hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).getDataType().isScalar());
    }

    public static boolean isBinaryMatrixMatrixOperation(Hop hop) {
        return hop instanceof BinaryOp && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(0).getDim1() > 1L && hop.getInput().get(0).getDim2() > 1L && hop.getInput().get(1).dimsKnown() && hop.getInput().get(1).getDim1() > 1L && hop.getInput().get(1).getDim2() > 1L;
    }

    public static boolean isBinaryMatrixColVectorOperation(Hop hop) {
        return hop instanceof BinaryOp && hop.getInput().get(0).getDataType().isMatrix() && hop.getInput().get(1).getDataType().isMatrix() && hop.getInput().get(0).dimsKnown() && hop.getInput().get(1).dimsKnown() && hop.getInput().get(1).getDim2() == 1L;
    }

    public static boolean isUnary(Hop hop, Hop.OpOp1 type) {
        return hop instanceof UnaryOp && ((UnaryOp)hop).getOp() == type;
    }

    public static boolean isUnary(Hop hop, Hop.OpOp1 type, int maxParents) {
        return HopRewriteUtils.isUnary(hop, type) && hop.getParent().size() <= maxParents;
    }

    public static boolean isUnary(Hop hop, Hop.OpOp1 ... types) {
        return hop instanceof UnaryOp && ArrayUtils.contains((Object[])types, (Object)((Object)((UnaryOp)hop).getOp()));
    }

    public static boolean isMatrixMultiply(Hop hop) {
        return hop instanceof AggBinaryOp && ((AggBinaryOp)hop).isMatrixMultiply();
    }

    public static boolean isAggUnaryOp(Hop hop, Hop.AggOp ... op) {
        if (!(hop instanceof AggUnaryOp)) {
            return false;
        }
        Hop.AggOp hopOp = ((AggUnaryOp)hop).getOp();
        for (Hop.AggOp opi : op) {
            if (hopOp != opi) continue;
            return true;
        }
        return false;
    }

    public static boolean isSum(Hop hop) {
        return hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getOp() == Hop.AggOp.SUM;
    }

    public static boolean isSumSq(Hop hop) {
        return hop instanceof AggUnaryOp && ((AggUnaryOp)hop).getOp() == Hop.AggOp.SUM_SQ;
    }

    public static boolean isNonZeroIndicator(Hop pred, Hop hop) {
        return pred instanceof BinaryOp && ((BinaryOp)pred).getOp() == Hop.OpOp2.NOTEQUAL && pred.getInput().get(0) == hop && pred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred.getInput().get(1)) == 0.0;
    }

    public static boolean checkInputDataTypes(Hop hop, Expression.DataType ... dt) {
        for (int i = 0; i < hop.getInput().size(); ++i) {
            if (hop.getInput().get(i).getDataType() == dt[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isFullColumnIndexing(LeftIndexingOp hop) {
        boolean colPred = hop.getColLowerEqualsUpper();
        Hop rl = hop.getInput().get(2);
        Hop ru = hop.getInput().get(3);
        return colPred && rl instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)rl) == 1.0 && ru instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)ru) == (double)hop.getDim1();
    }

    public static boolean isFullRowIndexing(LeftIndexingOp hop) {
        boolean rowPred = hop.getRowLowerEqualsUpper();
        Hop cl = hop.getInput().get(4);
        Hop cu = hop.getInput().get(5);
        return rowPred && cl instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)cl) == 1.0 && cu instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)cu) == (double)hop.getDim2();
    }

    public static boolean isScalarMatrixBinaryMult(Hop hop) {
        return hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == Hop.OpOp2.MULT && (hop.getInput().get(0).getDataType() == Expression.DataType.SCALAR && hop.getInput().get(1).getDataType() == Expression.DataType.MATRIX || hop.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hop.getInput().get(1).getDataType() == Expression.DataType.SCALAR);
    }

    public static boolean isBasic1NSequence(Hop hop) {
        if (hop instanceof DataGenOp && ((DataGenOp)hop).getOp() == Hop.DataGenMethod.SEQ) {
            DataGenOp dgop = (DataGenOp)hop;
            Hop from = dgop.getInput().get(dgop.getParamIndex("from"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            return from instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)from) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == 1.0;
        }
        return false;
    }

    public static boolean isBasic1NSequence(Hop seq, Hop input, boolean row) {
        if (seq instanceof DataGenOp && ((DataGenOp)seq).getOp() == Hop.DataGenMethod.SEQ) {
            DataGenOp dgop = (DataGenOp)seq;
            Hop from = dgop.getInput().get(dgop.getParamIndex("from"));
            Hop to = dgop.getInput().get(dgop.getParamIndex("to"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            return HopRewriteUtils.isLiteralOfValue(from, 1.0) && HopRewriteUtils.isLiteralOfValue(incr, 1.0) && (HopRewriteUtils.isLiteralOfValue(to, row ? (double)input.getDim1() : (double)input.getDim2()) || to instanceof UnaryOp && ((UnaryOp)to).getOp() == (row ? Hop.OpOp1.NROW : Hop.OpOp1.NCOL) && to.getInput().get(0) == input);
        }
        return false;
    }

    public static boolean isBasicN1Sequence(Hop hop) {
        DataGenOp dgop;
        boolean ret = false;
        if (hop instanceof DataGenOp && (dgop = (DataGenOp)hop).getOp() == Hop.DataGenMethod.SEQ) {
            Hop to = dgop.getInput().get(dgop.getParamIndex("to"));
            Hop incr = dgop.getInput().get(dgop.getParamIndex("incr"));
            ret = to instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)to) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == -1.0;
        }
        return ret;
    }

    public static LiteralOp getBasic1NSequenceMaxLiteral(Hop hop) throws HopsException {
        Hop to;
        DataGenOp dgop;
        if (hop instanceof DataGenOp && (dgop = (DataGenOp)hop).getOp() == Hop.DataGenMethod.SEQ && (to = dgop.getInput().get(dgop.getParamIndex("to"))) instanceof LiteralOp) {
            return (LiteralOp)to;
        }
        throw new HopsException("Failed to retrieve 'to' argument from basic 1-N sequence.");
    }

    public static boolean hasOnlyWriteParents(Hop hop, boolean inclTransient, boolean inclPersistent) {
        boolean ret = true;
        ArrayList<Hop> parents = hop.getParent();
        for (Hop p : parents) {
            if (inclTransient && inclPersistent) {
                ret &= p instanceof DataOp && (((DataOp)p).getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE || ((DataOp)p).getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE);
                continue;
            }
            if (inclTransient) {
                ret &= p instanceof DataOp && ((DataOp)p).getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE;
                continue;
            }
            if (!inclPersistent) continue;
            ret &= p instanceof DataOp && ((DataOp)p).getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE;
        }
        return ret;
    }

    public static boolean hasTransformParents(Hop hop) {
        boolean ret = false;
        ArrayList<Hop> parents = hop.getParent();
        for (Hop p : parents) {
            if (!(p instanceof ParameterizedBuiltinOp) || ((ParameterizedBuiltinOp)p).getOp() != Hop.ParamBuiltinOp.TRANSFORM) continue;
            ret = true;
        }
        return ret;
    }

    public static boolean alwaysRequiresReblock(Hop hop) {
        return hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD && ((DataOp)hop).getInputFormatType() != Hop.FileFormatTypes.BINARY;
    }

    public static boolean rHasSimpleReadChain(Hop root, String var) {
        if (root.isVisited()) {
            return false;
        }
        boolean ret = false;
        if (root instanceof DataOp && ((DataOp)root).isRead() && root.getName().equals(var)) {
            ret = root.getParent().size() <= 1;
        }
        for (Hop c : root.getInput()) {
            if (!HopRewriteUtils.rHasSimpleReadChain(c, var)) continue;
            ret |= root.getParent().size() <= 1;
        }
        root.setVisited();
        return ret;
    }

    public static boolean rContainsRead(Hop root, String var, boolean includeMetaOp) {
        if (root.isVisited()) {
            return false;
        }
        boolean ret = false;
        if (root instanceof DataOp && ((DataOp)root).isRead() && root.getName().equals(var)) {
            boolean onlyMetaOp = true;
            if (!includeMetaOp) {
                for (Hop p : root.getParent()) {
                    onlyMetaOp &= p instanceof UnaryOp && (((UnaryOp)p).getOp() == Hop.OpOp1.NROW || ((UnaryOp)p).getOp() == Hop.OpOp1.NCOL);
                }
                ret = !onlyMetaOp;
            } else {
                ret = true;
            }
        }
        for (Hop c : root.getInput()) {
            ret |= HopRewriteUtils.rContainsRead(c, var, includeMetaOp);
        }
        root.setVisited();
        return ret;
    }

    public static boolean isValidOp(Hop.AggOp input, Hop.AggOp[] validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static boolean isValidOp(Hop.OpOp1 input, Hop.OpOp1[] validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static boolean isValidOp(Hop.OpOp2 input, Hop.OpOp2[] validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static boolean isValidOp(Hop.ReOrgOp input, Hop.ReOrgOp[] validTab) {
        return ArrayUtils.contains((Object[])validTab, (Object)((Object)input));
    }

    public static int getValidOpPos(Hop.OpOp2 input, Hop.OpOp2[] validTab) {
        return ArrayUtils.indexOf((Object[])validTab, (Object)((Object)input));
    }

    public static int compareSize(Hop hop1, Hop hop2) {
        long size1 = hop1.getDim1() * hop1.getDim2();
        long size2 = hop2.getDim1() * hop2.getDim2();
        return Long.compare(size1, size2);
    }
}

