/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.ipa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.FunctionOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DMLTranslator;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.udf.lib.DeNaNWrapper;
import org.apache.sysml.udf.lib.DeNegInfinityWrapper;
import org.apache.sysml.udf.lib.DynamicReadMatrixCP;
import org.apache.sysml.udf.lib.DynamicReadMatrixRcCP;
import org.apache.sysml.udf.lib.OrderWrapper;

public class InterProceduralAnalysis {
    private static final boolean LDEBUG = false;
    private static final Log LOG = LogFactory.getLog((String)InterProceduralAnalysis.class.getName());
    private static final boolean INTRA_PROCEDURAL_ANALYSIS = true;
    private static final boolean PROPAGATE_KNOWN_UDF_STATISTICS = true;
    private static final boolean ALLOW_MULTIPLE_FUNCTION_CALLS = true;
    private static final boolean REMOVE_UNUSED_FUNCTIONS = true;
    private static final boolean FLAG_FUNCTION_RECOMPILE_ONCE = true;
    private static final boolean REMOVE_UNNECESSARY_CHECKPOINTS = true;
    private static final boolean REMOVE_CONSTANT_BINARY_OPS = true;
    private static final boolean PROPAGATE_SCALAR_VARS_INTO_FUN = true;
    public static boolean UNARY_DIMS_PRESERVING_FUNS = true;

    public void analyzeProgram(DMLProgram dmlp) throws HopsException, ParseException, LanguageException {
        FunctionCallGraph fgraph = new FunctionCallGraph(dmlp);
        HashMap<String, Integer> fcandCounts = new HashMap<String, Integer>();
        HashMap<String, FunctionOp> fcandHops = new HashMap<String, FunctionOp>();
        HashMap<String, Set<Long>> fcandSafeNNZ = new HashMap<String, Set<Long>>();
        if (!dmlp.getFunctionStatementBlocks().isEmpty()) {
            for (StatementBlock sb : dmlp.getStatementBlocks()) {
                this.getFunctionCandidatesForStatisticPropagation(sb, fcandCounts, fcandHops);
            }
            this.pruneFunctionCandidatesForStatisticPropagation(fcandCounts, fcandHops);
            this.determineFunctionCandidatesNNZPropagation(fcandHops, fcandSafeNNZ);
            DMLTranslator.resetHopsDAGVisitStatus(dmlp);
        }
        Collection<String> unaryFcandTmp = fgraph.getReachableFunctions(fcandCounts.keySet());
        HashSet<String> unaryFcands = new HashSet<String>();
        if (!unaryFcandTmp.isEmpty() && UNARY_DIMS_PRESERVING_FUNS) {
            for (String tmp : unaryFcandTmp) {
                if (!this.isUnarySizePreservingFunction(dmlp.getFunctionStatementBlock(tmp))) continue;
                unaryFcands.add(tmp);
            }
        }
        if (fcandCounts.isEmpty()) {
            // empty if block
        }
        LocalVariableMap callVars = new LocalVariableMap();
        for (StatementBlock sb : dmlp.getStatementBlocks()) {
            this.propagateStatisticsAcrossBlock(sb, fcandCounts, callVars, fcandSafeNNZ, unaryFcands, new HashSet<String>());
        }
        this.removeUnusedFunctions(dmlp, fgraph);
        this.flagFunctionsForRecompileOnce(dmlp, fgraph);
        if (OptimizerUtils.isSparkExecutionMode()) {
            this.removeCheckpointBeforeUpdate(dmlp);
            this.moveCheckpointAfterUpdate(dmlp);
            this.removeCheckpointReadWrite(dmlp);
        }
        this.removeConstantBinaryOps(dmlp);
    }

    public Set<String> analyzeSubProgram(StatementBlock sb) throws HopsException, ParseException {
        DMLTranslator.resetHopsDAGVisitStatus(sb);
        HashMap<String, Integer> fcandCounts = new HashMap<String, Integer>();
        HashMap<String, FunctionOp> fcandHops = new HashMap<String, FunctionOp>();
        HashMap<String, Set<Long>> fcandSafeNNZ = new HashMap<String, Set<Long>>();
        HashSet allFCandKeys = new HashSet();
        this.getFunctionCandidatesForStatisticPropagation(sb, fcandCounts, fcandHops);
        allFCandKeys.addAll(fcandCounts.keySet());
        this.pruneFunctionCandidatesForStatisticPropagation(fcandCounts, fcandHops);
        this.determineFunctionCandidatesNNZPropagation(fcandHops, fcandSafeNNZ);
        DMLTranslator.resetHopsDAGVisitStatus(sb);
        if (!fcandCounts.isEmpty()) {
            LocalVariableMap callVars = new LocalVariableMap();
            this.propagateStatisticsAcrossBlock(sb, fcandCounts, callVars, fcandSafeNNZ, new HashSet<String>(), new HashSet<String>());
        }
        return fcandCounts.keySet();
    }

    private void getFunctionCandidatesForStatisticPropagation(StatementBlock sb, Map<String, Integer> fcandCounts, Map<String, FunctionOp> fcandHops) throws HopsException, ParseException {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (!(sb instanceof FunctionStatementBlock)) break block6;
                            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
                            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                            for (StatementBlock sbi : fstmt.getBody()) {
                                this.getFunctionCandidatesForStatisticPropagation(sbi, fcandCounts, fcandHops);
                            }
                            break block7;
                        }
                        if (!(sb instanceof WhileStatementBlock)) break block8;
                        WhileStatementBlock wsb = (WhileStatementBlock)sb;
                        WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
                        for (StatementBlock sbi : wstmt.getBody()) {
                            this.getFunctionCandidatesForStatisticPropagation(sbi, fcandCounts, fcandHops);
                        }
                        break block7;
                    }
                    if (!(sb instanceof IfStatementBlock)) break block9;
                    IfStatementBlock isb = (IfStatementBlock)sb;
                    IfStatement istmt = (IfStatement)isb.getStatement(0);
                    for (StatementBlock sbi : istmt.getIfBody()) {
                        this.getFunctionCandidatesForStatisticPropagation(sbi, fcandCounts, fcandHops);
                    }
                    for (StatementBlock sbi : istmt.getElseBody()) {
                        this.getFunctionCandidatesForStatisticPropagation(sbi, fcandCounts, fcandHops);
                    }
                    break block7;
                }
                if (!(sb instanceof ForStatementBlock)) break block10;
                ForStatementBlock fsb = (ForStatementBlock)sb;
                ForStatement fstmt = (ForStatement)fsb.getStatement(0);
                for (StatementBlock sbi : fstmt.getBody()) {
                    this.getFunctionCandidatesForStatisticPropagation(sbi, fcandCounts, fcandHops);
                }
                break block7;
            }
            ArrayList<Hop> roots = sb.get_hops();
            if (roots == null) break block7;
            for (Hop root : roots) {
                this.getFunctionCandidatesForStatisticPropagation(sb.getDMLProg(), root, fcandCounts, fcandHops);
            }
        }
    }

    private void getFunctionCandidatesForStatisticPropagation(DMLProgram prog, Hop hop, Map<String, Integer> fcandCounts, Map<String, FunctionOp> fcandHops) throws HopsException, ParseException {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof FunctionOp && !((FunctionOp)hop).getFunctionNamespace().equals(DMLProgram.INTERNAL_NAMESPACE)) {
            FunctionOp fop = (FunctionOp)hop;
            String fkey = DMLProgram.constructFunctionKey(fop.getFunctionNamespace(), fop.getFunctionName());
            if (fcandCounts.containsKey(fkey)) {
                boolean consistent = true;
                FunctionOp efop = fcandHops.get(fkey);
                int numInputs = efop.getInput().size();
                for (int i = 0; i < numInputs; ++i) {
                    Hop h1 = efop.getInput().get(i);
                    Hop h2 = fop.getInput().get(i);
                    consistent &= h1.dimsKnown() && h2.dimsKnown() && h1.getDim1() == h2.getDim1() && h1.getDim2() == h2.getDim2() && h1.getNnz() == h2.getNnz();
                    if (!(h1 instanceof LiteralOp)) continue;
                    consistent &= h2 instanceof LiteralOp && HopRewriteUtils.isEqualValue((LiteralOp)h1, (LiteralOp)h2);
                }
                if (!consistent) {
                    fcandCounts.put(fkey, fcandCounts.get(fkey) + 1);
                }
            } else {
                fcandCounts.put(fkey, 1);
                fcandHops.put(fkey, fop);
                FunctionStatementBlock fsb = prog.getFunctionStatementBlock(fop.getFunctionNamespace(), fop.getFunctionName());
                this.getFunctionCandidatesForStatisticPropagation(fsb, fcandCounts, fcandHops);
            }
        }
        for (Hop c : hop.getInput()) {
            this.getFunctionCandidatesForStatisticPropagation(prog, c, fcandCounts, fcandHops);
        }
        hop.setVisited();
    }

    private void pruneFunctionCandidatesForStatisticPropagation(Map<String, Integer> fcandCounts, Map<String, FunctionOp> fcandHops) {
        if (LOG.isDebugEnabled()) {
            for (Map.Entry<String, Integer> e : fcandCounts.entrySet()) {
                String key = e.getKey();
                Integer count = e.getValue();
                LOG.debug((Object)("IPA: FUNC statistic propagation candidate: " + key + ", callCount=" + count));
            }
        }
        HashSet<String> tmp = new HashSet<String>(fcandCounts.keySet());
        for (String key : tmp) {
            Integer cnt = fcandCounts.get(key);
            if (cnt == null || cnt <= 1) continue;
            fcandCounts.remove(key);
        }
        if (LOG.isDebugEnabled()) {
            for (String key : fcandCounts.keySet()) {
                LOG.debug((Object)("IPA: FUNC statistic propagation candidate (after pruning): " + key));
            }
        }
    }

    private boolean isUnarySizePreservingFunction(FunctionStatementBlock fsb) throws HopsException, ParseException {
        boolean ret;
        FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
        boolean bl = ret = fstmt.getInputParams().size() == 1 && fstmt.getInputParams().get(0).getDataType() == Expression.DataType.MATRIX && fstmt.getOutputParams().size() == 1 && fstmt.getOutputParams().get(0).getDataType() == Expression.DataType.MATRIX;
        if (ret) {
            HashMap<String, Integer> tmp1 = new HashMap<String, Integer>();
            HashMap<String, Set<Long>> tmp2 = new HashMap<String, Set<Long>>();
            HashSet<String> tmp3 = new HashSet<String>();
            HashSet<String> tmp4 = new HashSet<String>();
            LocalVariableMap callVars = new LocalVariableMap();
            MatrixObject mo = this.createOutputMatrix(7777L, 3333L, -1L);
            callVars.put(fstmt.getInputParams().get(0).getName(), mo);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, tmp1, callVars, tmp2, tmp3, tmp4);
            }
            MatrixObject mo2 = (MatrixObject)callVars.get(fstmt.getOutputParams().get(0).getName());
            ret &= mo.getNumRows() == mo2.getNumRows() && mo.getNumColumns() == mo2.getNumColumns();
            mo.getMatrixCharacteristics().setDimension(-1L, -1L);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, tmp1, callVars, tmp2, tmp3, tmp4);
            }
        }
        return ret;
    }

    private void determineFunctionCandidatesNNZPropagation(Map<String, FunctionOp> fcandHops, Map<String, Set<Long>> fcandSafeNNZ) {
        for (Map.Entry<String, FunctionOp> e : fcandHops.entrySet()) {
            String fKey = e.getKey();
            FunctionOp fop = e.getValue();
            HashSet<Long> tmp = new HashSet<Long>();
            for (Hop input : fop.getInput()) {
                if (input.getNnz() < 0L) continue;
                tmp.add(input.getHopID());
            }
            fcandSafeNNZ.put(fKey, tmp);
        }
    }

    private void propagateStatisticsAcrossBlock(StatementBlock sb, Map<String, Integer> fcand, LocalVariableMap callVars, Map<String, Set<Long>> fcandSafeNNZ, Set<String> unaryFcands, Set<String> fnStack) throws HopsException, ParseException {
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
            }
        } else if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)sb;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            this.propagateStatisticsAcrossPredicateDAG(wsb.getPredicateHops(), callVars);
            Recompiler.removeUpdatedScalars(callVars, wsb);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : wstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldCallVars, callVars, (StatementBlock)wsb)) {
                this.propagateStatisticsAcrossPredicateDAG(wsb.getPredicateHops(), callVars);
                for (StatementBlock sbi : wstmt.getBody()) {
                    this.propagateStatisticsAcrossBlock(sbi, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
                }
            }
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            this.propagateStatisticsAcrossPredicateDAG(isb.getPredicateHops(), callVars);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            LocalVariableMap callVarsElse = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : istmt.getIfBody()) {
                this.propagateStatisticsAcrossBlock(sbi, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
            }
            for (StatementBlock sbi : istmt.getElseBody()) {
                this.propagateStatisticsAcrossBlock(sbi, fcand, callVarsElse, fcandSafeNNZ, unaryFcands, fnStack);
            }
            callVars = Recompiler.reconcileUpdatedCallVarsIf(oldCallVars, callVars, callVarsElse, (StatementBlock)isb);
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            this.propagateStatisticsAcrossPredicateDAG(fsb.getFromHops(), callVars);
            this.propagateStatisticsAcrossPredicateDAG(fsb.getToHops(), callVars);
            this.propagateStatisticsAcrossPredicateDAG(fsb.getIncrementHops(), callVars);
            Recompiler.removeUpdatedScalars(callVars, fsb);
            LocalVariableMap oldCallVars = (LocalVariableMap)callVars.clone();
            for (StatementBlock sbi : fstmt.getBody()) {
                this.propagateStatisticsAcrossBlock(sbi, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
            }
            if (Recompiler.reconcileUpdatedCallVarsLoops(oldCallVars, callVars, (StatementBlock)fsb)) {
                for (StatementBlock sbi : fstmt.getBody()) {
                    this.propagateStatisticsAcrossBlock(sbi, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
                }
            }
            Recompiler.removeUpdatedScalars(callVars, sb);
        } else {
            Recompiler.removeUpdatedScalars(callVars, sb);
            ArrayList<Hop> roots = sb.get_hops();
            DMLProgram prog = sb.getDMLProg();
            Hop.resetVisitStatus(roots);
            this.propagateStatisticsAcrossDAG(roots, callVars);
            Hop.resetVisitStatus(roots);
            this.propagateStatisticsIntoFunctions(prog, roots, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
        }
    }

    private void propagateStatisticsAcrossPredicateDAG(Hop root, LocalVariableMap vars) throws HopsException {
        if (root == null) {
            return;
        }
        root.resetVisitStatus();
        try {
            Recompiler.rUpdateStatistics(root, vars);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to update Hop DAG statistics.", ex);
        }
    }

    private void propagateStatisticsAcrossDAG(ArrayList<Hop> roots, LocalVariableMap vars) throws HopsException {
        if (roots == null) {
            return;
        }
        try {
            for (Hop hop : roots) {
                Recompiler.rUpdateStatistics(hop, vars);
            }
            Recompiler.extractDAGOutputStatistics(roots, vars, true);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to update Hop DAG statistics.", ex);
        }
    }

    private void propagateStatisticsIntoFunctions(DMLProgram prog, ArrayList<Hop> roots, Map<String, Integer> fcand, LocalVariableMap callVars, Map<String, Set<Long>> fcandSafeNNZ, Set<String> unaryFcands, Set<String> fnStack) throws HopsException, ParseException {
        for (Hop root : roots) {
            this.propagateStatisticsIntoFunctions(prog, root, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
        }
    }

    private void propagateStatisticsIntoFunctions(DMLProgram prog, Hop hop, Map<String, Integer> fcand, LocalVariableMap callVars, Map<String, Set<Long>> fcandSafeNNZ, Set<String> unaryFcands, Set<String> fnStack) throws HopsException, ParseException {
        if (hop.isVisited()) {
            return;
        }
        for (Hop c : hop.getInput()) {
            this.propagateStatisticsIntoFunctions(prog, c, fcand, callVars, fcandSafeNNZ, unaryFcands, fnStack);
        }
        if (hop instanceof FunctionOp) {
            FunctionOp fop = (FunctionOp)hop;
            String fkey = DMLProgram.constructFunctionKey(fop.getFunctionNamespace(), fop.getFunctionName());
            if (fop.getFunctionType() == FunctionOp.FunctionType.DML) {
                FunctionStatementBlock fsb = prog.getFunctionStatementBlock(fop.getFunctionNamespace(), fop.getFunctionName());
                FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
                if (fcand.containsKey(fkey) && !fnStack.contains(fkey)) {
                    fnStack.add(fkey);
                    LocalVariableMap tmpVars = new LocalVariableMap();
                    this.populateLocalVariableMapForFunctionCall(fstmt, fop, callVars, tmpVars, fcandSafeNNZ.get(fkey), fcand.get(fkey));
                    this.propagateStatisticsAcrossBlock(fsb, fcand, tmpVars, fcandSafeNNZ, unaryFcands, fnStack);
                    this.extractFunctionCallReturnStatistics(fstmt, fop, tmpVars, callVars, true);
                    fnStack.remove(fkey);
                } else if (unaryFcands.contains(fkey)) {
                    this.extractFunctionCallEquivalentReturnStatistics(fstmt, fop, callVars);
                } else {
                    this.extractFunctionCallUnknownReturnStatistics(fstmt, fop, callVars);
                }
            } else if (fop.getFunctionType() == FunctionOp.FunctionType.EXTERNAL_FILE || fop.getFunctionType() == FunctionOp.FunctionType.EXTERNAL_MEM) {
                FunctionStatementBlock fsb = prog.getFunctionStatementBlock(fop.getFunctionNamespace(), fop.getFunctionName());
                ExternalFunctionStatement fstmt = (ExternalFunctionStatement)fsb.getStatement(0);
                this.extractExternalFunctionCallReturnStatistics(fstmt, fop, callVars);
            }
        }
        hop.setVisited();
    }

    private void populateLocalVariableMapForFunctionCall(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callvars, LocalVariableMap vars, Set<Long> inputSafeNNZ, Integer numCalls) throws HopsException {
        ArrayList<DataIdentifier> inputVars = fstmt.getInputParams();
        ArrayList<Hop> inputOps = fop.getInput();
        for (int i = 0; i < inputVars.size(); ++i) {
            Data scalar;
            DataIdentifier dat = inputVars.get(i);
            Hop input = inputOps.get(i);
            if (input.getDataType() == Expression.DataType.MATRIX) {
                MatrixObject mo = new MatrixObject(Expression.ValueType.DOUBLE, null);
                MatrixCharacteristics mc = new MatrixCharacteristics(input.getDim1(), input.getDim2(), ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), inputSafeNNZ.contains(input.getHopID()) ? input.getNnz() : -1L);
                MatrixFormatMetaData meta = new MatrixFormatMetaData(mc, null, null);
                mo.setMetaData(meta);
                vars.put(dat.getName(), mo);
                continue;
            }
            if (input.getDataType() != Expression.DataType.SCALAR) continue;
            if (input instanceof LiteralOp) {
                LiteralOp lit = (LiteralOp)input;
                ScalarObject scalar2 = null;
                switch (input.getValueType()) {
                    case DOUBLE: {
                        scalar2 = new DoubleObject(lit.getDoubleValue());
                        break;
                    }
                    case INT: {
                        scalar2 = new IntObject(lit.getLongValue());
                        break;
                    }
                    case BOOLEAN: {
                        scalar2 = new BooleanObject(lit.getBooleanValue());
                        break;
                    }
                    case STRING: {
                        scalar2 = new StringObject(lit.getStringValue());
                        break;
                    }
                }
                vars.put(dat.getName(), scalar2);
                continue;
            }
            if (numCalls == null || numCalls != 1 || !(input instanceof DataOp) || (scalar = callvars.get(input.getName())) == null || !(scalar instanceof ScalarObject)) continue;
            vars.put(dat.getName(), scalar);
        }
    }

    private void extractFunctionCallReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap tmpVars, LocalVariableMap callVars, boolean overwrite) throws HopsException {
        ArrayList<DataIdentifier> foutputOps = fstmt.getOutputParams();
        String[] outputVars = fop.getOutputVariableNames();
        String fkey = DMLProgram.constructFunctionKey(fop.getFunctionNamespace(), fop.getFunctionName());
        try {
            for (int i = 0; i < foutputOps.size(); ++i) {
                MatrixObject moOut;
                MatrixCharacteristics mc;
                DataIdentifier di = foutputOps.get(i);
                String fvarname = di.getName();
                String pvarname = outputVars[i];
                if (di.getDataType() != Expression.DataType.MATRIX || !tmpVars.keySet().contains(fvarname)) continue;
                MatrixObject moIn = (MatrixObject)tmpVars.get(fvarname);
                if (!callVars.keySet().contains(pvarname) || overwrite) {
                    MatrixObject moOut2 = this.createOutputMatrix(moIn.getNumRows(), moIn.getNumColumns(), moIn.getNnz());
                    callVars.put(pvarname, moOut2);
                    continue;
                }
                Data dat = callVars.get(pvarname);
                if (!(dat instanceof MatrixObject) || OptimizerUtils.estimateSizeExactSparsity((mc = (moOut = (MatrixObject)dat).getMatrixCharacteristics()).getRows(), mc.getCols(), mc.getNonZeros() > 0L ? (double)mc.getNonZeros() / (double)mc.getRows() / (double)mc.getCols() : 1.0) >= OptimizerUtils.estimateSize(moIn.getNumRows(), moIn.getNumColumns())) continue;
                mc.setDimension(moIn.getNumRows(), moIn.getNumColumns());
                mc.setNonZeros(moIn.getNnz());
            }
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics of function " + fkey + ".", ex);
        }
    }

    private void extractFunctionCallUnknownReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) throws HopsException {
        ArrayList<DataIdentifier> foutputOps = fstmt.getOutputParams();
        String[] outputVars = fop.getOutputVariableNames();
        String fkey = DMLProgram.constructFunctionKey(fop.getFunctionNamespace(), fop.getFunctionName());
        try {
            for (int i = 0; i < foutputOps.size(); ++i) {
                DataIdentifier di = foutputOps.get(i);
                String pvarname = outputVars[i];
                if (di.getDataType() != Expression.DataType.MATRIX) continue;
                MatrixObject moOut = this.createOutputMatrix(-1L, -1L, -1L);
                callVars.put(pvarname, moOut);
            }
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics of function " + fkey + ".", ex);
        }
    }

    private void extractFunctionCallEquivalentReturnStatistics(FunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) throws HopsException {
        String fkey = DMLProgram.constructFunctionKey(fop.getFunctionNamespace(), fop.getFunctionName());
        try {
            Hop input = fop.getInput().get(0);
            MatrixObject moOut = this.createOutputMatrix(input.getDim1(), input.getDim2(), -1L);
            callVars.put(fop.getOutputVariableNames()[0], moOut);
        }
        catch (Exception ex) {
            throw new HopsException("Failed to extract output statistics for unary function " + fkey + ".", ex);
        }
    }

    private void extractExternalFunctionCallReturnStatistics(ExternalFunctionStatement fstmt, FunctionOp fop, LocalVariableMap callVars) throws HopsException {
        String className = fstmt.getOtherParams().get("classname");
        if (className.equals(OrderWrapper.class.getName()) || className.equals(DeNaNWrapper.class.getCanonicalName()) || className.equals(DeNegInfinityWrapper.class.getCanonicalName())) {
            Hop input = fop.getInput().get(0);
            long lnnz = className.equals(OrderWrapper.class.getName()) ? input.getNnz() : -1L;
            MatrixObject moOut = this.createOutputMatrix(input.getDim1(), input.getDim2(), lnnz);
            callVars.put(fop.getOutputVariableNames()[0], moOut);
        } else if (className.equals("org.apache.sysml.udf.lib.EigenWrapper")) {
            Hop input = fop.getInput().get(0);
            callVars.put(fop.getOutputVariableNames()[0], this.createOutputMatrix(input.getDim1(), 1L, -1L));
            callVars.put(fop.getOutputVariableNames()[1], this.createOutputMatrix(input.getDim1(), input.getDim1(), -1L));
        } else if (className.equals("org.apache.sysml.udf.lib.LinearSolverWrapperCP")) {
            Hop input = fop.getInput().get(1);
            callVars.put(fop.getOutputVariableNames()[0], this.createOutputMatrix(input.getDim1(), 1L, -1L));
        } else if (className.equals(DynamicReadMatrixCP.class.getName()) || className.equals(DynamicReadMatrixRcCP.class.getName())) {
            Hop input1 = fop.getInput().get(1);
            Hop input2 = fop.getInput().get(2);
            if (input1 instanceof LiteralOp && input2 instanceof LiteralOp) {
                callVars.put(fop.getOutputVariableNames()[0], this.createOutputMatrix(((LiteralOp)input1).getLongValue(), ((LiteralOp)input2).getLongValue(), -1L));
            }
        } else {
            this.extractFunctionCallUnknownReturnStatistics(fstmt, fop, callVars);
        }
    }

    private MatrixObject createOutputMatrix(long dim1, long dim2, long nnz) {
        MatrixObject moOut = new MatrixObject(Expression.ValueType.DOUBLE, null);
        MatrixCharacteristics mc = new MatrixCharacteristics(dim1, dim2, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), nnz);
        MatrixFormatMetaData meta = new MatrixFormatMetaData(mc, null, null);
        moOut.setMetaData(meta);
        return moOut;
    }

    public void removeUnusedFunctions(DMLProgram dmlp, FunctionCallGraph fgraph) throws LanguageException {
        Set<String> fnamespaces = dmlp.getNamespaces().keySet();
        for (String fnspace : fnamespaces) {
            HashMap<String, FunctionStatementBlock> fsbs = dmlp.getFunctionStatementBlocks(fnspace);
            Iterator<Map.Entry<String, FunctionStatementBlock>> iter = fsbs.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, FunctionStatementBlock> e = iter.next();
                if (fgraph.isReachableFunction(fnspace, e.getKey())) continue;
                iter.remove();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("IPA: Removed unused function: " + DMLProgram.constructFunctionKey(fnspace, e.getKey())));
            }
        }
    }

    public void flagFunctionsForRecompileOnce(DMLProgram dmlp, FunctionCallGraph fgraph) throws LanguageException {
        for (String namespaceKey : dmlp.getNamespaces().keySet()) {
            for (String fname : dmlp.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlp.getFunctionStatementBlock(namespaceKey, fname);
                if (fgraph.isRecursiveFunction(namespaceKey, fname) || !this.rFlagFunctionForRecompileOnce(fsblock, false)) continue;
                fsblock.setRecompileOnce(true);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("IPA: FUNC flagged for recompile-once: " + DMLProgram.constructFunctionKey(namespaceKey, fname)));
            }
        }
    }

    public boolean rFlagFunctionForRecompileOnce(StatementBlock sb, boolean inLoop) {
        boolean ret = false;
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock c : fstmt.getBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else if (sb instanceof WhileStatementBlock) {
            ret = true;
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            ret |= inLoop && isb.requiresPredicateRecompilation();
            for (StatementBlock c : istmt.getIfBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
            for (StatementBlock c : istmt.getElseBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else {
            ret = sb instanceof ForStatementBlock ? true : (ret |= inLoop && sb.requiresRecompilation());
        }
        return ret;
    }

    private void removeCheckpointBeforeUpdate(DMLProgram dmlp) throws HopsException {
        HashMap<String, Hop> chkpointCand = new HashMap<String, Hop>();
        for (StatementBlock sb : dmlp.getStatementBlocks()) {
            Iterator cand2;
            HashSet cands = new HashSet(chkpointCand.keySet());
            for (Iterator cand2 : cands) {
                if (!sb.variablesRead().containsVariable((String)((Object)cand2)) || sb.variablesUpdated().containsVariable((String)((Object)cand2))) continue;
                boolean skipRemove = false;
                if (sb.get_hops() != null) {
                    Hop.resetVisitStatus(sb.get_hops());
                    skipRemove = true;
                    for (Hop root : sb.get_hops()) {
                        skipRemove &= !HopRewriteUtils.rContainsRead(root, cand2, false);
                    }
                }
                if (skipRemove) continue;
                chkpointCand.remove(cand2);
            }
            HashSet cands2 = new HashSet(chkpointCand.keySet());
            if (sb instanceof IfStatementBlock || sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) {
                cand2 = cands2.iterator();
                while (cand2.hasNext()) {
                    String cand3 = (String)cand2.next();
                    if (!sb.variablesUpdated().containsVariable(cand3)) continue;
                    chkpointCand.remove(cand3);
                }
            } else {
                cand2 = cands2.iterator();
                while (cand2.hasNext()) {
                    String cand4 = (String)cand2.next();
                    if (!sb.variablesUpdated().containsVariable(cand4) || sb.get_hops() == null) continue;
                    Hop.resetVisitStatus(sb.get_hops());
                    for (Hop root : sb.get_hops()) {
                        if (!root.getName().equals(cand4) || HopRewriteUtils.rHasSimpleReadChain(root, cand4)) continue;
                        chkpointCand.remove(cand4);
                    }
                }
            }
            ArrayList<Hop> tmp = this.collectCheckpoints(sb.get_hops());
            for (Hop chkpoint : tmp) {
                if (chkpointCand.containsKey(chkpoint.getName())) {
                    ((Hop)chkpointCand.get(chkpoint.getName())).setRequiresCheckpoint(false);
                }
                chkpointCand.put(chkpoint.getName(), chkpoint);
            }
        }
    }

    private void moveCheckpointAfterUpdate(DMLProgram dmlp) throws HopsException {
        HashMap<String, Hop> chkpointCand = new HashMap<String, Hop>();
        for (StatementBlock sb : dmlp.getStatementBlocks()) {
            Iterator cand2;
            HashSet cands = new HashSet(chkpointCand.keySet());
            for (Iterator cand2 : cands) {
                if (!sb.variablesRead().containsVariable((String)((Object)cand2)) || sb.variablesUpdated().containsVariable((String)((Object)cand2))) continue;
                boolean skipRemove = false;
                if (sb.get_hops() != null) {
                    Hop.resetVisitStatus(sb.get_hops());
                    skipRemove = true;
                    for (Hop root : sb.get_hops()) {
                        skipRemove &= !HopRewriteUtils.rContainsRead(root, cand2, false);
                    }
                }
                if (skipRemove) continue;
                chkpointCand.remove(cand2);
            }
            HashSet cands2 = new HashSet(chkpointCand.keySet());
            if (sb instanceof IfStatementBlock || sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) {
                cand2 = cands2.iterator();
                while (cand2.hasNext()) {
                    String cand3 = (String)cand2.next();
                    if (!sb.variablesUpdated().containsVariable(cand3)) continue;
                    chkpointCand.remove(cand3);
                }
            } else {
                cand2 = cands2.iterator();
                while (cand2.hasNext()) {
                    String cand4 = (String)cand2.next();
                    if (!sb.variablesUpdated().containsVariable(cand4) || sb.get_hops() == null) continue;
                    Hop.resetVisitStatus(sb.get_hops());
                    for (Hop root : sb.get_hops()) {
                        if (!root.getName().equals(cand4)) continue;
                        if (HopRewriteUtils.rHasSimpleReadChain(root, cand4)) {
                            ((Hop)chkpointCand.get(cand4)).setRequiresCheckpoint(false);
                            root.getInput().get(0).setRequiresCheckpoint(true);
                            chkpointCand.put(cand4, root.getInput().get(0));
                            continue;
                        }
                        chkpointCand.remove(cand4);
                    }
                }
            }
            ArrayList<Hop> tmp = this.collectCheckpoints(sb.get_hops());
            for (Hop chkpoint : tmp) {
                chkpointCand.put(chkpoint.getName(), chkpoint);
            }
        }
    }

    private void removeCheckpointReadWrite(DMLProgram dmlp) throws HopsException {
        ArrayList<StatementBlock> sbs = dmlp.getStatementBlocks();
        if (sbs.size() == 1 & (!(sbs.get(0) instanceof IfStatementBlock) && !(sbs.get(0) instanceof WhileStatementBlock) && !(sbs.get(0) instanceof ForStatementBlock)) && ((StatementBlock)sbs.get(0)).get_hops() != null) {
            Hop.resetVisitStatus(((StatementBlock)sbs.get(0)).get_hops());
            for (Hop root : ((StatementBlock)sbs.get(0)).get_hops()) {
                InterProceduralAnalysis.rRemoveCheckpointReadWrite(root);
            }
        }
    }

    private ArrayList<Hop> collectCheckpoints(ArrayList<Hop> roots) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        if (roots != null) {
            Hop.resetVisitStatus(roots);
            for (Hop root : roots) {
                this.rCollectCheckpoints(root, ret);
            }
        }
        return ret;
    }

    private void rCollectCheckpoints(Hop hop, ArrayList<Hop> checkpoints) {
        if (hop.isVisited()) {
            return;
        }
        if (hop.requiresCheckpoint() && hop.getParent().size() == 1 && hop.getParent().get(0) instanceof DataOp && ((DataOp)hop.getParent().get(0)).getDataOpType() == Hop.DataOpTypes.TRANSIENTWRITE) {
            checkpoints.add(hop);
        }
        for (Hop c : hop.getInput()) {
            this.rCollectCheckpoints(c, checkpoints);
        }
        hop.setVisited();
    }

    public static void rRemoveCheckpointReadWrite(Hop hop) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof DataOp && ((DataOp)hop).getDataOpType() == Hop.DataOpTypes.PERSISTENTWRITE || hop instanceof AggUnaryOp) {
            Hop c0 = hop.getInput().get(0);
            if (c0.requiresCheckpoint() && c0.getParent().size() == 1 && c0 instanceof DataOp && ((DataOp)c0).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD) {
                c0.setRequiresCheckpoint(false);
            }
            if (c0 instanceof UnaryOp && c0.getParent().size() == 1 && (((UnaryOp)c0).getOp() == Hop.OpOp1.CAST_AS_FRAME || ((UnaryOp)c0).getOp() == Hop.OpOp1.CAST_AS_MATRIX) && c0.getInput().get(0).requiresCheckpoint() && c0.getInput().get(0).getParent().size() == 1 && c0.getInput().get(0) instanceof DataOp && ((DataOp)c0.getInput().get(0)).getDataOpType() == Hop.DataOpTypes.PERSISTENTREAD) {
                c0.getInput().get(0).setRequiresCheckpoint(false);
            }
        }
        for (Hop c : hop.getInput()) {
            InterProceduralAnalysis.rRemoveCheckpointReadWrite(c);
        }
        hop.setVisited();
    }

    private void removeConstantBinaryOps(DMLProgram dmlp) throws HopsException {
        HashMap<String, Hop> mOnes = new HashMap<String, Hop>();
        for (StatementBlock sb : dmlp.getStatementBlocks()) {
            for (String var : sb.variablesUpdated().getVariableNames()) {
                if (!mOnes.containsKey(var)) continue;
                mOnes.remove(var);
            }
            if (!mOnes.isEmpty()) {
                this.rRemoveConstantBinaryOp(sb, mOnes);
            }
            if (sb instanceof IfStatementBlock || sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            this.collectMatrixOfOnes(sb.get_hops(), mOnes);
        }
    }

    private void collectMatrixOfOnes(ArrayList<Hop> roots, HashMap<String, Hop> mOnes) {
        if (roots == null) {
            return;
        }
        for (Hop root : roots) {
            if (!(root instanceof DataOp) || ((DataOp)root).getDataOpType() != Hop.DataOpTypes.TRANSIENTWRITE || !(root.getInput().get(0) instanceof DataGenOp) || ((DataGenOp)root.getInput().get(0)).getOp() != Hop.DataGenMethod.RAND || !((DataGenOp)root.getInput().get(0)).hasConstantValue(1.0)) continue;
            mOnes.put(root.getName(), root.getInput().get(0));
        }
    }

    private void rRemoveConstantBinaryOp(StatementBlock sb, HashMap<String, Hop> mOnes) throws HopsException {
        block11: {
            block10: {
                if (!(sb instanceof IfStatementBlock)) break block10;
                IfStatementBlock isb = (IfStatementBlock)sb;
                IfStatement istmt = (IfStatement)isb.getStatement(0);
                for (StatementBlock c : istmt.getIfBody()) {
                    this.rRemoveConstantBinaryOp(c, mOnes);
                }
                if (istmt.getElseBody() == null) break block11;
                for (StatementBlock c : istmt.getElseBody()) {
                    this.rRemoveConstantBinaryOp(c, mOnes);
                }
                break block11;
            }
            if (sb instanceof WhileStatementBlock) {
                WhileStatementBlock wsb = (WhileStatementBlock)sb;
                WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
                for (StatementBlock c : wstmt.getBody()) {
                    this.rRemoveConstantBinaryOp(c, mOnes);
                }
            } else if (sb instanceof ForStatementBlock) {
                ForStatementBlock fsb = (ForStatementBlock)sb;
                ForStatement fstmt = (ForStatement)fsb.getStatement(0);
                for (StatementBlock c : fstmt.getBody()) {
                    this.rRemoveConstantBinaryOp(c, mOnes);
                }
            } else if (sb.get_hops() != null) {
                Hop.resetVisitStatus(sb.get_hops());
                for (Hop hop : sb.get_hops()) {
                    this.rRemoveConstantBinaryOp(hop, mOnes);
                }
            }
        }
    }

    private void rRemoveConstantBinaryOp(Hop hop, HashMap<String, Hop> mOnes) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof BinaryOp && ((BinaryOp)hop).getOp() == Hop.OpOp2.MULT && !((BinaryOp)hop).isOuterVectorOperator() && hop.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hop.getInput().get(1) instanceof DataOp && mOnes.containsKey(hop.getInput().get(1).getName())) {
            HopRewriteUtils.removeChildReferenceByPos(hop, hop.getInput().get(1), 1);
            HopRewriteUtils.addChildReference(hop, new LiteralOp(1L), 1);
        }
        for (Hop c : hop.getInput()) {
            this.rRemoveConstantBinaryOp(c, mOnes);
        }
        hop.setVisited();
    }
}

