/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.template;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.codegen.template.CPlanMemoTable;
import org.apache.sysml.hops.codegen.template.TemplateBase;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class PlanSelection {
    private final HashMap<Long, List<CPlanMemoTable.MemoTableEntry>> _bestPlans = new HashMap();
    private final HashSet<VisitMark> _visited = new HashSet();

    public abstract void selectPlans(CPlanMemoTable var1, ArrayList<Hop> var2);

    protected static boolean isValid(CPlanMemoTable.MemoTableEntry me, Hop hop) {
        return me.type == TemplateBase.TemplateType.OuterProdTpl && (me.closed || HopRewriteUtils.isBinaryMatrixMatrixOperation(hop)) || me.type == TemplateBase.TemplateType.RowTpl || me.type == TemplateBase.TemplateType.CellTpl || me.type == TemplateBase.TemplateType.MultiAggTpl;
    }

    protected void addBestPlan(long hopID, CPlanMemoTable.MemoTableEntry me) {
        if (me == null) {
            return;
        }
        if (!this._bestPlans.containsKey(hopID)) {
            this._bestPlans.put(hopID, new ArrayList());
        }
        this._bestPlans.get(hopID).add(me);
    }

    protected HashMap<Long, List<CPlanMemoTable.MemoTableEntry>> getBestPlans() {
        return this._bestPlans;
    }

    public boolean isVisited(long hopID, TemplateBase.TemplateType type) {
        return this._visited.contains(new VisitMark(hopID, type));
    }

    public void setVisited(long hopID, TemplateBase.TemplateType type) {
        this._visited.add(new VisitMark(hopID, type));
    }

    private static class VisitMark {
        private final long _hopID;
        private final TemplateBase.TemplateType _type;

        public VisitMark(long hopID, TemplateBase.TemplateType type) {
            this._hopID = hopID;
            this._type = type;
        }

        public int hashCode() {
            return UtilFunctions.longlongHashCode(this._hopID, this._type != null ? (long)this._type.hashCode() : 0L);
        }

        public boolean equals(Object o) {
            return o instanceof VisitMark && this._hopID == ((VisitMark)o)._hopID && this._type == ((VisitMark)o)._type;
        }
    }

    protected static class BasicPlanComparator
    implements Comparator<CPlanMemoTable.MemoTableEntry> {
        protected BasicPlanComparator() {
        }

        @Override
        public int compare(CPlanMemoTable.MemoTableEntry o1, CPlanMemoTable.MemoTableEntry o2) {
            if (o1.type != o2.type) {
                return Integer.compare(o1.type.getRank(), o2.type.getRank());
            }
            return Integer.compare(3 - o1.countPlanRefs(), 3 - o2.countPlanRefs());
        }
    }
}

