/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.cplan;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;

public abstract class CNode {
    private static final IDSequence _seqVar = new IDSequence();
    private static final IDSequence _seqID = new IDSequence();
    protected final long _ID = _seqID.getNextID();
    protected ArrayList<CNode> _inputs = new ArrayList();
    protected CNode _output = null;
    protected boolean _visited = false;
    protected boolean _generated = false;
    protected String _genVar = null;
    protected long _rows = -1L;
    protected long _cols = -1L;
    protected Expression.DataType _dataType;
    protected boolean _literal = false;
    protected int _hash = 0;

    public long getID() {
        return this._ID;
    }

    public ArrayList<CNode> getInput() {
        return this._inputs;
    }

    public String createVarname() {
        this._genVar = "TMP" + _seqVar.getNextID();
        return this._genVar;
    }

    protected String getCurrentVarName() {
        return "TMP" + (_seqVar.getCurrentID() - 1L);
    }

    public String getVarname() {
        return this._genVar;
    }

    public String getClassname() {
        return this.getVarname();
    }

    public void resetGenerated() {
        if (this._generated) {
            for (CNode cn : this._inputs) {
                cn.resetGenerated();
            }
        }
        this._generated = false;
    }

    public void setNumRows(long rows) {
        this._rows = rows;
    }

    public long getNumRows() {
        return this._rows;
    }

    public void setNumCols(long cols) {
        this._cols = cols;
    }

    public long getNumCols() {
        return this._cols;
    }

    public Expression.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(Expression.DataType dt) {
        this._dataType = dt;
        this._hash = 0;
    }

    public boolean isLiteral() {
        return this._literal;
    }

    public void setLiteral(boolean literal) {
        this._literal = literal;
        this._hash = 0;
    }

    public CNode getOutput() {
        return this._output;
    }

    public void setOutput(CNode output) {
        this._output = output;
        this._hash = 0;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean flag) {
        this._visited = flag;
    }

    public void resetVisitStatus() {
        if (!this.isVisited()) {
            return;
        }
        for (CNode h : this.getInput()) {
            h.resetVisitStatus();
        }
        this.setVisited(false);
    }

    public abstract String codegen(boolean var1);

    public abstract void setOutputDims();

    public int hashCode() {
        if (this._hash == 0) {
            int numIn = this._inputs.size();
            int[] tmp = new int[numIn + 3];
            int pos = 0;
            for (CNode c : this._inputs) {
                if (c.getDataType() != Expression.DataType.MATRIX) continue;
                tmp[pos++] = c.hashCode();
            }
            for (CNode c : this._inputs) {
                if (c.getDataType() == Expression.DataType.MATRIX) continue;
                tmp[pos++] = c.hashCode();
            }
            tmp[numIn + 0] = this._output != null ? this._output.hashCode() : 0;
            tmp[numIn + 1] = this._dataType != null ? this._dataType.hashCode() : 0;
            tmp[numIn + 2] = Boolean.valueOf(this._literal).hashCode();
            this._hash = Arrays.hashCode(tmp);
        }
        return this._hash;
    }

    public boolean equals(Object that) {
        if (!(that instanceof CNode)) {
            return false;
        }
        CNode cthat = (CNode)that;
        boolean ret = this._inputs.size() == cthat._inputs.size();
        for (int i = 0; i < this._inputs.size() && ret; ret &= this._inputs.get(i).equals(cthat._inputs.get(i)), ++i) {
        }
        return ret && (this._output == cthat._output || this._output.equals(cthat._output)) && this._dataType == cthat._dataType && this._literal == cthat._literal;
    }
}

