/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import java.util.ArrayList;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.MultipleCP;
import org.apache.sysml.parser.Expression;

public class MultipleOp
extends Hop {
    protected Hop.MultiInputOp multipleOperandOperation = null;

    protected MultipleOp() {
    }

    public MultipleOp(String name, Expression.DataType dataType, Expression.ValueType valueType, Hop.MultiInputOp multipleOperandOperation, Hop ... inputs) throws HopsException {
        super(name, dataType, valueType);
        this.multipleOperandOperation = multipleOperandOperation;
        for (int i = 0; i < inputs.length; ++i) {
            this.getInput().add(i, inputs[i]);
            inputs[i].getParent().add(this);
        }
        this.refreshSizeInformation();
    }

    public Hop.MultiInputOp getOp() {
        return this.multipleOperandOperation;
    }

    @Override
    public String getOpString() {
        return "m(" + this.multipleOperandOperation.toString().toLowerCase() + ")";
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            ArrayList<Hop> inHops = this.getInput();
            Lop[] inLops = new Lop[inHops.size()];
            for (int i = 0; i < inHops.size(); ++i) {
                Lop inLop;
                Hop inHop = inHops.get(i);
                inLops[i] = inLop = inHop.constructLops();
            }
            MultipleCP.OperationType opType = (MultipleCP.OperationType)((Object)MultipleOperandOperationHopTypeToLopType.get((Object)this.multipleOperandOperation));
            if (opType == null) {
                throw new HopsException("Unknown MultipleCP Lop operation type for MultipleOperandOperation Hop type '" + (Object)((Object)this.multipleOperandOperation) + "'");
            }
            MultipleCP multipleCPLop = new MultipleCP(opType, this.getDataType(), this.getValueType(), inLops);
            this.setOutputDimensions(multipleCPLop);
            this.setLineNumbers(multipleCPLop);
            this.setLops(multipleCPLop);
        }
        catch (Exception e) {
            throw new HopsException(this.printErrorLocation() + "error constructing Lops for MultipleOp Hop -- \n ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        this.checkAndSetForcedPlatform();
        return LopProperties.ExecType.CP;
    }

    @Override
    public void refreshSizeInformation() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultipleOp multipleOp = new MultipleOp();
        multipleOp.clone(this, false);
        multipleOp.multipleOperandOperation = this.multipleOperandOperation;
        return multipleOp;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof MultipleOp)) {
            return false;
        }
        if (this.multipleOperandOperation == Hop.MultiInputOp.PRINTF) {
            return false;
        }
        MultipleOp mo = (MultipleOp)that;
        return this.multipleOperandOperation == mo.multipleOperandOperation;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        return null;
    }
}

