/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.util.UtilFunctions;

public class LiteralOp
extends Hop {
    private double value_double = Double.NaN;
    private long value_long = Long.MAX_VALUE;
    private String value_string;
    private boolean value_boolean;

    private LiteralOp() {
    }

    public LiteralOp(double value) {
        super(String.valueOf(value), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE);
        this.value_double = value;
    }

    public LiteralOp(long value) {
        super(String.valueOf(value), Expression.DataType.SCALAR, Expression.ValueType.INT);
        this.value_long = value;
    }

    public LiteralOp(String value) {
        super(value, Expression.DataType.SCALAR, Expression.ValueType.STRING);
        this.value_string = value;
    }

    public LiteralOp(boolean value) {
        super(String.valueOf(value), Expression.DataType.SCALAR, Expression.ValueType.BOOLEAN);
        this.value_boolean = value;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            Data l = null;
            switch (this.getValueType()) {
                case DOUBLE: {
                    l = Data.createLiteralLop(Expression.ValueType.DOUBLE, Double.toString(this.value_double));
                    break;
                }
                case BOOLEAN: {
                    l = Data.createLiteralLop(Expression.ValueType.BOOLEAN, Boolean.toString(this.value_boolean));
                    break;
                }
                case STRING: {
                    l = Data.createLiteralLop(Expression.ValueType.STRING, this.value_string);
                    break;
                }
                case INT: {
                    l = Data.createLiteralLop(Expression.ValueType.INT, Long.toString(this.value_long));
                    break;
                }
                default: {
                    throw new HopsException(this.printErrorLocation() + "unexpected value type constructing lops for LiteralOp.\n");
                }
            }
            l.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(l);
            this.setLops(l);
        }
        catch (LopsException e) {
            throw new HopsException(e);
        }
        return this.getLops();
    }

    @Override
    public String getOpString() {
        String val = null;
        switch (this.getValueType()) {
            case DOUBLE: {
                val = Double.toString(this.value_double);
                break;
            }
            case BOOLEAN: {
                val = Boolean.toString(this.value_boolean);
                break;
            }
            case STRING: {
                val = this.value_string;
                break;
            }
            case INT: {
                val = Long.toString(this.value_long);
                break;
            }
            default: {
                val = "";
            }
        }
        return "LiteralOp " + val;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        switch (this.getValueType()) {
            case INT: {
                ret = 4.0;
                break;
            }
            case DOUBLE: {
                ret = 8.0;
                break;
            }
            case BOOLEAN: {
                ret = 1.0;
                break;
            }
            case STRING: {
                ret = (long)this.value_string.length() * 1L;
                break;
            }
            case OBJECT: {
                ret = OptimizerUtils.DEFAULT_SIZE;
                break;
            }
            default: {
                ret = 0.0;
            }
        }
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        return null;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        return null;
    }

    @Override
    public void refreshSizeInformation() {
    }

    public long getLongValue() {
        switch (this.getValueType()) {
            case INT: {
                return this.value_long;
            }
            case DOUBLE: {
                return UtilFunctions.toLong(this.value_double);
            }
            case STRING: {
                return Long.parseLong(this.value_string);
            }
            case BOOLEAN: {
                return this.value_boolean ? 1L : 0L;
            }
        }
        return -1L;
    }

    public double getDoubleValue() throws HopsException {
        switch (this.getValueType()) {
            case INT: {
                return this.value_long;
            }
            case DOUBLE: {
                return this.value_double;
            }
            case STRING: {
                return Double.parseDouble(this.value_string);
            }
        }
        throw new HopsException("Can not coerce an object of type " + (Object)((Object)this.getValueType()) + " into Double.");
    }

    public boolean getBooleanValue() throws HopsException {
        if (this.getValueType() == Expression.ValueType.BOOLEAN) {
            return this.value_boolean;
        }
        throw new HopsException("Can not coerce an object of type " + (Object)((Object)this.getValueType()) + " into Boolean.");
    }

    public String getStringValue() {
        switch (this.getValueType()) {
            case BOOLEAN: {
                return String.valueOf(this.value_boolean);
            }
            case INT: {
                return String.valueOf(this.value_long);
            }
            case DOUBLE: {
                return String.valueOf(this.value_double);
            }
            case STRING: {
                return this.value_string;
            }
        }
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LiteralOp ret = new LiteralOp();
        ret.clone(this, false);
        ret.value_double = this.value_double;
        ret.value_long = this.value_long;
        ret.value_string = this.value_string;
        ret.value_boolean = this.value_boolean;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        return false;
    }
}

