/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.AppendCP;
import org.apache.sysml.lops.AppendG;
import org.apache.sysml.lops.AppendGAlignedSP;
import org.apache.sysml.lops.AppendM;
import org.apache.sysml.lops.AppendR;
import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.lops.BinaryScalar;
import org.apache.sysml.lops.BinaryUAggChain;
import org.apache.sysml.lops.CentralMoment;
import org.apache.sysml.lops.CoVariance;
import org.apache.sysml.lops.CombineBinary;
import org.apache.sysml.lops.CombineUnary;
import org.apache.sysml.lops.ConvolutionTransform;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.DataPartition;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.PickByCount;
import org.apache.sysml.lops.RepMat;
import org.apache.sysml.lops.SortKeys;
import org.apache.sysml.lops.Unary;
import org.apache.sysml.lops.UnaryCP;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class BinaryOp
extends Hop {
    public static final double APPEND_MEM_MULTIPLIER = 1.0;
    private Hop.OpOp2 op;
    private boolean outer = false;
    public static AppendMethod FORCED_APPEND_METHOD = null;

    private BinaryOp() {
    }

    public BinaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp2 o, Hop inp1, Hop inp2) {
        super(l, dt, vt);
        this.op = o;
        this.getInput().add(0, inp1);
        this.getInput().add(1, inp2);
        inp1.getParent().add(this);
        inp2.getParent().add(this);
        this.refreshSizeInformation();
    }

    public Hop.OpOp2 getOp() {
        return this.op;
    }

    public void setOp(Hop.OpOp2 iop) {
        this.op = iop;
    }

    public void setOuterVectorOperation(boolean flag) {
        this.outer = flag;
    }

    public boolean isOuterVectorOperator() {
        return this.outer;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        switch (this.op) {
            case IQM: {
                this.constructLopsIQM(et);
                break;
            }
            case CENTRALMOMENT: {
                this.constructLopsCentralMoment(et);
                break;
            }
            case COVARIANCE: {
                this.constructLopsCovariance(et);
                break;
            }
            case QUANTILE: 
            case INTERQUANTILE: {
                this.constructLopsQuantile(et);
                break;
            }
            case MEDIAN: {
                this.constructLopsMedian(et);
                break;
            }
            case CBIND: 
            case RBIND: {
                this.constructLopsAppend(et);
                break;
            }
            default: {
                this.constructLopsBinaryDefault();
            }
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private void constructLopsIQM(LopProperties.ExecType et) throws HopsException, LopsException {
        if (et == LopProperties.ExecType.MR) {
            CombineBinary combine = CombineBinary.constructCombineLop(CombineBinary.OperationTypes.PreSort, this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Expression.DataType.MATRIX, this.getValueType());
            combine.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            SortKeys sort = SortKeys.constructSortByValueLop(combine, SortKeys.OperationTypes.WithWeights, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.MR);
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            Data lit = Data.createLiteralLop(Expression.ValueType.DOUBLE, Double.toString(0.25));
            this.setLineNumbers(lit);
            PickByCount pick = new PickByCount(sort, lit, Expression.DataType.MATRIX, this.getValueType(), PickByCount.OperationTypes.RANGEPICK);
            pick.getOutputParameters().setDimensions(-1L, -1L, this.getRowsInBlock(), this.getColsInBlock(), -1L);
            this.setLineNumbers(pick);
            PartialAggregate pagg = new PartialAggregate(pick, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)Hop.Direction.RowCol)), Expression.DataType.MATRIX, this.getValueType());
            this.setLineNumbers(pagg);
            pagg.setDimensionsBasedOnDirection(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock());
            Group group1 = new Group(pagg, Group.OperationTypes.Sort, Expression.DataType.MATRIX, this.getValueType());
            this.setOutputDimensions(group1);
            this.setLineNumbers(group1);
            Aggregate agg1 = new Aggregate(group1, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), Expression.DataType.MATRIX, this.getValueType(), LopProperties.ExecType.MR);
            this.setOutputDimensions(agg1);
            agg1.setupCorrectionLocation(pagg.getCorrectionLocation());
            this.setLineNumbers(agg1);
            UnaryCP unary1 = new UnaryCP(agg1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), Expression.DataType.SCALAR, this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            Unary iqm = new Unary((Lop)sort, unary1, Unary.OperationTypes.MR_IQM, Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, LopProperties.ExecType.CP);
            iqm.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(iqm);
            this.setLops(iqm);
        } else {
            SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), SortKeys.OperationTypes.WithWeights, this.getInput().get(0).getDataType(), this.getInput().get(0).getValueType(), et);
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            PickByCount pick = new PickByCount(sort, null, this.getDataType(), this.getValueType(), PickByCount.OperationTypes.IQM, et, true);
            this.setOutputDimensions(pick);
            this.setLineNumbers(pick);
            this.setLops(pick);
        }
    }

    private void constructLopsMedian(LopProperties.ExecType et) throws HopsException, LopsException {
        if (et == LopProperties.ExecType.MR) {
            CombineBinary combine = CombineBinary.constructCombineLop(CombineBinary.OperationTypes.PreSort, this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Expression.DataType.MATRIX, this.getValueType());
            SortKeys sort = SortKeys.constructSortByValueLop(combine, SortKeys.OperationTypes.WithWeights, Expression.DataType.MATRIX, this.getValueType(), et);
            combine.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            LopProperties.ExecType et_pick = LopProperties.ExecType.CP;
            PickByCount pick = new PickByCount(sort, Data.createLiteralLop(Expression.ValueType.DOUBLE, Double.toString(0.5)), this.getDataType(), this.getValueType(), PickByCount.OperationTypes.MEDIAN, et_pick, false);
            pick.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            pick.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
            this.setLops(pick);
        } else {
            SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), SortKeys.OperationTypes.WithWeights, this.getInput().get(0).getDataType(), this.getInput().get(0).getValueType(), et);
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            PickByCount pick = new PickByCount(sort, Data.createLiteralLop(Expression.ValueType.DOUBLE, Double.toString(0.5)), this.getDataType(), this.getValueType(), PickByCount.OperationTypes.MEDIAN, et, true);
            pick.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            pick.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
            this.setLops(pick);
        }
    }

    private void constructLopsCentralMoment(LopProperties.ExecType et) throws HopsException, LopsException {
        Expression.DataType dt = et == LopProperties.ExecType.MR ? Expression.DataType.MATRIX : Expression.DataType.SCALAR;
        CentralMoment cm = new CentralMoment(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), dt, this.getValueType(), et);
        this.setLineNumbers(cm);
        if (et == LopProperties.ExecType.MR) {
            cm.getOutputParameters().setDimensions(1L, 1L, 0L, 0L, -1L);
            UnaryCP unary1 = new UnaryCP(cm, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        } else {
            cm.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLops(cm);
        }
    }

    private void constructLopsCovariance(LopProperties.ExecType et) throws LopsException, HopsException {
        if (et == LopProperties.ExecType.MR) {
            CombineBinary combine = CombineBinary.constructCombineLop(CombineBinary.OperationTypes.PreCovUnweighted, this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Expression.DataType.MATRIX, this.getValueType());
            combine.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            CoVariance cov = new CoVariance(combine, Expression.DataType.MATRIX, this.getValueType(), et);
            cov.getOutputParameters().setDimensions(1L, 1L, 0L, 0L, -1L);
            this.setLineNumbers(cov);
            UnaryCP unary1 = new UnaryCP(cov, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        } else {
            CoVariance cov = new CoVariance(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getDataType(), this.getValueType(), et);
            cov.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(cov);
            this.setLops(cov);
        }
    }

    private void constructLopsQuantile(LopProperties.ExecType et) throws HopsException, LopsException {
        PickByCount.OperationTypes pick_op = null;
        pick_op = this.op == Hop.OpOp2.QUANTILE ? PickByCount.OperationTypes.VALUEPICK : PickByCount.OperationTypes.RANGEPICK;
        if (et == LopProperties.ExecType.MR) {
            CombineUnary combine = CombineUnary.constructCombineLop(this.getInput().get(0).constructLops(), this.getDataType(), this.getValueType());
            SortKeys sort = SortKeys.constructSortByValueLop(combine, SortKeys.OperationTypes.WithoutWeights, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, et);
            combine.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            LopProperties.ExecType et_pick = this.getInput().get(1).getDataType() == Expression.DataType.SCALAR ? LopProperties.ExecType.CP : LopProperties.ExecType.MR;
            PickByCount pick = new PickByCount(sort, this.getInput().get(1).constructLops(), this.getDataType(), this.getValueType(), pick_op, et_pick, false);
            pick.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            pick.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
            this.setLops(pick);
        } else {
            SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), SortKeys.OperationTypes.WithoutWeights, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, et);
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            PickByCount pick = new PickByCount(sort, this.getInput().get(1).constructLops(), this.getDataType(), this.getValueType(), pick_op, et, true);
            this.setOutputDimensions(pick);
            this.setLineNumbers(pick);
            this.setLops(pick);
        }
    }

    private void constructLopsAppend(LopProperties.ExecType et) throws HopsException, LopsException {
        boolean cbind;
        Expression.DataType dt1 = this.getInput().get(0).getDataType();
        Expression.DataType dt2 = this.getInput().get(1).getDataType();
        Expression.ValueType vt1 = this.getInput().get(0).getValueType();
        Expression.ValueType vt2 = this.getInput().get(1).getValueType();
        boolean bl = cbind = this.op == Hop.OpOp2.CBIND;
        if (!(dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.MATRIX || dt1 == Expression.DataType.FRAME && dt2 == Expression.DataType.FRAME || dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.SCALAR && vt1 == Expression.ValueType.STRING && vt2 == Expression.ValueType.STRING)) {
            throw new HopsException("Append can only apply to two matrices, two frames, or two scalar strings!");
        }
        Lop append = null;
        if (dt1 == Expression.DataType.MATRIX || dt1 == Expression.DataType.FRAME) {
            long clen;
            long rlen;
            long l = cbind ? this.getInput().get(0).getDim1() : (rlen = this.getInput().get(0).dimsKnown() && this.getInput().get(1).dimsKnown() ? this.getInput().get(0).getDim1() + this.getInput().get(1).getDim1() : -1L);
            long l2 = cbind ? (this.getInput().get(0).dimsKnown() && this.getInput().get(1).dimsKnown() ? this.getInput().get(0).getDim2() + this.getInput().get(1).getDim2() : -1L) : (clen = this.getInput().get(0).getDim2());
            if (et == LopProperties.ExecType.MR) {
                append = BinaryOp.constructMRAppendLop(this.getInput().get(0), this.getInput().get(1), this.getDataType(), this.getValueType(), cbind, this);
            } else if (et == LopProperties.ExecType.SPARK) {
                append = BinaryOp.constructSPAppendLop(this.getInput().get(0), this.getInput().get(1), this.getDataType(), this.getValueType(), cbind, this);
                append.getOutputParameters().setDimensions(rlen, clen, this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            } else {
                Lop offset = BinaryOp.createOffsetLop(this.getInput().get(0), cbind);
                append = new AppendCP(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), offset, this.getDataType(), this.getValueType(), cbind);
                append.getOutputParameters().setDimensions(rlen, clen, this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            }
        } else {
            append = new AppendCP(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Data.createLiteralLop(Expression.ValueType.INT, "-1"), this.getDataType(), this.getValueType(), cbind);
            append.getOutputParameters().setDimensions(0L, 0L, -1L, -1L, -1L);
        }
        this.setLineNumbers(append);
        this.setLops(append);
    }

    private void constructLopsBinaryDefault() throws HopsException, LopsException {
        Expression.DataType dt2;
        Expression.DataType dt1 = this.getInput().get(0).getDataType();
        if (dt1 == (dt2 = this.getInput().get(1).getDataType()) && dt1 == Expression.DataType.SCALAR) {
            BinaryScalar binScalar1 = new BinaryScalar(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), (BinaryScalar.OperationTypes)((Object)HopsOpOp2LopsBS.get((Object)this.op)), this.getDataType(), this.getValueType());
            binScalar1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(binScalar1);
            this.setLops(binScalar1);
        } else if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.SCALAR || dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.MATRIX) {
            LopProperties.ExecType et = this.optFindExecType();
            Unary.OperationTypes ot = null;
            Hop right = this.getInput().get(1);
            ot = this.op == Hop.OpOp2.POW && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == 2.0 ? Unary.OperationTypes.POW2 : (this.op == Hop.OpOp2.MULT && right instanceof LiteralOp && ((LiteralOp)right).getDoubleValue() == 2.0 ? Unary.OperationTypes.MULTIPLY2 : (Unary.OperationTypes)((Object)HopsOpOp2LopsU.get((Object)this.op)));
            if (DMLScript.USE_ACCELERATOR && (DMLScript.FORCE_ACCELERATOR || this.getMemEstimate() < (double)OptimizerUtils.GPU_MEMORY_BUDGET) && (this.op == Hop.OpOp2.MULT || this.op == Hop.OpOp2.PLUS || this.op == Hop.OpOp2.MINUS || this.op == Hop.OpOp2.DIV || this.op == Hop.OpOp2.POW)) {
                et = LopProperties.ExecType.GPU;
            }
            Unary unary1 = new Unary(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), ot, this.getDataType(), this.getValueType(), et);
            this.setOutputDimensions(unary1);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        } else {
            LopProperties.ExecType et = this.optFindExecType();
            if (et == LopProperties.ExecType.CP) {
                if (DMLScript.USE_ACCELERATOR && (DMLScript.FORCE_ACCELERATOR || this.getMemEstimate() < (double)OptimizerUtils.GPU_MEMORY_BUDGET) && (this.op == Hop.OpOp2.MULT || this.op == Hop.OpOp2.PLUS || this.op == Hop.OpOp2.MINUS || this.op == Hop.OpOp2.DIV || this.op == Hop.OpOp2.POW)) {
                    et = LopProperties.ExecType.GPU;
                }
                Lop binary = null;
                boolean isLeftXGt = this.getInput().get(0) instanceof BinaryOp && ((BinaryOp)this.getInput().get(0)).getOp() == Hop.OpOp2.GREATER;
                Hop potentialZero = isLeftXGt ? ((BinaryOp)this.getInput().get(0)).getInput().get(1) : null;
                boolean isLeftXGt0 = isLeftXGt && potentialZero != null && potentialZero instanceof LiteralOp && ((LiteralOp)potentialZero).getDoubleValue() == 0.0;
                binary = this.op == Hop.OpOp2.MULT && isLeftXGt0 && !this.getInput().get(0).isVector() && !this.getInput().get(1).isVector() && this.getInput().get(0).dimsKnown() && this.getInput().get(1).dimsKnown() ? new ConvolutionTransform(this.getInput().get(0).getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), ConvolutionTransform.OperationTypes.RELU_BACKWARD, this.getDataType(), this.getValueType(), et, -1) : new Binary(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(binary);
                this.setLineNumbers(binary);
                this.setLops(binary);
            } else if (et == LopProperties.ExecType.SPARK) {
                Hop left = this.getInput().get(0);
                Hop right = this.getInput().get(1);
                MMBinaryMethod mbin = this.optFindMMBinaryMethodSpark(left, right);
                Lop binary = null;
                if (mbin == MMBinaryMethod.MR_BINARY_UAGG_CHAIN) {
                    AggUnaryOp uRight = (AggUnaryOp)right;
                    binary = new BinaryUAggChain(left.constructLops(), (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)uRight.getOp())), (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)uRight.getDirection())), this.getDataType(), this.getValueType(), et);
                } else if (mbin == MMBinaryMethod.MR_BINARY_M) {
                    boolean partitioned = false;
                    boolean isColVector = right.getDim2() == 1L && left.getDim1() == right.getDim1();
                    binary = new BinaryM(left.constructLops(), right.constructLops(), (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), this.getDataType(), this.getValueType(), et, partitioned, isColVector);
                } else {
                    binary = new Binary(left.constructLops(), right.constructLops(), (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), this.getDataType(), this.getValueType(), et);
                }
                this.setOutputDimensions(binary);
                this.setLineNumbers(binary);
                this.setLops(binary);
            } else {
                Hop right;
                Hop left = this.getInput().get(0);
                MMBinaryMethod mbin = this.optFindMMBinaryMethod(left, right = this.getInput().get(1));
                if (mbin == MMBinaryMethod.MR_BINARY_M) {
                    boolean needPart = BinaryOp.requiresPartitioning(right);
                    Lop dcInput = right.constructLops();
                    if (needPart) {
                        LopProperties.ExecType etPart = (double)OptimizerUtils.estimateSizeExactSparsity(right.getDim1(), right.getDim2(), OptimizerUtils.getSparsity(right.getDim1(), right.getDim2(), right.getNnz())) < OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.CP : LopProperties.ExecType.MR;
                        dcInput = new DataPartition(dcInput, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, etPart, right.getDim2() == 1L ? ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N : ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE_N);
                        dcInput.getOutputParameters().setDimensions(right.getDim1(), right.getDim2(), right.getRowsInBlock(), right.getColsInBlock(), right.getNnz());
                        dcInput.setAllPositions(right.getBeginLine(), right.getBeginColumn(), right.getEndLine(), right.getEndColumn());
                    }
                    BinaryM binary = new BinaryM(left.constructLops(), dcInput, (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), this.getDataType(), this.getValueType(), LopProperties.ExecType.MR, needPart, right.getDim2() == 1L && left.getDim1() == right.getDim1());
                    this.setOutputDimensions(binary);
                    this.setLineNumbers(binary);
                    this.setLops(binary);
                } else if (mbin == MMBinaryMethod.MR_BINARY_UAGG_CHAIN) {
                    AggUnaryOp uRight = (AggUnaryOp)right;
                    BinaryUAggChain bin = new BinaryUAggChain(left.constructLops(), (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)uRight.getOp())), (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)uRight.getDirection())), this.getDataType(), this.getValueType(), et);
                    this.setOutputDimensions(bin);
                    this.setLineNumbers(bin);
                    this.setLops(bin);
                } else if (mbin == MMBinaryMethod.MR_BINARY_OUTER_R) {
                    Lop offset;
                    boolean requiresRepLeft = !right.dimsKnown() || right.getDim2() > right.getColsInBlock();
                    boolean requiresRepRight = !left.dimsKnown() || left.getDim1() > right.getRowsInBlock();
                    Lop leftLop = left.constructLops();
                    Lop rightLop = right.constructLops();
                    if (requiresRepLeft) {
                        offset = BinaryOp.createOffsetLop(right, true);
                        leftLop = new RepMat(leftLop, offset, true, left.getDataType(), left.getValueType());
                        this.setOutputDimensions(leftLop);
                        this.setLineNumbers(leftLop);
                    }
                    if (requiresRepRight) {
                        offset = BinaryOp.createOffsetLop(left, false);
                        rightLop = new RepMat(rightLop, offset, false, right.getDataType(), right.getValueType());
                        this.setOutputDimensions(rightLop);
                        this.setLineNumbers(rightLop);
                    }
                    Group group1 = new Group(leftLop, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    this.setLineNumbers(group1);
                    this.setOutputDimensions(group1);
                    Group group2 = new Group(rightLop, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    this.setLineNumbers(group2);
                    this.setOutputDimensions(group2);
                    Binary binary = new Binary(group1, group2, (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), this.getDataType(), this.getValueType(), et);
                    this.setOutputDimensions(binary);
                    this.setLineNumbers(binary);
                    this.setLops(binary);
                } else {
                    boolean requiresRep = BinaryOp.requiresReplication(left, right);
                    Lop rightLop = right.constructLops();
                    if (requiresRep) {
                        Lop offset = BinaryOp.createOffsetLop(left, right.getDim2() <= 1L);
                        rightLop = new RepMat(rightLop, offset, right.getDim2() <= 1L, right.getDataType(), right.getValueType());
                        this.setOutputDimensions(rightLop);
                        this.setLineNumbers(rightLop);
                    }
                    Group group1 = new Group(this.getInput().get(0).constructLops(), Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    this.setLineNumbers(group1);
                    this.setOutputDimensions(group1);
                    Group group2 = new Group(rightLop, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    this.setLineNumbers(group2);
                    this.setOutputDimensions(group2);
                    Binary binary = new Binary(group1, group2, (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)this.op)), this.getDataType(), this.getValueType(), et);
                    this.setLineNumbers(binary);
                    this.setOutputDimensions(binary);
                    this.setLops(binary);
                }
            }
        }
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + "b(" + (String)HopsOpOp2String.get((Object)this.op) + ")";
        return s;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this.dimsKnown() && this._nnz < 0L) {
            nnz = -1L;
        }
        if (!(this.op != Hop.OpOp2.CBIND && this.op != Hop.OpOp2.RBIND || ConfigurationManager.isDynamicRecompilation() || this.getDataType() == Expression.DataType.SCALAR)) {
            ret = OptimizerUtils.DEFAULT_SIZE;
        } else {
            double sparsity = 1.0;
            if (nnz < 0L) {
                Hop input1 = this.getInput().get(0);
                Hop input2 = this.getInput().get(1);
                if (input1.dimsKnown() && input2.dimsKnown()) {
                    if (OptimizerUtils.isBinaryOpConditionalSparseSafe(this.op) && input2 instanceof LiteralOp) {
                        double sp1 = input1.getNnz() > 0L && input1.getDataType() == Expression.DataType.MATRIX ? OptimizerUtils.getSparsity(input1.getDim1(), input1.getDim2(), input1.getNnz()) : 1.0;
                        LiteralOp lit = (LiteralOp)input2;
                        sparsity = OptimizerUtils.getBinaryOpSparsityConditionalSparseSafe(sp1, this.op, lit);
                    } else {
                        double sp1 = input1.getNnz() > 0L && input1.getDataType() == Expression.DataType.MATRIX ? OptimizerUtils.getSparsity(input1.getDim1(), input1.getDim2(), input1.getNnz()) : 1.0;
                        double sp2 = input2.getNnz() > 0L && input2.getDataType() == Expression.DataType.MATRIX ? OptimizerUtils.getSparsity(input2.getDim1(), input2.getDim2(), input2.getNnz()) : 1.0;
                        sparsity = OptimizerUtils.getBinaryOpSparsity(sp1, sp2, this.op, !this.outer);
                    }
                }
            } else {
                sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
            }
            ret = OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
        }
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this.op == Hop.OpOp2.QUANTILE || this.op == Hop.OpOp2.IQM || this.op == Hop.OpOp2.MEDIAN) {
            ret = this.getInput().get(0).getMemEstimate() * 3.0;
        } else if (this.op == Hop.OpOp2.SOLVE) {
            double interOutput = OptimizerUtils.estimateSizeExactSparsity(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), 1.0);
            return interOutput;
        }
        return ret;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        MatrixCharacteristics[] mc = memo.getAllInputStats(this.getInput());
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        Expression.DataType dt1 = input1.getDataType();
        Expression.DataType dt2 = input2.getDataType();
        if (this.op == Hop.OpOp2.CBIND) {
            long ldim1 = -1L;
            long ldim2 = -1L;
            long lnnz = -1L;
            if (mc[0].rowsKnown() || mc[1].rowsKnown()) {
                long l = ldim1 = mc[0].rowsKnown() ? mc[0].getRows() : mc[1].getRows();
            }
            if (mc[0].colsKnown() && mc[1].colsKnown()) {
                ldim2 = mc[0].getCols() + mc[1].getCols();
            }
            if (mc[0].nnzKnown() && mc[1].nnzKnown()) {
                lnnz = mc[0].getNonZeros() + mc[1].getNonZeros();
            }
            if (ldim1 > 0L || ldim2 > 0L || lnnz >= 0L) {
                return new long[]{ldim1, ldim2, lnnz};
            }
        } else if (this.op == Hop.OpOp2.CBIND) {
            long ldim1 = -1L;
            long ldim2 = -1L;
            long lnnz = -1L;
            if (mc[0].colsKnown() || mc[1].colsKnown()) {
                long l = ldim2 = mc[0].colsKnown() ? mc[0].getCols() : mc[1].getCols();
            }
            if (mc[0].rowsKnown() && mc[1].rowsKnown()) {
                ldim1 = mc[0].getRows() + mc[1].getRows();
            }
            if (mc[0].nnzKnown() && mc[1].nnzKnown()) {
                lnnz = mc[0].getNonZeros() + mc[1].getNonZeros();
            }
            if (ldim1 > 0L || ldim2 > 0L || lnnz >= 0L) {
                return new long[]{ldim1, ldim2, lnnz};
            }
        } else if (this.op == Hop.OpOp2.SOLVE) {
            if (mc[0].getCols() > 0L) {
                ret = new long[]{mc[0].getCols(), 1L, mc[0].getCols()};
            }
        } else {
            long ldim2;
            long ldim1;
            double sp1 = 1.0;
            double sp2 = 1.0;
            if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.SCALAR && mc[0].dimsKnown()) {
                ldim1 = mc[0].getRows();
                ldim2 = mc[0].getCols();
                sp1 = mc[0].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, mc[0].getNonZeros()) : 1.0;
            } else if (dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.MATRIX) {
                ldim1 = mc[1].getRows();
                ldim2 = mc[1].getCols();
                sp2 = mc[1].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, mc[1].getNonZeros()) : 1.0;
            } else {
                if (this.outer) {
                    ldim1 = mc[0].getRows();
                    ldim2 = mc[1].getCols();
                } else {
                    long l = mc[0].getRows() > 0L ? mc[0].getRows() : (ldim1 = mc[1].getRows() > 1L ? mc[1].getRows() : -1L);
                    ldim2 = mc[0].getCols() > 0L ? mc[0].getCols() : (mc[1].getCols() > 1L ? mc[1].getCols() : -1L);
                }
                sp1 = mc[0].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, mc[0].getNonZeros()) : 1.0;
                double d = sp2 = mc[1].getNonZeros() > 0L ? OptimizerUtils.getSparsity(ldim1, ldim2, mc[1].getNonZeros()) : 1.0;
            }
            if (ldim1 > 0L && ldim2 > 0L) {
                if (OptimizerUtils.isBinaryOpConditionalSparseSafe(this.op) && input2 instanceof LiteralOp) {
                    long lnnz = (long)((double)(ldim1 * ldim2) * OptimizerUtils.getBinaryOpSparsityConditionalSparseSafe(sp1, this.op, (LiteralOp)input2));
                    ret = new long[]{ldim1, ldim2, lnnz};
                } else {
                    long lnnz = (long)((double)(ldim1 * ldim2) * OptimizerUtils.getBinaryOpSparsity(sp1, sp2, this.op, !this.outer));
                    ret = new long[]{ldim1, ldim2, lnnz};
                }
            }
        }
        return ret;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        Expression.DataType dt1 = this.getInput().get(0).getDataType();
        Expression.DataType dt2 = this.getInput().get(1).getDataType();
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            if (OptimizerUtils.isMemoryBasedOptLevel()) {
                this._etype = this.findExecTypeByMemEstimate();
            } else {
                this._etype = null;
                if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.MATRIX) {
                    if (this.getInput().get(0).areDimsBelowThreshold() && this.getInput().get(1).areDimsBelowThreshold() || this.getInput().get(0).isVector() && this.getInput().get(1).isVector()) {
                        this._etype = LopProperties.ExecType.CP;
                    }
                } else if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.SCALAR) {
                    if (this.getInput().get(0).areDimsBelowThreshold() || this.getInput().get(0).isVector()) {
                        this._etype = LopProperties.ExecType.CP;
                    }
                } else if (dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.MATRIX) {
                    if (this.getInput().get(1).areDimsBelowThreshold() || this.getInput().get(1).isVector()) {
                        this._etype = LopProperties.ExecType.CP;
                    }
                } else {
                    this._etype = LopProperties.ExecType.CP;
                }
                if (this._etype == null) {
                    this._etype = REMOTE;
                }
            }
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this._etype == LopProperties.ExecType.CP && this._etypeForced != LopProperties.ExecType.CP && this.getDataType().isMatrix() && (dt1.isScalar() || dt2.isScalar()) && this.supportsMatrixScalarOperations() && !(this.getInput().get(dt1.isScalar() ? 1 : 0) instanceof DataOp) && this.getInput().get(dt1.isScalar() ? 1 : 0).getParent().size() == 1 && !HopRewriteUtils.isSingleBlock(this.getInput().get(dt1.isScalar() ? 1 : 0)) && this.getInput().get(dt1.isScalar() ? 1 : 0).optFindExecType() == LopProperties.ExecType.SPARK) {
            this._etype = LopProperties.ExecType.SPARK;
        }
        if (ConfigurationManager.isDynamicRecompilation() && !this.dimsKnown(true) && this._etype == REMOTE) {
            this.setRequiresRecompile();
        }
        if (this.op == Hop.OpOp2.SOLVE) {
            this._etype = LopProperties.ExecType.CP;
        }
        return this._etype;
    }

    public static Lop constructMRAppendLop(Hop left, Hop right, Expression.DataType dt, Expression.ValueType vt, boolean cbind, Hop current) throws HopsException, LopsException {
        long m3_dim1;
        Lop ret = null;
        long m1_dim1 = left.getDim1();
        long m1_dim2 = left.getDim2();
        long m2_dim1 = right.getDim1();
        long m2_dim2 = right.getDim2();
        long l = cbind ? m1_dim1 : (m3_dim1 = m1_dim1 > 0L && m2_dim1 > 0L ? m1_dim1 + m2_dim1 : -1L);
        long m3_dim2 = cbind ? (m1_dim2 > 0L && m2_dim2 > 0L ? m1_dim2 + m2_dim2 : -1L) : m1_dim2;
        long m3_nnz = left.getNnz() > 0L && right.getNnz() > 0L ? left.getNnz() + right.getNnz() : -1L;
        long brlen = left.getRowsInBlock();
        long bclen = left.getColsInBlock();
        Lop offset = BinaryOp.createOffsetLop(left, cbind);
        AppendMethod am = BinaryOp.optFindAppendMethod(m1_dim1, m1_dim2, m2_dim1, m2_dim2, brlen, bclen, cbind);
        switch (am) {
            case MR_MAPPEND: {
                boolean needPart = BinaryOp.requiresPartitioning(right);
                Lop dcInput = right.constructLops();
                if (needPart) {
                    LopProperties.ExecType etPart = (double)OptimizerUtils.estimateSizeExactSparsity(right.getDim1(), right.getDim2(), OptimizerUtils.getSparsity(right.getDim1(), right.getDim2(), right.getNnz())) < OptimizerUtils.getLocalMemBudget() ? LopProperties.ExecType.CP : LopProperties.ExecType.MR;
                    dcInput = new DataPartition(dcInput, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, etPart, ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N);
                    dcInput.getOutputParameters().setDimensions(right.getDim1(), right.getDim2(), right.getRowsInBlock(), right.getColsInBlock(), right.getNnz());
                    dcInput.setAllPositions(right.getBeginLine(), right.getBeginColumn(), right.getEndLine(), right.getEndColumn());
                }
                AppendM appM = new AppendM(left.constructLops(), dcInput, offset, dt, vt, cbind, needPart, LopProperties.ExecType.MR);
                appM.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
                appM.getOutputParameters().setDimensions(m3_dim1, m3_dim2, brlen, bclen, m3_nnz);
                ret = appM;
                break;
            }
            case MR_RAPPEND: {
                Group group1 = new Group(left.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, vt);
                group1.getOutputParameters().setDimensions(m1_dim1, m1_dim2, brlen, bclen, left.getNnz());
                group1.setAllPositions(left.getBeginLine(), left.getBeginColumn(), left.getEndLine(), left.getEndColumn());
                Group group2 = new Group(right.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, vt);
                group1.getOutputParameters().setDimensions(m2_dim1, m2_dim2, brlen, bclen, right.getNnz());
                group1.setAllPositions(right.getBeginLine(), right.getBeginColumn(), right.getEndLine(), right.getEndColumn());
                AppendR appR = new AppendR(group1, group2, dt, vt, cbind, LopProperties.ExecType.MR);
                appR.getOutputParameters().setDimensions(m3_dim1, m3_dim2, brlen, bclen, m3_nnz);
                appR.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
                ret = appR;
                break;
            }
            case MR_GAPPEND: {
                Lop offset2 = BinaryOp.createOffsetLop(right, cbind);
                AppendG appG = new AppendG(left.constructLops(), right.constructLops(), offset, offset2, dt, vt, cbind, LopProperties.ExecType.MR);
                appG.getOutputParameters().setDimensions(m3_dim1, m3_dim2, brlen, bclen, m3_nnz);
                appG.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
                Group group1 = new Group(appG, Group.OperationTypes.Sort, Expression.DataType.MATRIX, vt);
                group1.getOutputParameters().setDimensions(m3_dim1, m3_dim2, brlen, bclen, m3_nnz);
                group1.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
                Aggregate agg1 = new Aggregate(group1, Aggregate.OperationTypes.Sum, Expression.DataType.MATRIX, vt, LopProperties.ExecType.MR);
                agg1.getOutputParameters().setDimensions(m3_dim1, m3_dim2, brlen, bclen, m3_nnz);
                agg1.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
                ret = agg1;
                break;
            }
            default: {
                throw new HopsException("Invalid MR append method: " + (Object)((Object)am));
            }
        }
        return ret;
    }

    public static Lop constructSPAppendLop(Hop left, Hop right, Expression.DataType dt, Expression.ValueType vt, boolean cbind, Hop current) throws HopsException, LopsException {
        Lop ret = null;
        Lop offset = BinaryOp.createOffsetLop(left, cbind);
        AppendMethod am = BinaryOp.optFindAppendSPMethod(left.getDim1(), left.getDim2(), right.getDim1(), right.getDim2(), right.getRowsInBlock(), right.getColsInBlock(), right.getNnz(), cbind, dt);
        switch (am) {
            case MR_MAPPEND: {
                ret = new AppendM(left.constructLops(), right.constructLops(), offset, current.getDataType(), current.getValueType(), cbind, false, LopProperties.ExecType.SPARK);
                break;
            }
            case MR_RAPPEND: {
                ret = new AppendR(left.constructLops(), right.constructLops(), current.getDataType(), current.getValueType(), cbind, LopProperties.ExecType.SPARK);
                break;
            }
            case MR_GAPPEND: {
                Lop offset2 = BinaryOp.createOffsetLop(right, cbind);
                ret = new AppendG(left.constructLops(), right.constructLops(), offset, offset2, current.getDataType(), current.getValueType(), cbind, LopProperties.ExecType.SPARK);
                break;
            }
            case SP_GAlignedAppend: {
                ret = new AppendGAlignedSP(left.constructLops(), right.constructLops(), offset, current.getDataType(), current.getValueType(), cbind);
                break;
            }
            default: {
                throw new HopsException("Invalid SP append method: " + (Object)((Object)am));
            }
        }
        ret.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
        return ret;
    }

    public static Lop constructAppendLopChain(Hop left, Hop right1, Hop right2, Expression.DataType dt, Expression.ValueType vt, boolean cbind, Hop current) throws HopsException, LopsException {
        long m1_dim1 = left.getDim1();
        long m1_dim2 = left.getDim2();
        long m2_dim1 = right1.getDim1();
        long m2_dim2 = right1.getDim2();
        long m3_dim1 = right2.getDim1();
        long m3_dim2 = right2.getDim2();
        long m41_dim2 = m1_dim2 > 0L && m2_dim2 > 0L ? m1_dim2 + m2_dim2 : -1L;
        long m41_nnz = left.getNnz() > 0L && right1.getNnz() > 0L ? left.getNnz() + right1.getNnz() : -1L;
        long m42_dim2 = m1_dim2 > 0L && m2_dim2 > 0L && m3_dim2 > 0L ? m1_dim2 + m2_dim2 + m3_dim2 : -1L;
        long m42_nnz = left.getNnz() > 0L && right1.getNnz() > 0L && right2.getNnz() > 0L ? left.getNnz() + right1.getNnz() + right2.getNnz() : -1L;
        long brlen = left.getRowsInBlock();
        long bclen = left.getColsInBlock();
        if (bclen < 3L) {
            throw new HopsException("MR_RAPPEND requires a blocksize of >= 3.");
        }
        Group group1 = new Group(left.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, vt);
        group1.getOutputParameters().setDimensions(m1_dim1, m1_dim2, brlen, bclen, left.getNnz());
        group1.setAllPositions(left.getBeginLine(), left.getBeginColumn(), left.getEndLine(), left.getEndColumn());
        Group group2 = new Group(right1.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, vt);
        group1.getOutputParameters().setDimensions(m2_dim1, m2_dim2, brlen, bclen, right1.getNnz());
        group1.setAllPositions(right1.getBeginLine(), right1.getBeginColumn(), right1.getEndLine(), right1.getEndColumn());
        Group group3 = new Group(right2.constructLops(), Group.OperationTypes.Sort, Expression.DataType.MATRIX, vt);
        group1.getOutputParameters().setDimensions(m3_dim1, m3_dim2, brlen, bclen, right2.getNnz());
        group1.setAllPositions(right2.getBeginLine(), right2.getBeginColumn(), right2.getEndLine(), right2.getEndColumn());
        AppendR appR1 = new AppendR(group1, group2, dt, vt, cbind, LopProperties.ExecType.MR);
        appR1.getOutputParameters().setDimensions(m1_dim1, m41_dim2, brlen, bclen, m41_nnz);
        appR1.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
        AppendR appR2 = new AppendR(appR1, group3, dt, vt, cbind, LopProperties.ExecType.MR);
        appR1.getOutputParameters().setDimensions(m1_dim1, m42_dim2, brlen, bclen, m42_nnz);
        appR1.setAllPositions(current.getBeginLine(), current.getBeginColumn(), current.getEndLine(), current.getEndColumn());
        return appR2;
    }

    public static double footprintInMapper(long m1_dim1, long m1_dim2, long m2_dim1, long m2_dim2, long m1_rpb, long m1_cpb) {
        double footprint = 0.0;
        footprint += (double)OptimizerUtils.estimateSize(Math.min(m1_dim1, m1_rpb), Math.min(m1_dim2, m1_cpb));
        footprint += (double)OptimizerUtils.estimateSize(m2_dim1, m2_dim2);
        return footprint += (double)OptimizerUtils.estimateSize(Math.min(m1_dim1, m1_rpb), Math.min(m1_dim2 + m2_dim2, m1_cpb));
    }

    private static AppendMethod optFindAppendMethod(long m1_dim1, long m1_dim2, long m2_dim1, long m2_dim2, long m1_rpb, long m1_cpb, boolean cbind) {
        double footprint;
        if (FORCED_APPEND_METHOD != null) {
            return FORCED_APPEND_METHOD;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && (cbind && m2_dim2 <= m1_cpb || !cbind && m2_dim1 <= m1_rpb) && (footprint = BinaryOp.footprintInMapper(m1_dim1, m1_dim2, m2_dim1, m2_dim2, m1_rpb, m1_cpb)) < 1.0 * OptimizerUtils.getRemoteMemBudgetMap(true)) {
            return AppendMethod.MR_MAPPEND;
        }
        if (cbind && m1_dim2 >= 1L && m2_dim2 >= 0L && m1_dim2 + m2_dim2 <= m1_cpb || !cbind && m1_dim1 >= 1L && m2_dim1 >= 0L && m1_dim1 + m2_dim1 <= m1_rpb) {
            return AppendMethod.MR_RAPPEND;
        }
        return AppendMethod.MR_GAPPEND;
    }

    private static AppendMethod optFindAppendSPMethod(long m1_dim1, long m1_dim2, long m2_dim1, long m2_dim2, long m1_rpb, long m1_cpb, long m2_nnz, boolean cbind, Expression.DataType dt) {
        if (FORCED_APPEND_METHOD != null) {
            return FORCED_APPEND_METHOD;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && (cbind && m2_dim2 <= m1_cpb || !cbind && m2_dim1 <= m1_rpb) && (dt == Expression.DataType.MATRIX || dt == Expression.DataType.FRAME && cbind) && OptimizerUtils.checkSparkBroadcastMemoryBudget(m2_dim1, m2_dim2, m1_rpb, m1_cpb, m2_nnz)) {
            return AppendMethod.MR_MAPPEND;
        }
        if (cbind && m1_dim2 >= 1L && m2_dim2 >= 0L && m1_dim2 + m2_dim2 <= m1_cpb || !cbind && m1_dim1 >= 1L && m2_dim1 >= 0L && m1_dim1 + m2_dim1 <= m1_rpb || dt == Expression.DataType.FRAME) {
            return AppendMethod.MR_RAPPEND;
        }
        if (cbind && m1_dim2 % m1_cpb == 0L || !cbind && m1_dim1 % m1_rpb == 0L) {
            return AppendMethod.SP_GAlignedAppend;
        }
        return AppendMethod.MR_GAPPEND;
    }

    private static boolean requiresPartitioning(Hop rightInput) {
        return rightInput.dimsKnown() && rightInput.getDim1() * rightInput.getDim2() > 4000000L;
    }

    public static boolean requiresReplication(Hop left, Hop right) {
        return left.getDim2() < 1L || right.getDim2() < 1L || left.getDim2() > 1L && right.getDim2() == 1L && left.getDim2() >= left.getColsInBlock() || left.getDim1() > 1L && right.getDim1() == 1L && left.getDim1() >= left.getRowsInBlock();
    }

    private MMBinaryMethod optFindMMBinaryMethodSpark(Hop left, Hop right) {
        double size;
        long m1_dim1 = left.getDim1();
        long m1_dim2 = left.getDim2();
        long m2_dim1 = right.getDim1();
        long m2_dim2 = right.getDim2();
        long m1_rpb = left.getRowsInBlock();
        long m1_cpb = left.getColsInBlock();
        if (right instanceof AggUnaryOp && right.getInput().get(0) == left && (((AggUnaryOp)right).getDirection() == Hop.Direction.Row && m1_dim2 > 1L && m1_dim2 <= m1_cpb || ((AggUnaryOp)right).getDirection() == Hop.Direction.Col && m1_dim1 > 1L && m1_dim1 <= m1_rpb)) {
            return MMBinaryMethod.MR_BINARY_UAGG_CHAIN;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && (m1_dim2 >= 1L && m2_dim2 == 1L || m1_dim1 >= 1L && m2_dim1 == 1L) && OptimizerUtils.checkSparkBroadcastMemoryBudget(size = (double)OptimizerUtils.estimateSize(m2_dim1, m2_dim2))) {
            return MMBinaryMethod.MR_BINARY_M;
        }
        return MMBinaryMethod.MR_BINARY_R;
    }

    private MMBinaryMethod optFindMMBinaryMethod(Hop left, Hop right) {
        double footprint;
        long m1_dim1 = left.getDim1();
        long m1_dim2 = left.getDim2();
        long m2_dim1 = right.getDim1();
        long m2_dim2 = right.getDim2();
        long m1_rpb = left.getRowsInBlock();
        long m1_cpb = left.getColsInBlock();
        if (this.outer) {
            return MMBinaryMethod.MR_BINARY_OUTER_R;
        }
        if (right instanceof AggUnaryOp && right.getInput().get(0) == left && (((AggUnaryOp)right).getDirection() == Hop.Direction.Row && m1_dim2 > 1L && m1_dim2 <= m1_cpb || ((AggUnaryOp)right).getDirection() == Hop.Direction.Col && m1_dim1 > 1L && m1_dim1 <= m1_rpb)) {
            return MMBinaryMethod.MR_BINARY_UAGG_CHAIN;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && (m1_dim2 > 1L && m2_dim2 == 1L || m1_dim1 > 1L && m2_dim1 == 1L) && (footprint = BinaryOp.footprintInMapper(m1_dim1, m1_dim2, m2_dim1, m2_dim2, m1_rpb, m1_cpb)) < OptimizerUtils.getRemoteMemBudgetMap(true)) {
            return MMBinaryMethod.MR_BINARY_M;
        }
        return MMBinaryMethod.MR_BINARY_R;
    }

    @Override
    public void refreshSizeInformation() {
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        Expression.DataType dt1 = input1.getDataType();
        Expression.DataType dt2 = input2.getDataType();
        if (this.getDataType() == Expression.DataType.SCALAR) {
            this.setDim1(0L);
            this.setDim2(0L);
        } else if (this.op == Hop.OpOp2.CBIND) {
            this.setDim1(input1.getDim1() > 0L ? input1.getDim1() : input2.getDim1());
            if (input1.getDim2() > 0L && input2.getDim2() > 0L) {
                this.setDim2(input1.getDim2() + input2.getDim2());
            } else {
                this.setDim2(-1L);
            }
            if (input1.getNnz() > 0L && input2.getNnz() > 0L) {
                this.setNnz(input1.getNnz() + input2.getNnz());
            } else {
                this.setNnz(-1L);
            }
        } else if (this.op == Hop.OpOp2.RBIND) {
            this.setDim2(input1.getDim2() > 0L ? input1.getDim2() : input2.getDim2());
            if (input1.getDim1() > 0L && input2.getDim1() > 0L) {
                this.setDim1(input1.getDim1() + input2.getDim1());
            } else {
                this.setDim1(-1L);
            }
            if (input1.getNnz() > 0L && input2.getNnz() > 0L) {
                this.setNnz(input1.getNnz() + input2.getNnz());
            } else {
                this.setNnz(-1L);
            }
        } else if (this.op == Hop.OpOp2.SOLVE) {
            this.setDim1(input1.getDim2());
            this.setDim2(input2.getDim2());
        } else {
            long ldim2;
            long ldim1;
            long lnnz1 = -1L;
            if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.SCALAR) {
                ldim1 = input1.getDim1();
                ldim2 = input1.getDim2();
                lnnz1 = input1.getNnz();
            } else if (dt1 == Expression.DataType.SCALAR && dt2 == Expression.DataType.MATRIX) {
                ldim1 = input2.getDim1();
                ldim2 = input2.getDim2();
            } else if (this.outer) {
                ldim1 = input1.getDim1();
                ldim2 = input2.getDim2();
            } else {
                long l = input1.getDim1() > 0L ? input1.getDim1() : (ldim1 = input2.getDim1() > 1L ? input2.getDim1() : -1L);
                ldim2 = input1.getDim2() > 0L ? input1.getDim2() : (input2.getDim2() > 1L ? input2.getDim2() : -1L);
                lnnz1 = input1.getNnz();
            }
            this.setDim1(ldim1);
            this.setDim2(ldim2);
            if (this.op == Hop.OpOp2.POW || input2 instanceof LiteralOp && OptimizerUtils.isBinaryOpConditionalSparseSafeExact(this.op, (LiteralOp)input2)) {
                this.setNnz(lnnz1);
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BinaryOp ret = new BinaryOp();
        ret.clone(this, false);
        ret.op = this.op;
        ret.outer = this.outer;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof BinaryOp)) {
            return false;
        }
        BinaryOp that2 = (BinaryOp)that;
        return this.op == that2.op && this.outer == that2.outer && this.getInput().get(0) == that2.getInput().get(0) && this.getInput().get(1) == that2.getInput().get(1);
    }

    public boolean supportsMatrixScalarOperations() {
        return this.op == Hop.OpOp2.PLUS || this.op == Hop.OpOp2.MINUS || this.op == Hop.OpOp2.MULT || this.op == Hop.OpOp2.DIV || this.op == Hop.OpOp2.MODULUS || this.op == Hop.OpOp2.INTDIV || this.op == Hop.OpOp2.LESS || this.op == Hop.OpOp2.LESSEQUAL || this.op == Hop.OpOp2.GREATER || this.op == Hop.OpOp2.GREATEREQUAL || this.op == Hop.OpOp2.EQUAL || this.op == Hop.OpOp2.NOTEQUAL || this.op == Hop.OpOp2.MIN || this.op == Hop.OpOp2.MAX || this.op == Hop.OpOp2.AND || this.op == Hop.OpOp2.OR || this.op == Hop.OpOp2.LOG || this.op == Hop.OpOp2.POW;
    }

    public boolean isPPredOperation() {
        return this.op == Hop.OpOp2.LESS || this.op == Hop.OpOp2.LESSEQUAL || this.op == Hop.OpOp2.GREATER || this.op == Hop.OpOp2.GREATEREQUAL || this.op == Hop.OpOp2.EQUAL || this.op == Hop.OpOp2.NOTEQUAL;
    }

    private static enum MMBinaryMethod {
        CP_BINARY,
        MR_BINARY_R,
        MR_BINARY_M,
        MR_BINARY_OUTER_M,
        MR_BINARY_OUTER_R,
        MR_BINARY_UAGG_CHAIN;

    }

    public static enum AppendMethod {
        CP_APPEND,
        MR_MAPPEND,
        MR_RAPPEND,
        MR_GAPPEND,
        SP_GAlignedAppend;

    }
}

