/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.debug;

import java.util.Stack;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DMLFrame;
import org.apache.sysml.debug.DMLProgramCounter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;

public class DebugState {
    public String[] dmlScript;
    public Stack<DMLFrame> callStack = new Stack();
    public DMLProgramCounter pc = null;
    public DMLProgramCounter prevPC = null;
    public LocalVariableMap frameVariables = null;
    public String dbCommand = null;
    public String dbCommandArg = null;
    public boolean suspend = false;
    public volatile boolean nextCommand = false;
    private static DebugState instance = null;

    protected DebugState() {
    }

    public static DebugState getInstance() {
        return instance;
    }

    public DMLProgramCounter getPC() throws DMLRuntimeException {
        if (!DMLScript.ENABLE_DEBUG_MODE) {
            System.err.println("Error: This functionality (getPC) is available only in debug mode");
            throw new DMLRuntimeException("Error: This functionality (getPC) is available only in debug mode");
        }
        return this.pc;
    }

    public LocalVariableMap getVariables() {
        return this.frameVariables;
    }

    public DMLFrame getCurrentFrame() {
        DMLFrame frame = new DMLFrame(this.frameVariables, this.pc);
        return frame;
    }

    public void setVariables(LocalVariableMap vars) {
        this.frameVariables = vars;
    }

    public boolean canAcceptNextCommand() {
        return this.nextCommand;
    }

    public void setDMLScript(String[] lines) {
        this.dmlScript = lines;
    }

    public void printDMLSourceLine(int lineNum) {
        if (lineNum > 0 && lineNum < this.dmlScript.length) {
            System.out.format("%-4d %s\n", lineNum, this.dmlScript[lineNum - 1]);
        }
    }

    public void setCommand(String command) {
        this.dbCommand = command;
    }

    public void setCommandArg(String cmdArg) {
        this.dbCommandArg = cmdArg;
    }

    public void pushFrame(LocalVariableMap vars, DMLProgramCounter pc) {
        this.callStack.push(new DMLFrame(vars, pc));
    }

    public DMLFrame popFrame() {
        if (this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack.pop();
    }

    public Stack<DMLFrame> getCallStack() {
        if (this.callStack.isEmpty()) {
            return null;
        }
        return this.callStack;
    }

    public void getDMLStackTrace(Exception e) {
        System.err.format("Runtime exception raised %s\n", e.toString());
        System.err.println("\t at " + this.pc.toString());
        if (this.callStack != null) {
            for (int i = this.callStack.size(); i > 0; --i) {
                DMLFrame frame = (DMLFrame)this.callStack.get(i - 1);
                System.err.println("\t at " + frame.getPC().toString());
            }
        }
    }

    static {
        instance = new DebugState();
    }
}

