/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.conf;

import java.util.HashMap;
import org.apache.sysml.hops.OptimizerUtils;

public class CompilerConfig {
    public static boolean FLAG_DYN_RECOMPILE = true;
    public static boolean FLAG_PARREADWRITE_TEXT = true;
    public static boolean FLAG_PARREADWRITE_BINARY = true;
    private HashMap<ConfigType, Boolean> _bmap = null;
    private HashMap<ConfigType, Integer> _imap = null;

    public CompilerConfig() {
        this._bmap = new HashMap();
        this._bmap.put(ConfigType.PARALLEL_CP_READ_TEXTFORMATS, FLAG_PARREADWRITE_TEXT);
        this._bmap.put(ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS, FLAG_PARREADWRITE_TEXT);
        this._bmap.put(ConfigType.PARALLEL_CP_READ_BINARYFORMATS, FLAG_PARREADWRITE_BINARY);
        this._bmap.put(ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS, FLAG_PARREADWRITE_BINARY);
        this._bmap.put(ConfigType.PARALLEL_CP_MATRIX_OPERATIONS, true);
        this._bmap.put(ConfigType.PARALLEL_LOCAL_OR_REMOTE_PARFOR, true);
        this._bmap.put(ConfigType.ALLOW_DYN_RECOMPILATION, FLAG_DYN_RECOMPILE);
        this._bmap.put(ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION, FLAG_DYN_RECOMPILE);
        this._bmap.put(ConfigType.ALLOW_INDIVIDUAL_SB_SPECIFIC_OPS, FLAG_DYN_RECOMPILE);
        this._bmap.put(ConfigType.ALLOW_CSE_PERSISTENT_READS, true);
        this._bmap.put(ConfigType.IGNORE_UNSPECIFIED_ARGS, false);
        this._bmap.put(ConfigType.IGNORE_READ_WRITE_METADATA, false);
        this._bmap.put(ConfigType.REJECT_READ_WRITE_UNKNOWNS, true);
        this._bmap.put(ConfigType.MLCONTEXT, false);
        this._imap = new HashMap();
        this._imap.put(ConfigType.BLOCK_SIZE, 1000);
        this._imap.put(ConfigType.OPT_LEVEL, OptimizerUtils.DEFAULT_OPTLEVEL.ordinal());
    }

    public CompilerConfig(CompilerConfig conf) {
        this._bmap = (HashMap)conf._bmap.clone();
        this._imap = (HashMap)conf._imap.clone();
    }

    public void set(ConfigType key, boolean value) {
        this._bmap.put(key, value);
    }

    public void set(ConfigType key, int value) {
        this._imap.put(key, value);
    }

    public boolean getBool(ConfigType key) {
        if (this._bmap.containsKey((Object)key)) {
            return this._bmap.get((Object)key);
        }
        return false;
    }

    public int getInt(ConfigType key) {
        if (this._imap.containsKey((Object)key)) {
            return this._imap.get((Object)key);
        }
        return -1;
    }

    public CompilerConfig clone() {
        return new CompilerConfig(this);
    }

    public static enum ConfigType {
        OPT_LEVEL,
        BLOCK_SIZE,
        PARALLEL_CP_READ_TEXTFORMATS,
        PARALLEL_CP_WRITE_TEXTFORMATS,
        PARALLEL_CP_READ_BINARYFORMATS,
        PARALLEL_CP_WRITE_BINARYFORMATS,
        PARALLEL_CP_MATRIX_OPERATIONS,
        PARALLEL_LOCAL_OR_REMOTE_PARFOR,
        ALLOW_DYN_RECOMPILATION,
        ALLOW_PARALLEL_DYN_RECOMPILATION,
        ALLOW_INDIVIDUAL_SB_SPECIFIC_OPS,
        ALLOW_CSE_PERSISTENT_READS,
        IGNORE_UNSPECIFIED_ARGS,
        IGNORE_READ_WRITE_METADATA,
        REJECT_READ_WRITE_UNKNOWNS,
        MLCONTEXT;

    }
}

