/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.mlcontext.MLContextException;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.util.LocalFileUtils;

public class ScriptFactory {
    public static Script dmlFromFile(String scriptFilePath) {
        return ScriptFactory.scriptFromFile(scriptFilePath, ScriptType.DML);
    }

    public static Script dmlFromInputStream(InputStream inputStream) {
        return ScriptFactory.scriptFromInputStream(inputStream, ScriptType.DML);
    }

    public static Script dmlFromLocalFile(File localScriptFile) {
        return ScriptFactory.scriptFromLocalFile(localScriptFile, ScriptType.DML);
    }

    public static Script dmlFromString(String scriptString) {
        return ScriptFactory.scriptFromString(scriptString, ScriptType.DML);
    }

    public static Script dmlFromUrl(String scriptUrlPath) {
        return ScriptFactory.scriptFromUrl(scriptUrlPath, ScriptType.DML);
    }

    public static Script dmlFromUrl(URL scriptUrl) {
        return ScriptFactory.scriptFromUrl(scriptUrl, ScriptType.DML);
    }

    public static Script dmlFromResource(String resourcePath) {
        return ScriptFactory.scriptFromResource(resourcePath, ScriptType.DML);
    }

    public static Script pydmlFromFile(String scriptFilePath) {
        return ScriptFactory.scriptFromFile(scriptFilePath, ScriptType.PYDML);
    }

    public static Script pydmlFromInputStream(InputStream inputStream) {
        return ScriptFactory.scriptFromInputStream(inputStream, ScriptType.PYDML);
    }

    public static Script pydmlFromLocalFile(File localScriptFile) {
        return ScriptFactory.scriptFromLocalFile(localScriptFile, ScriptType.PYDML);
    }

    public static Script pydmlFromString(String scriptString) {
        return ScriptFactory.scriptFromString(scriptString, ScriptType.PYDML);
    }

    public static Script pydmlFromUrl(String scriptUrlPath) {
        return ScriptFactory.scriptFromUrl(scriptUrlPath, ScriptType.PYDML);
    }

    public static Script pydmlFromUrl(URL scriptUrl) {
        return ScriptFactory.scriptFromUrl(scriptUrl, ScriptType.PYDML);
    }

    public static Script pydmlFromResource(String resourcePath) {
        return ScriptFactory.scriptFromResource(resourcePath, ScriptType.PYDML);
    }

    private static Script scriptFromFile(String scriptFilePath, ScriptType scriptType) {
        String scriptString = ScriptFactory.getScriptStringFromFile(scriptFilePath);
        return ScriptFactory.scriptFromString(scriptString, scriptType).setName(scriptFilePath);
    }

    private static Script scriptFromInputStream(InputStream inputStream, ScriptType scriptType) {
        String scriptString = ScriptFactory.getScriptStringFromInputStream(inputStream);
        return ScriptFactory.scriptFromString(scriptString, scriptType);
    }

    private static Script scriptFromLocalFile(File localScriptFile, ScriptType scriptType) {
        String scriptString = ScriptFactory.getScriptStringFromFile(localScriptFile);
        return ScriptFactory.scriptFromString(scriptString, scriptType).setName(localScriptFile.getName());
    }

    private static Script scriptFromString(String scriptString, ScriptType scriptType) {
        return new Script(scriptString, scriptType);
    }

    private static Script scriptFromUrl(String scriptUrlPath, ScriptType scriptType) {
        String scriptString = ScriptFactory.getScriptStringFromUrl(scriptUrlPath);
        return ScriptFactory.scriptFromString(scriptString, scriptType).setName(scriptUrlPath);
    }

    private static Script scriptFromUrl(URL scriptUrl, ScriptType scriptType) {
        String scriptString = ScriptFactory.getScriptStringFromUrl(scriptUrl);
        return ScriptFactory.scriptFromString(scriptString, scriptType).setName(scriptUrl.toString());
    }

    private static Script scriptFromResource(String resourcePath, ScriptType scriptType) {
        InputStream inputStream = ScriptFactory.class.getResourceAsStream(resourcePath);
        return ScriptFactory.scriptFromInputStream(inputStream, scriptType).setName(resourcePath);
    }

    public static Script dml(String scriptString) {
        return ScriptFactory.dmlFromString(scriptString);
    }

    private static String getScriptStringFromFile(File file) {
        if (file == null) {
            throw new MLContextException("Script file is null");
        }
        String filePath = file.getPath();
        try {
            if (!LocalFileUtils.validateExternalFilename(filePath, false)) {
                throw new MLContextException("Invalid (non-trustworthy) local filename: " + filePath);
            }
            String scriptString = FileUtils.readFileToString((File)file);
            return scriptString;
        }
        catch (IllegalArgumentException e) {
            throw new MLContextException("Error trying to read script string from file: " + filePath, e);
        }
        catch (IOException e) {
            throw new MLContextException("Error trying to read script string from file: " + filePath, e);
        }
    }

    private static String getScriptStringFromFile(String scriptFilePath) {
        if (scriptFilePath == null) {
            throw new MLContextException("Script file path is null");
        }
        try {
            if (scriptFilePath.startsWith("hdfs:") || scriptFilePath.startsWith("gpfs:")) {
                if (!LocalFileUtils.validateExternalFilename(scriptFilePath, true)) {
                    throw new MLContextException("Invalid (non-trustworthy) hdfs/gpfs filename: " + scriptFilePath);
                }
                FileSystem fs = FileSystem.get((Configuration)ConfigurationManager.getCachedJobConf());
                Path path = new Path(scriptFilePath);
                FSDataInputStream fsdis = fs.open(path);
                return IOUtils.toString((InputStream)fsdis);
            }
            if (!LocalFileUtils.validateExternalFilename(scriptFilePath, false)) {
                throw new MLContextException("Invalid (non-trustworthy) local filename: " + scriptFilePath);
            }
            File scriptFile = new File(scriptFilePath);
            return FileUtils.readFileToString((File)scriptFile);
        }
        catch (IllegalArgumentException e) {
            throw new MLContextException("Error trying to read script string from file: " + scriptFilePath, e);
        }
        catch (IOException e) {
            throw new MLContextException("Error trying to read script string from file: " + scriptFilePath, e);
        }
    }

    private static String getScriptStringFromInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new MLContextException("InputStream is null");
        }
        try {
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new MLContextException("Error trying to read script string from InputStream", e);
        }
    }

    private static String getScriptStringFromUrl(String scriptUrlPath) {
        if (scriptUrlPath == null) {
            throw new MLContextException("Script URL path is null");
        }
        try {
            URL url = new URL(scriptUrlPath);
            return ScriptFactory.getScriptStringFromUrl(url);
        }
        catch (MalformedURLException e) {
            throw new MLContextException("Error trying to read script string from URL path: " + scriptUrlPath, e);
        }
    }

    private static String getScriptStringFromUrl(URL url) {
        if (url == null) {
            throw new MLContextException("URL is null");
        }
        String urlString = url.toString();
        if (!urlString.toLowerCase().startsWith("http:") && !urlString.toLowerCase().startsWith("https:")) {
            throw new MLContextException("Currently only reading from http and https URLs is supported");
        }
        try {
            InputStream is = url.openStream();
            return IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            throw new MLContextException("Error trying to read script string from URL: " + url, e);
        }
    }

    public static Script pydml(String scriptString) {
        return ScriptFactory.pydmlFromString(scriptString);
    }
}

