/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sysml.api.mlcontext.MLContextException;
import org.apache.sysml.api.mlcontext.MLContextUtil;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Metadata;
import org.apache.sysml.api.mlcontext.ScriptExecutor;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.instructions.cp.Data;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

public class Script {
    private ScriptType scriptType;
    private String scriptString;
    private String name;
    private java.util.Map<String, Object> inputs = new LinkedHashMap<String, Object>();
    private java.util.Map<String, Object> inputParameters = new LinkedHashMap<String, Object>();
    private Set<String> inputVariables = new LinkedHashSet<String>();
    private java.util.Map<String, Metadata> inputMetadata = new LinkedHashMap<String, Metadata>();
    private Set<String> outputVariables = new LinkedHashSet<String>();
    private LocalVariableMap symbolTable = new LocalVariableMap();
    private ScriptExecutor scriptExecutor;
    private MLResults results;

    public Script() {
        this.scriptType = ScriptType.DML;
    }

    public Script(ScriptType scriptType) {
        this.scriptType = scriptType;
    }

    public Script(String scriptString) {
        this.scriptString = scriptString;
        this.scriptType = ScriptType.DML;
    }

    public Script(String scriptString, ScriptType scriptType) {
        this.scriptString = scriptString;
        this.scriptType = scriptType;
    }

    public ScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
    }

    public String getScriptString() {
        return this.scriptString;
    }

    public Script setScriptString(String scriptString) {
        this.scriptString = scriptString;
        return this;
    }

    public Set<String> getInputVariables() {
        return Collections.unmodifiableSet(this.inputVariables);
    }

    public Set<String> getOutputVariables() {
        return Collections.unmodifiableSet(this.outputVariables);
    }

    public LocalVariableMap getSymbolTable() {
        return this.symbolTable;
    }

    public java.util.Map<String, Object> getInputs() {
        return Collections.unmodifiableMap(this.inputs);
    }

    public java.util.Map<String, Metadata> getInputMetadata() {
        return Collections.unmodifiableMap(this.inputMetadata);
    }

    public Script in(java.util.Map<String, Object> inputs) {
        for (Map.Entry<String, Object> input : inputs.entrySet()) {
            this.in(input.getKey(), input.getValue());
        }
        return this;
    }

    public Script in(Map<String, ?> inputs) {
        java.util.Map javaMap = JavaConversions.mapAsJavaMap(inputs);
        this.in(javaMap);
        return this;
    }

    public Script in(Seq<Object> inputs) {
        List list = JavaConversions.seqAsJavaList(inputs);
        for (Object obj : list) {
            if (obj instanceof Tuple3) {
                Tuple3 t3 = (Tuple3)obj;
                this.in((String)t3._1(), t3._2(), (Metadata)t3._3());
                continue;
            }
            if (obj instanceof Tuple2) {
                Tuple2 t2 = (Tuple2)obj;
                this.in((String)t2._1(), t2._2());
                continue;
            }
            throw new MLContextException("Only Tuples of 2 or 3 values are permitted");
        }
        return this;
    }

    public java.util.Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    public Script in(String name, Object value) {
        return this.in(name, value, null);
    }

    public Script in(String name, Object value, Metadata metadata) {
        if (value != null && value instanceof Long) {
            Long lng = (Long)value;
            value = lng.intValue();
        } else if (value != null && value instanceof Float) {
            Float flt = (Float)value;
            value = flt.doubleValue();
        }
        MLContextUtil.checkInputValueType(name, value);
        if (this.inputs == null) {
            this.inputs = new LinkedHashMap<String, Object>();
        }
        this.inputs.put(name, value);
        if (name.startsWith("$")) {
            MLContextUtil.checkInputParameterType(name, value);
            if (this.inputParameters == null) {
                this.inputParameters = new LinkedHashMap<String, Object>();
            }
            this.inputParameters.put(name, value);
        } else {
            Data data = MLContextUtil.convertInputType(name, value, metadata);
            if (data != null) {
                this.symbolTable.put(name, data);
                this.inputVariables.add(name);
                if (data instanceof CacheableData) {
                    if (metadata != null) {
                        this.inputMetadata.put(name, metadata);
                    }
                    ((CacheableData)data).enableCleanup(false);
                }
            }
        }
        return this;
    }

    public Script out(String outputName) {
        this.outputVariables.add(outputName);
        return this;
    }

    public Script out(String ... outputNames) {
        this.outputVariables.addAll(Arrays.asList(outputNames));
        return this;
    }

    public void clearIOS() {
        this.clearInputs();
        this.clearOutputs();
        this.clearSymbolTable();
    }

    public void clearIO() {
        this.clearInputs();
        this.clearOutputs();
    }

    public void clearAll() {
        this.scriptString = null;
        this.clearIOS();
    }

    public void clearInputs() {
        this.inputs.clear();
        this.inputParameters.clear();
        this.inputVariables.clear();
        this.inputMetadata.clear();
    }

    public void clearOutputs() {
        this.outputVariables.clear();
    }

    public void clearSymbolTable() {
        this.symbolTable.removeAll();
    }

    public MLResults results() {
        return this.results;
    }

    public MLResults getResults() {
        return this.results;
    }

    public void setResults(MLResults results) {
        this.results = results;
    }

    public ScriptExecutor getScriptExecutor() {
        return this.scriptExecutor;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public boolean isDML() {
        return this.scriptType.isDML();
    }

    public boolean isPYDML() {
        return this.scriptType.isPYDML();
    }

    public String getScriptExecutionString() {
        StringBuilder sb = new StringBuilder();
        Set<String> ins = this.getInputVariables();
        for (String in : ins) {
            String quotedString;
            Object inValue = this.getInputs().get(in);
            sb.append(in);
            if (this.isDML()) {
                if (inValue instanceof String) {
                    quotedString = MLContextUtil.quotedString((String)inValue);
                    sb.append(" = " + quotedString + ";\n");
                    continue;
                }
                if (MLContextUtil.isBasicType(inValue)) {
                    sb.append(" = read('', data_type='scalar', value_type='" + MLContextUtil.getBasicTypeString(inValue) + "');\n");
                    continue;
                }
                if (MLContextUtil.doesSymbolTableContainFrameObject(this.symbolTable, in)) {
                    sb.append(" = read('', data_type='frame');\n");
                    continue;
                }
                sb.append(" = read('');\n");
                continue;
            }
            if (!this.isPYDML()) continue;
            if (inValue instanceof String) {
                quotedString = MLContextUtil.quotedString((String)inValue);
                sb.append(" = " + quotedString + "\n");
                continue;
            }
            if (MLContextUtil.isBasicType(inValue)) {
                sb.append(" = load('', data_type='scalar', value_type='" + MLContextUtil.getBasicTypeString(inValue) + "')\n");
                continue;
            }
            if (MLContextUtil.doesSymbolTableContainFrameObject(this.symbolTable, in)) {
                sb.append(" = load('', data_type='frame')\n");
                continue;
            }
            sb.append(" = load('')\n");
        }
        sb.append(this.getScriptString());
        if (!this.getScriptString().endsWith("\n")) {
            sb.append("\n");
        }
        Set<String> outs = this.getOutputVariables();
        for (String out : outs) {
            if (this.isDML()) {
                sb.append("write(");
                sb.append(out);
                sb.append(", '');\n");
                continue;
            }
            if (!this.isPYDML()) continue;
            sb.append("save(");
            sb.append(out);
            sb.append(", '')\n");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MLContextUtil.displayInputs("Inputs", this.inputs, this.symbolTable));
        sb.append("\n");
        sb.append(MLContextUtil.displayOutputs("Outputs", this.outputVariables, this.symbolTable));
        return sb.toString();
    }

    public String info() {
        StringBuilder sb = new StringBuilder();
        sb.append("Script Type: ");
        sb.append((Object)this.scriptType);
        sb.append("\n\n");
        sb.append(MLContextUtil.displayInputs("Inputs", this.inputs, this.symbolTable));
        sb.append("\n");
        sb.append(MLContextUtil.displayOutputs("Outputs", this.outputVariables, this.symbolTable));
        sb.append("\n");
        sb.append(MLContextUtil.displayMap("Input Parameters", this.inputParameters));
        sb.append("\n");
        sb.append(MLContextUtil.displaySet("Input Variables", this.inputVariables));
        sb.append("\n");
        sb.append(MLContextUtil.displaySet("Output Variables", this.outputVariables));
        sb.append("\n");
        sb.append(MLContextUtil.displaySymbolTable("Symbol Table", this.symbolTable));
        sb.append("\nScript String:\n");
        sb.append(this.scriptString);
        sb.append("\nScript Execution String:\n");
        sb.append(this.getScriptExecutionString());
        sb.append("\n");
        return sb.toString();
    }

    public String displayInputs() {
        return MLContextUtil.displayInputs("Inputs", this.inputs, this.symbolTable);
    }

    public String displayOutputs() {
        return MLContextUtil.displayOutputs("Outputs", this.outputVariables, this.symbolTable);
    }

    public String displayInputParameters() {
        return MLContextUtil.displayMap("Input Parameters", this.inputParameters);
    }

    public String displayInputVariables() {
        return MLContextUtil.displaySet("Input Variables", this.inputVariables);
    }

    public String displayOutputVariables() {
        return MLContextUtil.displaySet("Output Variables", this.outputVariables);
    }

    public String displaySymbolTable() {
        return MLContextUtil.displaySymbolTable("Symbol Table", this.symbolTable);
    }

    public String getName() {
        return this.name;
    }

    public Script setName(String name) {
        this.name = name;
        return this;
    }
}

