/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.sysml.api.mlcontext.BinaryBlockFrame;
import org.apache.sysml.api.mlcontext.FrameMetadata;
import org.apache.sysml.api.mlcontext.MLContextConversionUtil;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;

public class Frame {
    private FrameObject frameObject;
    private SparkExecutionContext sparkExecutionContext;

    public Frame(FrameObject frameObject, SparkExecutionContext sparkExecutionContext) {
        this.frameObject = frameObject;
        this.sparkExecutionContext = sparkExecutionContext;
    }

    public FrameObject toFrameObject() {
        return this.frameObject;
    }

    public String[][] to2DStringArray() {
        return MLContextConversionUtil.frameObjectTo2DStringArray(this.frameObject);
    }

    public JavaRDD<String> toJavaRDDStringIJV() {
        return MLContextConversionUtil.frameObjectToJavaRDDStringIJV(this.frameObject);
    }

    public JavaRDD<String> toJavaRDDStringCSV() {
        return MLContextConversionUtil.frameObjectToJavaRDDStringCSV(this.frameObject, ",");
    }

    public RDD<String> toRDDStringCSV() {
        return MLContextConversionUtil.frameObjectToRDDStringCSV(this.frameObject, ",");
    }

    public RDD<String> toRDDStringIJV() {
        return MLContextConversionUtil.frameObjectToRDDStringIJV(this.frameObject);
    }

    public Dataset<Row> toDF() {
        return MLContextConversionUtil.frameObjectToDataFrame(this.frameObject, this.sparkExecutionContext);
    }

    public BinaryBlockFrame toBinaryBlockFrame() {
        return MLContextConversionUtil.frameObjectToBinaryBlockFrame(this.frameObject, this.sparkExecutionContext);
    }

    public FrameMetadata getFrameMetadata() {
        return new FrameMetadata(this.frameObject.getMatrixCharacteristics());
    }

    public String toString() {
        return this.frameObject.toString();
    }
}

