/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.jmlc;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.api.jmlc.JMLCUtils;
import org.apache.sysml.api.jmlc.PreparedScript;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.rewrite.ProgramRewriter;
import org.apache.sysml.hops.rewrite.RewriteRemovePersistentReadWrite;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DMLTranslator;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParserFactory;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.io.FrameReader;
import org.apache.sysml.runtime.io.FrameReaderFactory;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.io.MatrixReaderFactory;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.wink.json4j.JSONObject;

public class Connection
implements Closeable {
    private DMLConfig _dmlconf = null;

    public Connection() {
        DMLScript.rtplatform = DMLScript.RUNTIME_PLATFORM.SINGLE_NODE;
        CompilerConfig cconf = new CompilerConfig();
        cconf.set(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS, true);
        cconf.set(CompilerConfig.ConfigType.IGNORE_READ_WRITE_METADATA, true);
        cconf.set(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_TEXTFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_WRITE_BINARYFORMATS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_CP_MATRIX_OPERATIONS, false);
        cconf.set(CompilerConfig.ConfigType.PARALLEL_LOCAL_OR_REMOTE_PARFOR, false);
        cconf.set(CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION, false);
        cconf.set(CompilerConfig.ConfigType.ALLOW_INDIVIDUAL_SB_SPECIFIC_OPS, false);
        cconf.set(CompilerConfig.ConfigType.ALLOW_CSE_PERSISTENT_READS, false);
        ConfigurationManager.setLocalConfig(cconf);
        CacheableData.disableCaching();
        this._dmlconf = new DMLConfig();
        ConfigurationManager.setLocalConfig(this._dmlconf);
    }

    public PreparedScript prepareScript(String script, String[] inputs, String[] outputs, boolean parsePyDML) throws DMLException {
        return this.prepareScript(script, new HashMap<String, String>(), inputs, outputs, parsePyDML);
    }

    public PreparedScript prepareScript(String script, Map<String, String> args, String[] inputs, String[] outputs, boolean parsePyDML) throws DMLException {
        DMLScript.SCRIPT_TYPE = parsePyDML ? ScriptType.PYDML : ScriptType.DML;
        Program rtprog = null;
        try {
            ParserWrapper parser = ParserFactory.createParser(parsePyDML);
            DMLProgram prog = parser.parse(null, script, args);
            DMLTranslator dmlt = new DMLTranslator(prog);
            dmlt.liveVariableAnalysis(prog);
            dmlt.validateParseTree(prog);
            dmlt.constructHops(prog);
            dmlt.rewriteHopsDAG(prog);
            RewriteRemovePersistentReadWrite rewrite = new RewriteRemovePersistentReadWrite(inputs, outputs);
            ProgramRewriter rewriter2 = new ProgramRewriter(rewrite);
            rewriter2.rewriteProgramHopDAGs(prog);
            dmlt.constructLops(prog);
            rtprog = prog.getRuntimeProgram(this._dmlconf);
            JMLCUtils.cleanupRuntimeProgram(rtprog, outputs);
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception ex) {
            throw new DMLException(ex);
        }
        return new PreparedScript(rtprog, inputs, outputs);
    }

    @Override
    public void close() {
        ConfigurationManager.clearLocalConfigs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readScript(String fname) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader in = null;
        try {
            if (fname.startsWith("hdfs:") || fname.startsWith("gpfs:")) {
                FileSystem fs = FileSystem.get((Configuration)ConfigurationManager.getCachedJobConf());
                Path scriptPath = new Path(fname);
                in = new BufferedReader(new InputStreamReader((InputStream)fs.open(scriptPath)));
            } else {
                in = new BufferedReader(new FileReader(fname));
            }
            String tmp = null;
            while ((tmp = in.readLine()) != null) {
                sb.append(tmp);
                sb.append("\n");
            }
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(in);
            throw throwable;
        }
        IOUtilFunctions.closeSilently(in);
        return sb.toString();
    }

    public double[][] readDoubleMatrix(String fname) throws IOException {
        try {
            String fnamemtd = DataExpression.getMTDFileName(fname);
            JSONObject jmtd = new DataExpression().readMetadataFile(fnamemtd, false);
            long rows = jmtd.getLong("rows");
            long cols = jmtd.getLong("cols");
            int brlen = jmtd.containsKey("rows_in_block") ? jmtd.getInt("rows_in_block") : -1;
            int bclen = jmtd.containsKey("cols_in_block") ? jmtd.getInt("cols_in_block") : -1;
            long nnz = jmtd.containsKey("nnz") ? jmtd.getLong("nnz") : -1L;
            String format = jmtd.getString("format");
            InputInfo iinfo = InputInfo.stringExternalToInputInfo(format);
            return this.readDoubleMatrix(fname, iinfo, rows, cols, brlen, bclen, nnz);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public double[][] readDoubleMatrix(String fname, InputInfo iinfo, long rows, long cols, int brlen, int bclen, long nnz) throws IOException {
        try {
            MatrixReader reader = MatrixReaderFactory.createMatrixReader(iinfo);
            MatrixBlock mb = reader.readMatrixFromHDFS(fname, rows, cols, brlen, bclen, nnz);
            return DataConverter.convertToDoubleMatrix(mb);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public double[][] convertToDoubleMatrix(String input, String meta) throws IOException {
        try {
            JSONObject jmtd = new JSONObject(meta);
            int rows = jmtd.getInt("rows");
            int cols = jmtd.getInt("cols");
            String format = jmtd.getString("format");
            InputStream is = IOUtilFunctions.toInputStream(input);
            return this.convertToDoubleMatrix(is, rows, cols, format);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public double[][] convertToDoubleMatrix(String input, int rows, int cols) throws IOException {
        InputStream is = IOUtilFunctions.toInputStream(input);
        return this.convertToDoubleMatrix(is, rows, cols);
    }

    public double[][] convertToDoubleMatrix(InputStream input, int rows, int cols) throws IOException {
        return this.convertToDoubleMatrix(input, rows, cols, "text");
    }

    public double[][] convertToDoubleMatrix(InputStream input, int rows, int cols, String format) throws IOException {
        double[][] ret = null;
        if (!("text".equals(format) || "mm".equals(format) || "csv".equals(format))) {
            throw new IOException("Invalid input format (expected: csv, text or mm): " + format);
        }
        try {
            InputInfo iinfo = "csv".equals(format) ? InputInfo.CSVInputInfo : InputInfo.TextCellInputInfo;
            MatrixReader reader = MatrixReaderFactory.createMatrixReader(iinfo);
            MatrixBlock mb = reader.readMatrixFromInputStream(input, rows, cols, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), (long)rows * (long)cols);
            ret = DataConverter.convertToDoubleMatrix(mb);
        }
        catch (DMLRuntimeException rex) {
            throw new IOException(rex);
        }
        return ret;
    }

    public String[][] readStringFrame(String fname) throws IOException {
        try {
            String fnamemtd = DataExpression.getMTDFileName(fname);
            JSONObject jmtd = new DataExpression().readMetadataFile(fnamemtd, false);
            long rows = jmtd.getLong("rows");
            long cols = jmtd.getLong("cols");
            String format = jmtd.getString("format");
            InputInfo iinfo = InputInfo.stringExternalToInputInfo(format);
            return this.readStringFrame(fname, iinfo, rows, cols);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String[][] readStringFrame(String fname, InputInfo iinfo, long rows, long cols) throws IOException {
        try {
            FrameReader reader = FrameReaderFactory.createFrameReader(iinfo);
            FrameBlock mb = reader.readFrameFromHDFS(fname, rows, cols);
            return DataConverter.convertToStringFrame(mb);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String[][] convertToStringFrame(String input, String meta) throws IOException {
        try {
            JSONObject jmtd = new JSONObject(meta);
            int rows = jmtd.getInt("rows");
            int cols = jmtd.getInt("cols");
            String format = jmtd.getString("format");
            InputStream is = IOUtilFunctions.toInputStream(input);
            return this.convertToStringFrame(is, rows, cols, format);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public String[][] convertToStringFrame(String input, int rows, int cols) throws IOException {
        InputStream is = IOUtilFunctions.toInputStream(input);
        return this.convertToStringFrame(is, rows, cols);
    }

    public String[][] convertToStringFrame(InputStream input, int rows, int cols) throws IOException {
        return this.convertToStringFrame(input, rows, cols, "text");
    }

    public String[][] convertToStringFrame(InputStream input, int rows, int cols, String format) throws IOException {
        String[][] ret = null;
        if (!("text".equals(format) || "mm".equals(format) || "csv".equals(format))) {
            throw new IOException("Invalid input format (expected: csv, text or mm): " + format);
        }
        try {
            InputInfo iinfo = "csv".equals(format) ? InputInfo.CSVInputInfo : InputInfo.TextCellInputInfo;
            FrameReader reader = FrameReaderFactory.createFrameReader(iinfo);
            FrameBlock mb = reader.readFrameFromInputStream(input, rows, cols);
            ret = DataConverter.convertToStringFrame(mb);
        }
        catch (DMLRuntimeException rex) {
            throw new IOException(rex);
        }
        return ret;
    }

    public FrameBlock readTransformMetaDataFromFile(String metapath) throws IOException {
        return this.readTransformMetaDataFromFile(null, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromFile(String spec, String metapath) throws IOException {
        return this.readTransformMetaDataFromFile(spec, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromFile(String spec, String metapath, String colDelim) throws IOException {
        return TfMetaUtils.readTransformMetaDataFromFile(spec, metapath, colDelim);
    }

    public FrameBlock readTransformMetaDataFromPath(String metapath) throws IOException {
        return this.readTransformMetaDataFromPath(null, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromPath(String spec, String metapath) throws IOException {
        return this.readTransformMetaDataFromPath(spec, metapath, ",");
    }

    public FrameBlock readTransformMetaDataFromPath(String spec, String metapath, String colDelim) throws IOException {
        return TfMetaUtils.readTransformMetaDataFromPath(spec, metapath, colDelim);
    }
}

