/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.api.MLContextProxy;
import org.apache.sysml.api.MLMatrix;
import org.apache.sysml.api.MLOutput;
import org.apache.sysml.api.jmlc.JMLCUtils;
import org.apache.sysml.api.mlcontext.ScriptType;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.globalopt.GlobalOptimizerWrapper;
import org.apache.sysml.hops.rewrite.ProgramRewriter;
import org.apache.sysml.hops.rewrite.RewriteRemovePersistentReadWrite;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DMLTranslator;
import org.apache.sysml.parser.DataExpression;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.ParserFactory;
import org.apache.sysml.parser.ParserWrapper;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.instructions.spark.functions.ConvertStringToLongTextPair;
import org.apache.sysml.runtime.instructions.spark.functions.CopyTextInputFunction;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.FileFormatProperties;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.Statistics;
import scala.collection.JavaConversions;

@Deprecated
public class MLContext {
    private static MLContext _activeMLContext = null;
    private SparkContext _sc = null;
    private ArrayList<String> _inVarnames = null;
    private ArrayList<String> _outVarnames = null;
    private LocalVariableMap _variables = null;
    private Program _rtprog = null;
    private Map<String, String> _additionalConfigs = new HashMap<String, String>();

    static MLContext getActiveMLContext() {
        return _activeMLContext;
    }

    public SparkContext getSparkContext() {
        if (this._sc == null) {
            throw new RuntimeException("No spark context set in MLContext");
        }
        return this._sc;
    }

    public MLContext(SparkContext sc) throws DMLRuntimeException {
        this.initializeSpark(sc, false, false);
    }

    public MLContext(JavaSparkContext sc) throws DMLRuntimeException {
        this.initializeSpark(sc.sc(), false, false);
    }

    public void setConfig(String paramName, String paramVal) {
        this._additionalConfigs.put(paramName, paramVal);
    }

    public void registerInput(String varName, Dataset<Row> df) throws DMLRuntimeException {
        this.registerInput(varName, df, false);
    }

    public void registerFrameInput(String varName, Dataset<Row> df) throws DMLRuntimeException {
        this.registerFrameInput(varName, df, false);
    }

    public void registerInput(String varName, Dataset<Row> df, boolean containsID) throws DMLRuntimeException {
        int blksz = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mcOut = new MatrixCharacteristics(-1L, -1L, blksz, blksz);
        JavaPairRDD<MatrixIndexes, MatrixBlock> rdd = RDDConverterUtils.dataFrameToBinaryBlock(new JavaSparkContext(this._sc), df, mcOut, containsID, false);
        this.registerInput(varName, rdd, mcOut);
    }

    public void registerFrameInput(String varName, Dataset<Row> df, boolean containsID) throws DMLRuntimeException {
        int blksz = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mcOut = new MatrixCharacteristics(-1L, -1L, blksz, blksz);
        JavaPairRDD<Long, FrameBlock> rdd = FrameRDDConverterUtils.dataFrameToBinaryBlock(new JavaSparkContext(this._sc), df, mcOut, containsID);
        this.registerInput(varName, rdd, mcOut.getRows(), mcOut.getCols(), null);
    }

    public void registerInput(String varName, MLMatrix df) throws DMLRuntimeException {
        this.registerInput(varName, MLMatrix.getRDDLazily(df), df.mc);
    }

    public void registerInput(String varName, JavaRDD<String> rdd, String format, boolean hasHeader, String delim, boolean fill, double fillValue) throws DMLRuntimeException {
        this.registerInput(varName, rdd, format, hasHeader, delim, fill, fillValue, -1L, -1L, -1L);
    }

    public void registerInput(String varName, RDD<String> rdd, String format, boolean hasHeader, String delim, boolean fill, double fillValue) throws DMLRuntimeException {
        this.registerInput(varName, (JavaRDD<String>)rdd.toJavaRDD(), format, hasHeader, delim, fill, fillValue, -1L, -1L, -1L);
    }

    public void registerInput(String varName, RDD<String> rdd, String format, boolean hasHeader, String delim, boolean fill, double fillValue, long rlen, long clen, long nnz) throws DMLRuntimeException {
        this.registerInput(varName, (JavaRDD<String>)rdd.toJavaRDD(), format, hasHeader, delim, fill, fillValue, -1L, -1L, -1L);
    }

    public void registerInput(String varName, JavaRDD<String> rdd, String format, boolean hasHeader, String delim, boolean fill, double fillValue, long rlen, long clen, long nnz) throws DMLRuntimeException {
        CSVFileFormatProperties props = new CSVFileFormatProperties(hasHeader, delim, fill, fillValue, "");
        this.registerInput(varName, (JavaPairRDD<LongWritable, Text>)rdd.mapToPair((PairFunction)new ConvertStringToLongTextPair()), format, rlen, clen, nnz, props);
    }

    public void registerInput(String varName, RDD<String> rdd, String format) throws DMLRuntimeException {
        this.registerInput(varName, (JavaPairRDD<LongWritable, Text>)rdd.toJavaRDD().mapToPair((PairFunction)new ConvertStringToLongTextPair()), format, -1L, -1L, -1L, null);
    }

    public void registerInput(String varName, JavaRDD<String> rdd, String format) throws DMLRuntimeException {
        this.registerInput(varName, (JavaPairRDD<LongWritable, Text>)rdd.mapToPair((PairFunction)new ConvertStringToLongTextPair()), format, -1L, -1L, -1L, null);
    }

    public void registerInput(String varName, JavaRDD<String> rdd, String format, long rlen, long clen) throws DMLRuntimeException {
        this.registerInput(varName, (JavaPairRDD<LongWritable, Text>)rdd.mapToPair((PairFunction)new ConvertStringToLongTextPair()), format, rlen, clen, -1L, null);
    }

    public void registerInput(String varName, RDD<String> rdd, String format, long rlen, long clen) throws DMLRuntimeException {
        this.registerInput(varName, (JavaPairRDD<LongWritable, Text>)rdd.toJavaRDD().mapToPair((PairFunction)new ConvertStringToLongTextPair()), format, rlen, clen, -1L, null);
    }

    public void registerInput(String varName, JavaRDD<String> rdd, String format, long rlen, long clen, long nnz) throws DMLRuntimeException {
        this.registerInput(varName, (JavaPairRDD<LongWritable, Text>)rdd.mapToPair((PairFunction)new ConvertStringToLongTextPair()), format, rlen, clen, nnz, null);
    }

    public void registerInput(String varName, RDD<String> rdd, String format, long rlen, long clen, long nnz) throws DMLRuntimeException {
        this.registerInput(varName, (JavaPairRDD<LongWritable, Text>)rdd.toJavaRDD().mapToPair((PairFunction)new ConvertStringToLongTextPair()), format, rlen, clen, nnz, null);
    }

    private void registerInput(String varName, JavaPairRDD<LongWritable, Text> textOrCsv_rdd, String format, long rlen, long clen, long nnz, FileFormatProperties props) throws DMLRuntimeException {
        MatrixObject mo;
        int blksz;
        if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SPARK && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK) {
            throw new DMLRuntimeException("The registerInput functionality only supported for spark runtime. Please use MLContext(sc) instead of default constructor.");
        }
        if (this._variables == null) {
            this._variables = new LocalVariableMap();
        }
        if (this._inVarnames == null) {
            this._inVarnames = new ArrayList();
        }
        if (format.equals("csv")) {
            blksz = ConfigurationManager.getBlocksize();
            MatrixCharacteristics mc = new MatrixCharacteristics(rlen, clen, blksz, blksz, nnz);
            mo = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.CSVOutputInfo, InputInfo.CSVInputInfo));
        } else if (format.equals("text")) {
            if (rlen == -1L || clen == -1L) {
                throw new DMLRuntimeException("The metadata is required in registerInput for format:" + format);
            }
            blksz = ConfigurationManager.getBlocksize();
            MatrixCharacteristics mc = new MatrixCharacteristics(rlen, clen, blksz, blksz, nnz);
            mo = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.TextCellOutputInfo, InputInfo.TextCellInputInfo));
        } else {
            if (format.equals("mm")) {
                throw new DMLRuntimeException("Matrixmarket format is not yet implemented in registerInput: " + format);
            }
            throw new DMLRuntimeException("Incorrect format in registerInput: " + format);
        }
        JavaPairRDD rdd = textOrCsv_rdd.mapToPair((PairFunction)new CopyTextInputFunction());
        if (props != null) {
            mo.setFileFormatProperties(props);
        }
        mo.setRDDHandle(new RDDObject(rdd, varName));
        this._variables.put(varName, mo);
        this._inVarnames.add(varName);
        this.checkIfRegisteringInputAllowed();
    }

    public void registerInput(String varName, JavaRDD<String> rddIn, String format, long rlen, long clen, FileFormatProperties props, List<Expression.ValueType> schema) throws DMLRuntimeException {
        if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SPARK && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK) {
            throw new DMLRuntimeException("The registerInput functionality only supported for spark runtime. Please use MLContext(sc) instead of default constructor.");
        }
        long nnz = -1L;
        if (this._variables == null) {
            this._variables = new LocalVariableMap();
        }
        if (this._inVarnames == null) {
            this._inVarnames = new ArrayList();
        }
        JavaPairRDD rddText = rddIn.mapToPair((PairFunction)new ConvertStringToLongTextPair());
        int blksz = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(rlen, clen, blksz, blksz, nnz);
        FrameObject fo = null;
        if (format.equals("csv")) {
            CSVFileFormatProperties csvprops = props != null ? (CSVFileFormatProperties)props : new CSVFileFormatProperties();
            fo = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.CSVOutputInfo, InputInfo.CSVInputInfo));
            fo.setFileFormatProperties(csvprops);
        } else if (format.equals("text")) {
            if (rlen == -1L || clen == -1L) {
                throw new DMLRuntimeException("The metadata is required in registerInput for format:" + format);
            }
            fo = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.TextCellOutputInfo, InputInfo.TextCellInputInfo));
        } else {
            throw new DMLRuntimeException("Incorrect format in registerInput: " + format);
        }
        if (props != null) {
            fo.setFileFormatProperties(props);
        }
        fo.setRDDHandle(new RDDObject(rddText, varName));
        fo.setSchema("String");
        this._variables.put(varName, fo);
        this._inVarnames.add(varName);
        this.checkIfRegisteringInputAllowed();
    }

    private void registerInput(String varName, JavaPairRDD<Long, FrameBlock> rdd, long rlen, long clen, FileFormatProperties props) throws DMLRuntimeException {
        if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SPARK && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK) {
            throw new DMLRuntimeException("The registerInput functionality only supported for spark runtime. Please use MLContext(sc) instead of default constructor.");
        }
        if (this._variables == null) {
            this._variables = new LocalVariableMap();
        }
        if (this._inVarnames == null) {
            this._inVarnames = new ArrayList();
        }
        int blksz = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(rlen, clen, blksz, blksz, -1L);
        FrameObject fo = new FrameObject(OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo));
        if (props != null) {
            fo.setFileFormatProperties(props);
        }
        fo.setRDDHandle(new RDDObject(rdd, varName));
        this._variables.put(varName, fo);
        this._inVarnames.add(varName);
        this.checkIfRegisteringInputAllowed();
    }

    public void registerInput(String varName, JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, long rlen, long clen) throws DMLRuntimeException {
        this.registerInput(varName, rdd, rlen, clen, 1000, 1000);
    }

    public void registerInput(String varName, JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, long rlen, long clen, int brlen, int bclen) throws DMLRuntimeException {
        this.registerInput(varName, rdd, rlen, clen, brlen, bclen, -1L);
    }

    public void registerInput(String varName, JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, long rlen, long clen, int brlen, int bclen, long nnz) throws DMLRuntimeException {
        if (rlen == -1L || clen == -1L) {
            throw new DMLRuntimeException("The metadata is required in registerInput for binary format");
        }
        MatrixCharacteristics mc = new MatrixCharacteristics(rlen, clen, brlen, bclen, nnz);
        this.registerInput(varName, rdd, mc);
    }

    public void registerInput(String varName, JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, MatrixCharacteristics mc) throws DMLRuntimeException {
        if (this._variables == null) {
            this._variables = new LocalVariableMap();
        }
        if (this._inVarnames == null) {
            this._inVarnames = new ArrayList();
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> copyRDD = SparkUtils.copyBinaryBlockMatrix(rdd);
        MatrixObject mo = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo));
        mo.setRDDHandle(new RDDObject(copyRDD, varName));
        this._variables.put(varName, mo);
        this._inVarnames.add(varName);
        this.checkIfRegisteringInputAllowed();
    }

    public void registerInput(String varName, MatrixBlock mb) throws DMLRuntimeException {
        int blksz = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(mb.getNumRows(), mb.getNumColumns(), blksz, blksz, mb.getNonZeros());
        this.registerInput(varName, mb, mc);
    }

    public void registerInput(String varName, MatrixBlock mb, MatrixCharacteristics mc) throws DMLRuntimeException {
        if (this._variables == null) {
            this._variables = new LocalVariableMap();
        }
        if (this._inVarnames == null) {
            this._inVarnames = new ArrayList();
        }
        MatrixObject mo = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo));
        mo.acquireModify(mb);
        mo.release();
        this._variables.put(varName, mo);
        this._inVarnames.add(varName);
        this.checkIfRegisteringInputAllowed();
    }

    public void registerOutput(String varName) throws DMLRuntimeException {
        if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SPARK && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK) {
            throw new DMLRuntimeException("The registerOutput functionality only supported for spark runtime. Please use MLContext(sc) instead of default constructor.");
        }
        if (this._outVarnames == null) {
            this._outVarnames = new ArrayList();
        }
        this._outVarnames.add(varName);
        if (this._variables == null) {
            this._variables = new LocalVariableMap();
        }
    }

    public MLOutput execute(String dmlScriptFilePath, Map<String, String> namedArgs, boolean parsePyDML, String configFilePath) throws IOException, DMLException, ParseException {
        String[] args = new String[namedArgs.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : namedArgs.entrySet()) {
            args[i] = entry.getValue().trim().isEmpty() ? entry.getKey() + "=\"" + entry.getValue() + "\"" : entry.getKey() + "=" + entry.getValue();
            ++i;
        }
        return this.compileAndExecuteScript(dmlScriptFilePath, args, true, parsePyDML, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, Map<String, String> namedArgs, String configFilePath) throws IOException, DMLException, ParseException {
        String[] args = new String[namedArgs.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : namedArgs.entrySet()) {
            args[i] = entry.getValue().trim().isEmpty() ? entry.getKey() + "=\"" + entry.getValue() + "\"" : entry.getKey() + "=" + entry.getValue();
            ++i;
        }
        return this.compileAndExecuteScript(dmlScriptFilePath, args, true, false, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, Map<String, String> namedArgs) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, namedArgs, false, null);
    }

    public MLOutput execute(String dmlScriptFilePath, scala.collection.immutable.Map<String, String> namedArgs) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, new HashMap<String, String>(JavaConversions.mapAsJavaMap(namedArgs)));
    }

    public MLOutput execute(String dmlScriptFilePath, Map<String, String> namedArgs, boolean parsePyDML) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, namedArgs, parsePyDML, null);
    }

    public MLOutput execute(String dmlScriptFilePath, scala.collection.immutable.Map<String, String> namedArgs, boolean parsePyDML) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, new HashMap<String, String>(JavaConversions.mapAsJavaMap(namedArgs)), parsePyDML);
    }

    public MLOutput execute(String dmlScriptFilePath, String[] args, String configFilePath) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, args, false, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, ArrayList<String> args, String configFilePath) throws IOException, DMLException, ParseException {
        String[] argsArr = new String[args.size()];
        argsArr = args.toArray(argsArr);
        return this.execute(dmlScriptFilePath, argsArr, false, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, String[] args) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, args, false, null);
    }

    public MLOutput execute(String dmlScriptFilePath, ArrayList<String> args) throws IOException, DMLException, ParseException {
        String[] argsArr = new String[args.size()];
        argsArr = args.toArray(argsArr);
        return this.execute(dmlScriptFilePath, argsArr, false, null);
    }

    public MLOutput execute(String dmlScriptFilePath, ArrayList<String> args, boolean parsePyDML) throws IOException, DMLException, ParseException {
        String[] argsArr = new String[args.size()];
        argsArr = args.toArray(argsArr);
        return this.execute(dmlScriptFilePath, argsArr, parsePyDML, null);
    }

    public MLOutput execute(String dmlScriptFilePath, ArrayList<String> args, boolean parsePyDML, String configFilePath) throws IOException, DMLException, ParseException {
        String[] argsArr = new String[args.size()];
        argsArr = args.toArray(argsArr);
        return this.execute(dmlScriptFilePath, argsArr, parsePyDML, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, ArrayList<String> argsName, ArrayList<String> argsValues, String configFilePath) throws IOException, DMLException, ParseException {
        HashMap<String, String> newNamedArgs = new HashMap<String, String>();
        if (argsName.size() != argsValues.size()) {
            throw new DMLException("size of argsName " + argsName.size() + " is diff than  size of argsValues");
        }
        for (int i = 0; i < argsName.size(); ++i) {
            String k = argsName.get(i);
            String v = argsValues.get(i);
            newNamedArgs.put(k, v);
        }
        return this.execute(dmlScriptFilePath, newNamedArgs, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, ArrayList<String> argsName, ArrayList<String> argsValues) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, argsName, argsValues, null);
    }

    public MLOutput execute(String dmlScriptFilePath, String[] args, boolean parsePyDML, String configFilePath) throws IOException, DMLException, ParseException {
        return this.compileAndExecuteScript(dmlScriptFilePath, args, false, parsePyDML, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, String[] args, boolean parsePyDML) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, args, parsePyDML, null);
    }

    public MLOutput execute(String dmlScriptFilePath, String configFilePath) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, false, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, false, null);
    }

    public MLOutput execute(String dmlScriptFilePath, boolean parsePyDML, String configFilePath) throws IOException, DMLException, ParseException {
        return this.compileAndExecuteScript(dmlScriptFilePath, null, false, parsePyDML, configFilePath);
    }

    public MLOutput execute(String dmlScriptFilePath, boolean parsePyDML) throws IOException, DMLException, ParseException {
        return this.execute(dmlScriptFilePath, parsePyDML, null);
    }

    public void reset() throws DMLRuntimeException {
        this.reset(false);
    }

    public void reset(boolean cleanupConfig) throws DMLRuntimeException {
        CacheableData.cleanupCacheDir();
        this._inVarnames = null;
        this._outVarnames = null;
        this._variables = null;
        if (cleanupConfig) {
            this._additionalConfigs.clear();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setAppropriateVarsForRead(Expression source, String target) throws LanguageException {
        boolean isReadExpression;
        boolean isTargetRegistered = this.isRegisteredAsInput(target);
        boolean bl = isReadExpression = source instanceof DataExpression && ((DataExpression)source).isRead();
        if (!isTargetRegistered || !isReadExpression) return;
        ((DataExpression)source).setCheckMetadata(false);
        if (((DataExpression)source).getDataType() == Expression.DataType.MATRIX) {
            MatrixObject mo = null;
            try {
                mo = this.getMatrixObject(target);
                int blp = source.getBeginLine();
                int bcp = source.getBeginColumn();
                int elp = source.getEndLine();
                int ecp = source.getEndColumn();
                ((DataExpression)source).addVarParam("rows", new IntIdentifier(mo.getNumRows(), source.getFilename(), blp, bcp, elp, ecp));
                ((DataExpression)source).addVarParam("cols", new IntIdentifier(mo.getNumColumns(), source.getFilename(), blp, bcp, elp, ecp));
                ((DataExpression)source).addVarParam("nnz", new IntIdentifier(mo.getNnz(), source.getFilename(), blp, bcp, elp, ecp));
                ((DataExpression)source).addVarParam("data_type", new StringIdentifier("matrix", source.getFilename(), blp, bcp, elp, ecp));
                ((DataExpression)source).addVarParam("value_type", new StringIdentifier("double", source.getFilename(), blp, bcp, elp, ecp));
                if (!(mo.getMetaData() instanceof MatrixFormatMetaData)) return;
                MatrixFormatMetaData metaData = (MatrixFormatMetaData)mo.getMetaData();
                if (metaData.getOutputInfo() == OutputInfo.CSVOutputInfo) {
                    ((DataExpression)source).addVarParam("format", new StringIdentifier("csv", source.getFilename(), blp, bcp, elp, ecp));
                    return;
                }
                if (metaData.getOutputInfo() == OutputInfo.TextCellOutputInfo) {
                    ((DataExpression)source).addVarParam("format", new StringIdentifier("text", source.getFilename(), blp, bcp, elp, ecp));
                    return;
                }
                if (metaData.getOutputInfo() != OutputInfo.BinaryBlockOutputInfo) throw new LanguageException("Unsupported format through MLContext");
                ((DataExpression)source).addVarParam("rows_in_block", new IntIdentifier(mo.getNumRowsPerBlock(), source.getFilename(), blp, bcp, elp, ecp));
                ((DataExpression)source).addVarParam("cols_in_block", new IntIdentifier(mo.getNumColumnsPerBlock(), source.getFilename(), blp, bcp, elp, ecp));
                ((DataExpression)source).addVarParam("format", new StringIdentifier("binary", source.getFilename(), blp, bcp, elp, ecp));
                return;
            }
            catch (DMLRuntimeException e) {
                throw new LanguageException(e);
            }
        }
        if (((DataExpression)source).getDataType() != Expression.DataType.FRAME) return;
        FrameObject mo = null;
        try {
            mo = this.getFrameObject(target);
            int blp = source.getBeginLine();
            int bcp = source.getBeginColumn();
            int elp = source.getEndLine();
            int ecp = source.getEndColumn();
            ((DataExpression)source).addVarParam("rows", new IntIdentifier(mo.getNumRows(), source.getFilename(), blp, bcp, elp, ecp));
            ((DataExpression)source).addVarParam("cols", new IntIdentifier(mo.getNumColumns(), source.getFilename(), blp, bcp, elp, ecp));
            ((DataExpression)source).addVarParam("data_type", new StringIdentifier("frame", source.getFilename(), blp, bcp, elp, ecp));
            ((DataExpression)source).addVarParam("value_type", new StringIdentifier("double", source.getFilename(), blp, bcp, elp, ecp));
            if (!(mo.getMetaData() instanceof MatrixFormatMetaData)) return;
            MatrixFormatMetaData metaData = (MatrixFormatMetaData)mo.getMetaData();
            if (metaData.getOutputInfo() == OutputInfo.CSVOutputInfo) {
                ((DataExpression)source).addVarParam("format", new StringIdentifier("csv", source.getFilename(), blp, bcp, elp, ecp));
                return;
            } else if (metaData.getOutputInfo() == OutputInfo.TextCellOutputInfo) {
                ((DataExpression)source).addVarParam("format", new StringIdentifier("text", source.getFilename(), blp, bcp, elp, ecp));
                return;
            } else {
                if (metaData.getOutputInfo() != OutputInfo.BinaryBlockOutputInfo) throw new LanguageException("Unsupported format through MLContext");
                ((DataExpression)source).addVarParam("format", new StringIdentifier("binary", source.getFilename(), blp, bcp, elp, ecp));
            }
            return;
        }
        catch (DMLRuntimeException e) {
            throw new LanguageException(e);
        }
    }

    ArrayList<Instruction> performCleanupAfterRecompilation(ArrayList<Instruction> tmp) {
        String[] outputs = this._outVarnames != null ? this._outVarnames.toArray(new String[0]) : new String[]{};
        return JMLCUtils.cleanupRuntimeInstructions(tmp, outputs);
    }

    private boolean isRegisteredAsInput(String varName) {
        if (this._inVarnames != null) {
            for (String v : this._inVarnames) {
                if (!v.equals(varName)) continue;
                return true;
            }
        }
        return false;
    }

    private MatrixObject getMatrixObject(String varName) throws DMLRuntimeException {
        if (this._variables != null) {
            Data mo = this._variables.get(varName);
            if (mo instanceof MatrixObject) {
                return (MatrixObject)mo;
            }
            throw new DMLRuntimeException("ERROR: Incorrect type");
        }
        throw new DMLRuntimeException("ERROR: getMatrixObject not set for variable:" + varName);
    }

    private FrameObject getFrameObject(String varName) throws DMLRuntimeException {
        if (this._variables != null) {
            Data mo = this._variables.get(varName);
            if (mo instanceof FrameObject) {
                return (FrameObject)mo;
            }
            throw new DMLRuntimeException("ERROR: Incorrect type");
        }
        throw new DMLRuntimeException("ERROR: getMatrixObject not set for variable:" + varName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int compareVersion(String versionStr1, String versionStr2) {
        block7: {
            block6: {
                s1 = null;
                s2 = null;
                try {
                    s1 = new Scanner(versionStr1);
                    s1.useDelimiter("\\.");
                    s2 = new Scanner(versionStr2);
                    s2.useDelimiter("\\.");
lbl10:
                    // 2 sources

                    while (s1.hasNextInt() && s2.hasNextInt()) {
                        version1 = s1.nextInt();
                        if (version1 < (version2 = s2.nextInt())) {
                            var7_7 = -1;
                            break block6;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var8_9) {
                    IOUtilFunctions.closeSilently(s1);
                    IOUtilFunctions.closeSilently(s2);
                    throw var8_9;
                }
            }
            IOUtilFunctions.closeSilently(s1);
            IOUtilFunctions.closeSilently(s2);
            return var7_7;
lbl-1000:
            // 1 sources

            {
                if (version1 <= version2) ** GOTO lbl10
                var7_8 = 1;
            }
            IOUtilFunctions.closeSilently(s1);
            IOUtilFunctions.closeSilently(s2);
            return var7_8;
lbl-1000:
            // 1 sources

            {
                if (!s1.hasNextInt()) break block7;
                var5_5 = 1;
            }
            IOUtilFunctions.closeSilently(s1);
            IOUtilFunctions.closeSilently(s2);
            return var5_5;
        }
        IOUtilFunctions.closeSilently(s1);
        IOUtilFunctions.closeSilently(s2);
        return 0;
    }

    private void initializeSpark(SparkContext sc, boolean monitorPerformance, boolean setForcedSparkExecType) throws DMLRuntimeException {
        MLContextProxy.setActive(true);
        this._sc = sc;
        if (this.compareVersion(sc.version(), "1.3.0") < 0) {
            throw new DMLRuntimeException("Expected spark version >= 1.3.0 for running SystemML");
        }
        DMLScript.rtplatform = setForcedSparkExecType ? DMLScript.RUNTIME_PLATFORM.SPARK : DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK;
    }

    public MLOutput executeScript(String dmlScript) throws IOException, DMLException {
        return this.executeScript(dmlScript, false);
    }

    public MLOutput executeScript(String dmlScript, boolean isPyDML) throws IOException, DMLException {
        return this.executeScript(dmlScript, isPyDML, null);
    }

    public MLOutput executeScript(String dmlScript, String configFilePath) throws IOException, DMLException {
        return this.executeScript(dmlScript, false, configFilePath);
    }

    public MLOutput executeScript(String dmlScript, boolean isPyDML, String configFilePath) throws IOException, DMLException {
        return this.compileAndExecuteScript(dmlScript, null, false, false, isPyDML, configFilePath);
    }

    public MLOutput executeScript(String dmlScript, ArrayList<String> argsName, ArrayList<String> argsValues, String configFilePath) throws IOException, DMLException, ParseException {
        HashMap<String, String> newNamedArgs = new HashMap<String, String>();
        if (argsName.size() != argsValues.size()) {
            throw new DMLException("size of argsName " + argsName.size() + " is diff than  size of argsValues");
        }
        for (int i = 0; i < argsName.size(); ++i) {
            String k = argsName.get(i);
            String v = argsValues.get(i);
            newNamedArgs.put(k, v);
        }
        return this.executeScript(dmlScript, newNamedArgs, configFilePath);
    }

    public MLOutput executeScript(String dmlScript, ArrayList<String> argsName, ArrayList<String> argsValues) throws IOException, DMLException, ParseException {
        return this.executeScript(dmlScript, argsName, argsValues, null);
    }

    public MLOutput executeScript(String dmlScript, scala.collection.immutable.Map<String, String> namedArgs) throws IOException, DMLException {
        return this.executeScript(dmlScript, new HashMap<String, String>(JavaConversions.mapAsJavaMap(namedArgs)), null);
    }

    public MLOutput executeScript(String dmlScript, scala.collection.immutable.Map<String, String> namedArgs, boolean isPyDML) throws IOException, DMLException {
        return this.executeScript(dmlScript, new HashMap<String, String>(JavaConversions.mapAsJavaMap(namedArgs)), isPyDML, null);
    }

    public MLOutput executeScript(String dmlScript, scala.collection.immutable.Map<String, String> namedArgs, String configFilePath) throws IOException, DMLException {
        return this.executeScript(dmlScript, new HashMap<String, String>(JavaConversions.mapAsJavaMap(namedArgs)), configFilePath);
    }

    public MLOutput executeScript(String dmlScript, scala.collection.immutable.Map<String, String> namedArgs, boolean isPyDML, String configFilePath) throws IOException, DMLException {
        return this.executeScript(dmlScript, new HashMap<String, String>(JavaConversions.mapAsJavaMap(namedArgs)), isPyDML, configFilePath);
    }

    public MLOutput executeScript(String dmlScript, Map<String, String> namedArgs) throws IOException, DMLException {
        return this.executeScript(dmlScript, namedArgs, null);
    }

    public MLOutput executeScript(String dmlScript, Map<String, String> namedArgs, boolean isPyDML) throws IOException, DMLException {
        return this.executeScript(dmlScript, namedArgs, isPyDML, null);
    }

    public MLOutput executeScript(String dmlScript, Map<String, String> namedArgs, String configFilePath) throws IOException, DMLException {
        return this.executeScript(dmlScript, namedArgs, false, configFilePath);
    }

    public MLOutput executeScript(String dmlScript, Map<String, String> namedArgs, boolean isPyDML, String configFilePath) throws IOException, DMLException {
        String[] args = new String[namedArgs.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : namedArgs.entrySet()) {
            args[i] = entry.getValue().trim().isEmpty() ? entry.getKey() + "=\"" + entry.getValue() + "\"" : entry.getKey() + "=" + entry.getValue();
            ++i;
        }
        return this.compileAndExecuteScript(dmlScript, args, false, true, isPyDML, configFilePath);
    }

    private void checkIfRegisteringInputAllowed() throws DMLRuntimeException {
        if (DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SPARK && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.HYBRID_SPARK) {
            throw new DMLRuntimeException("ERROR: registerInput is only allowed for spark execution mode");
        }
    }

    private MLOutput compileAndExecuteScript(String dmlScriptFilePath, String[] args, boolean isNamedArgument, boolean isPyDML, String configFilePath) throws IOException, DMLException {
        return this.compileAndExecuteScript(dmlScriptFilePath, args, true, isNamedArgument, isPyDML, configFilePath);
    }

    private synchronized MLOutput compileAndExecuteScript(String dmlScriptFilePath, String[] args, boolean isFile, boolean isNamedArgument, boolean isPyDML, String configFilePath) throws IOException, DMLException {
        try {
            ScriptType scriptType = DMLScript.SCRIPT_TYPE = isPyDML ? ScriptType.PYDML : ScriptType.DML;
            if (MLContext.getActiveMLContext() != null) {
                throw new DMLRuntimeException("SystemML (and hence by definition MLContext) doesnot support parallel execute() calls from same or different MLContexts. As a temporary fix, please do explicit synchronization, i.e. synchronized(MLContext.class) { ml.execute(...) } ");
            }
            _activeMLContext = this;
            if (OptimizerUtils.isSparkExecutionMode()) {
                HashMap retVal;
                String[] inputs = this._inVarnames != null ? this._inVarnames.toArray(new String[0]) : new String[]{};
                String[] outputs = this._outVarnames != null ? this._outVarnames.toArray(new String[0]) : new String[]{};
                retVal = this._outVarnames != null && !this._outVarnames.isEmpty() ? (retVal = new HashMap()) : null;
                HashMap<String, MatrixCharacteristics> outMetadata = new HashMap<String, MatrixCharacteristics>();
                Map<String, String> argVals = DMLScript.createArgumentsMap(isNamedArgument, args);
                ExecutionContext ec = this.executeUsingSimplifiedCompilationChain(dmlScriptFilePath, isFile, argVals, isPyDML, inputs, outputs, this._variables, configFilePath);
                SparkExecutionContext sec = (SparkExecutionContext)ec;
                if (this._outVarnames != null) {
                    if (this._variables == null) {
                        throw new DMLRuntimeException("The symbol table returned after executing the script is empty");
                    }
                    for (String ovar : this._outVarnames) {
                        if (!this._variables.keySet().contains(ovar)) {
                            throw new DMLException("Error: The variable " + ovar + " is not available as output after the execution of the DMLScript.");
                        }
                        retVal.put(ovar, sec.getRDDHandleForVariable(ovar, InputInfo.BinaryBlockInputInfo));
                        outMetadata.put(ovar, ec.getMatrixCharacteristics(ovar));
                    }
                }
                MLOutput mLOutput = new MLOutput(retVal, outMetadata);
                return mLOutput;
            }
            throw new DMLRuntimeException("Unsupported runtime:" + DMLScript.rtplatform.name());
        }
        finally {
            _activeMLContext = null;
        }
    }

    private ExecutionContext executeUsingSimplifiedCompilationChain(String dmlScriptFilePath, boolean isFile, Map<String, String> argVals, boolean parsePyDML, String[] inputs, String[] outputs, LocalVariableMap inputSymbolTable, String configFilePath) throws IOException, DMLException {
        DMLConfig config = configFilePath == null ? new DMLConfig() : new DMLConfig(configFilePath);
        for (Map.Entry<String, String> param : this._additionalConfigs.entrySet()) {
            config.setTextValue(param.getKey(), param.getValue());
        }
        ConfigurationManager.setGlobalConfig(config);
        CompilerConfig cconf = new CompilerConfig();
        cconf.set(CompilerConfig.ConfigType.IGNORE_UNSPECIFIED_ARGS, true);
        cconf.set(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS, false);
        cconf.set(CompilerConfig.ConfigType.ALLOW_CSE_PERSISTENT_READS, false);
        ConfigurationManager.setGlobalConfig(cconf);
        String dmlScriptStr = DMLScript.readDMLScript(isFile ? "-f" : "-s", dmlScriptFilePath);
        this._rtprog = null;
        ParserWrapper parser = ParserFactory.createParser(parsePyDML);
        DMLProgram prog = isFile ? parser.parse(dmlScriptFilePath, null, argVals) : parser.parse(null, dmlScriptStr, argVals);
        DMLTranslator dmlt = new DMLTranslator(prog);
        dmlt.liveVariableAnalysis(prog);
        dmlt.validateParseTree(prog);
        dmlt.constructHops(prog);
        dmlt.rewriteHopsDAG(prog);
        Explain.explain(prog);
        if (inputSymbolTable != null) {
            RewriteRemovePersistentReadWrite rewrite = new RewriteRemovePersistentReadWrite(inputs, outputs, inputSymbolTable);
            ProgramRewriter rewriter2 = new ProgramRewriter(rewrite);
            rewriter2.rewriteProgramHopDAGs(prog);
        }
        dmlt.constructLops(prog);
        this._rtprog = prog.getRuntimeProgram(config);
        if (OptimizerUtils.isOptLevel(OptimizerUtils.OptimizationLevel.O4_GLOBAL_TIME_MEMORY)) {
            this._rtprog = GlobalOptimizerWrapper.optimizeProgram(prog, this._rtprog);
        }
        Explain.ExplainCounts counts = Explain.countDistributedOperations(this._rtprog);
        Statistics.resetNoOfCompiledJobs(counts.numJobs);
        DMLScript.initHadoopExecution(config);
        JMLCUtils.cleanupRuntimeProgram(this._rtprog, outputs);
        ExecutionContext ec = ExecutionContextFactory.createContext(this._rtprog);
        if (inputSymbolTable != null) {
            ec.setVariables(inputSymbolTable);
        }
        this._rtprog.execute(ec);
        return ec;
    }

    public MLMatrix read(SparkSession sparkSession, String filePath, String format) throws IOException, DMLException, ParseException {
        this.reset();
        this.registerOutput("output");
        MLOutput out = this.executeScript("output = read(\"" + filePath + "\", format=\"" + format + "\"); " + MLMatrix.writeStmt);
        JavaPairRDD<MatrixIndexes, MatrixBlock> blocks = out.getBinaryBlockedRDD("output");
        MatrixCharacteristics mcOut = out.getMatrixCharacteristics("output");
        return MLMatrix.createMLMatrix(this, sparkSession, blocks, mcOut);
    }

    public MLMatrix read(SQLContext sqlContext, String filePath, String format) throws IOException, DMLException, ParseException {
        SparkSession sparkSession = sqlContext.sparkSession();
        return this.read(sparkSession, filePath, format);
    }
}

