/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;

public class VFSUtils
extends BaseUtils {
    private static final Log log = LogFactory.getLog(VFSUtils.class);
    private static final Pattern URL_PATTERN = Pattern.compile("[a-z]+://.*");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile(":(?:[^/]+)@");

    public static String getProperty(FileContent message, String property) {
        try {
            Object o = message.getAttributes().get(property);
            if (o instanceof String) {
                return (String)o;
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return null;
    }

    public static String getFileName(MessageContext msgCtx, VFSOutTransportInfo vfsOutInfo) {
        Parameter param;
        String fileName = null;
        Map transportHeaders = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        if (transportHeaders != null) {
            fileName = (String)transportHeaders.get("transport.vfs.ReplyFileName");
        }
        if (fileName == null && (param = msgCtx.getAxisService().getParameter("transport.vfs.ReplyFileName")) != null) {
            fileName = (String)param.getValue();
        }
        if (fileName == null) {
            fileName = vfsOutInfo.getOutFileName();
        }
        if (fileName == null) {
            fileName = "response.xml";
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean acquireLock(FileSystemManager fsManager, FileObject fo) {
        Random random = new Random();
        byte[] lockValue = String.valueOf(random.nextLong()).getBytes();
        try {
            FileObject lockObject;
            String fullPath = fo.getURL().toString();
            int pos = fullPath.indexOf("?");
            if (pos != -1) {
                fullPath = fullPath.substring(0, pos);
            }
            if ((lockObject = fsManager.resolveFile(fullPath + ".lock")).exists()) {
                log.debug((Object)("There seems to be an external lock, aborting the processing of the file " + fo.getName() + ". This could possibly be due to some other party already " + "processing this file or the file is still being uploaded"));
                return false;
            }
            lockObject.createFile();
            OutputStream stream = lockObject.getContent().getOutputStream();
            try {
                stream.write(lockValue);
                stream.flush();
                stream.close();
            }
            catch (IOException e) {
                lockObject.delete();
                log.debug((Object)("Couldn't create the lock file before processing the file " + fullPath), (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                lockObject.close();
            }
            FileObject verifyingLockObject = fsManager.resolveFile(fullPath + ".lock");
            if (!verifyingLockObject.exists()) return false;
            if (!VFSUtils.verifyLock(lockValue, verifyingLockObject)) return false;
            return true;
        }
        catch (FileSystemException fse) {
            log.debug((Object)("Cannot get the lock for the file : " + VFSUtils.maskURLPassword(fo.getName().getURI()) + " before processing"));
        }
        return false;
    }

    public static void releaseLock(FileSystemManager fsManager, FileObject fo) {
        try {
            FileObject lockObject = fsManager.resolveFile(fo.getURL().toString() + ".lock");
            if (lockObject.exists()) {
                lockObject.delete();
            }
        }
        catch (FileSystemException e) {
            log.error((Object)("Couldn't release the lock for the file : " + fo.getName() + " after processing"));
        }
    }

    public static String maskURLPassword(String url) {
        Matcher urlMatcher = URL_PATTERN.matcher(url);
        if (urlMatcher.find()) {
            Matcher pwdMatcher = PASSWORD_PATTERN.matcher(url);
            String maskUrl = pwdMatcher.replaceFirst("\":***@\"");
            return maskUrl;
        }
        return url;
    }

    private static boolean verifyLock(byte[] lockValue, FileObject lockObject) {
        try {
            InputStream is = lockObject.getContent().getInputStream();
            byte[] val = new byte[lockValue.length];
            is.read(val);
            if (Arrays.equals(lockValue, val) && is.read() == -1) {
                return true;
            }
            log.debug((Object)"The lock has been acquired by an another party");
        }
        catch (FileSystemException e) {
            log.debug((Object)"Couldn't verify the lock", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            log.debug((Object)"Couldn't verify the lock", (Throwable)e);
            return false;
        }
        return false;
    }
}

